/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CompactTables;
import org.apache.cassandra.db.Conflicts;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.LegacyLayout;
import org.apache.cassandra.db.MutableDeletionInfo;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.SinglePartitionSliceCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.UnknownColumnException;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.partitions.FilteredPartition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.locator.DynamicEndpointSnitch;
import org.apache.cassandra.metrics.ClientMetrics;
import org.apache.cassandra.scheduler.IRequestScheduler;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.service.CASRequest;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.pager.QueryPagers;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.CASResult;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.CfSplit;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ColumnSlice;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;
import org.apache.cassandra.thrift.CqlPreparedResult;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.MultiSliceRequest;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.cassandra.thrift.ThriftClientState;
import org.apache.cassandra.thrift.ThriftConversion;
import org.apache.cassandra.thrift.ThriftSessionManager;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.SearchIterator;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraServer
implements Cassandra.Iface {
    private static final Logger logger = LoggerFactory.getLogger(CassandraServer.class);
    private static final int COUNT_PAGE_SIZE = 1024;
    private static final List<ColumnOrSuperColumn> EMPTY_COLUMNS = Collections.emptyList();
    private final IRequestScheduler requestScheduler = DatabaseDescriptor.getRequestScheduler();

    public CassandraServer() {
        this.registerMetrics();
    }

    public ThriftClientState state() {
        return ThriftSessionManager.instance.currentSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PartitionIterator read(List<SinglePartitionReadCommand<?>> commands, org.apache.cassandra.db.ConsistencyLevel consistency_level, ClientState cState) throws org.apache.cassandra.exceptions.InvalidRequestException, UnavailableException, TimedOutException {
        this.schedule(DatabaseDescriptor.getReadRpcTimeout());
        try {
            PartitionIterator partitionIterator = StorageProxy.read(new SinglePartitionReadCommand.Group(commands, DataLimits.NONE), consistency_level, cState);
            this.release();
            return partitionIterator;
        }
        catch (Throwable throwable) {
            try {
                this.release();
                throw throwable;
            }
            catch (RequestExecutionException e) {
                throw ThriftConversion.rethrow(e);
            }
        }
    }

    public List<ColumnOrSuperColumn> thriftifyColumns(CFMetaData metadata, Iterator<LegacyLayout.LegacyCell> cells) {
        ArrayList<ColumnOrSuperColumn> thriftColumns = new ArrayList<ColumnOrSuperColumn>();
        while (cells.hasNext()) {
            LegacyLayout.LegacyCell cell = cells.next();
            thriftColumns.add(this.thriftifyColumnWithName(metadata, cell, cell.name.encode(metadata)));
        }
        return thriftColumns;
    }

    private ColumnOrSuperColumn thriftifyColumnWithName(CFMetaData metadata, LegacyLayout.LegacyCell cell, ByteBuffer newName) {
        if (cell.isCounter()) {
            return new ColumnOrSuperColumn().setCounter_column(this.thriftifySubCounter(metadata, cell).setName(newName));
        }
        return new ColumnOrSuperColumn().setColumn(this.thriftifySubColumn(cell, newName));
    }

    private Column thriftifySubColumn(CFMetaData metadata, LegacyLayout.LegacyCell cell) {
        return this.thriftifySubColumn(cell, cell.name.encode(metadata));
    }

    private Column thriftifySubColumn(LegacyLayout.LegacyCell cell, ByteBuffer name) {
        assert (!cell.isCounter());
        Column thrift_column = new Column(name).setValue(cell.value).setTimestamp(cell.timestamp);
        if (cell.isExpiring()) {
            thrift_column.setTtl(cell.ttl);
        }
        return thrift_column;
    }

    private List<Column> thriftifyColumnsAsColumns(CFMetaData metadata, Iterator<LegacyLayout.LegacyCell> cells) {
        ArrayList<Column> thriftColumns = new ArrayList<Column>();
        while (cells.hasNext()) {
            thriftColumns.add(this.thriftifySubColumn(metadata, cells.next()));
        }
        return thriftColumns;
    }

    private CounterColumn thriftifySubCounter(CFMetaData metadata, LegacyLayout.LegacyCell cell) {
        assert (cell.isCounter());
        return new CounterColumn(cell.name.encode(metadata), CounterContext.instance().total(cell.value));
    }

    private List<ColumnOrSuperColumn> thriftifySuperColumns(CFMetaData metadata, Iterator<LegacyLayout.LegacyCell> cells, boolean subcolumnsOnly, boolean isCounterCF, boolean reversed) {
        if (subcolumnsOnly) {
            ArrayList<ColumnOrSuperColumn> thriftSuperColumns = new ArrayList<ColumnOrSuperColumn>();
            while (cells.hasNext()) {
                LegacyLayout.LegacyCell cell = cells.next();
                thriftSuperColumns.add(this.thriftifyColumnWithName(metadata, cell, cell.name.superColumnSubName()));
            }
            if (reversed) {
                Collections.reverse(thriftSuperColumns);
            }
            return thriftSuperColumns;
        }
        if (isCounterCF) {
            return this.thriftifyCounterSuperColumns(metadata, cells, reversed);
        }
        return this.thriftifySuperColumns(cells, reversed);
    }

    private List<ColumnOrSuperColumn> thriftifySuperColumns(Iterator<LegacyLayout.LegacyCell> cells, boolean reversed) {
        ArrayList<ColumnOrSuperColumn> thriftSuperColumns = new ArrayList<ColumnOrSuperColumn>();
        SuperColumn current = null;
        while (cells.hasNext()) {
            LegacyLayout.LegacyCell cell = cells.next();
            ByteBuffer scName = cell.name.superColumnName();
            if (current == null || !scName.equals(current.bufferForName())) {
                if (current != null && reversed) {
                    Collections.reverse(current.columns);
                }
                current = new SuperColumn(scName, new ArrayList());
                thriftSuperColumns.add(new ColumnOrSuperColumn().setSuper_column(current));
            }
            current.getColumns().add(this.thriftifySubColumn(cell, cell.name.superColumnSubName()));
        }
        if (current != null && reversed) {
            Collections.reverse(current.columns);
        }
        return thriftSuperColumns;
    }

    private List<ColumnOrSuperColumn> thriftifyCounterSuperColumns(CFMetaData metadata, Iterator<LegacyLayout.LegacyCell> cells, boolean reversed) {
        ArrayList<ColumnOrSuperColumn> thriftSuperColumns = new ArrayList<ColumnOrSuperColumn>();
        CounterSuperColumn current = null;
        while (cells.hasNext()) {
            LegacyLayout.LegacyCell cell = cells.next();
            ByteBuffer scName = cell.name.superColumnName();
            if (current == null || !scName.equals(current.bufferForName())) {
                if (current != null && reversed) {
                    Collections.reverse(current.columns);
                }
                current = new CounterSuperColumn(scName, new ArrayList());
                thriftSuperColumns.add(new ColumnOrSuperColumn().setCounter_super_column(current));
            }
            current.getColumns().add(this.thriftifySubCounter(metadata, cell).setName(cell.name.superColumnSubName()));
        }
        return thriftSuperColumns;
    }

    private List<ColumnOrSuperColumn> thriftifyPartition(RowIterator partition, boolean subcolumnsOnly, boolean reversed, int cellLimit) {
        List<ColumnOrSuperColumn> result;
        if (partition.isEmpty()) {
            return EMPTY_COLUMNS;
        }
        Iterator cells = (Iterator)LegacyLayout.fromRowIterator((RowIterator)partition).right;
        if (partition.metadata().isSuper()) {
            boolean isCounterCF = partition.metadata().isCounter();
            result = this.thriftifySuperColumns(partition.metadata(), cells, subcolumnsOnly, isCounterCF, reversed);
        } else {
            result = this.thriftifyColumns(partition.metadata(), cells);
        }
        return result.size() > cellLimit ? result.subList(0, cellLimit) : result;
    }

    private Map<ByteBuffer, List<ColumnOrSuperColumn>> getSlice(List<SinglePartitionReadCommand<?>> commands, boolean subColumnsOnly, int cellLimit, org.apache.cassandra.db.ConsistencyLevel consistency_level, ClientState cState) throws org.apache.cassandra.exceptions.InvalidRequestException, UnavailableException, TimedOutException {
        try (PartitionIterator results = this.read(commands, consistency_level, cState);){
            HashMap<ByteBuffer, List<ColumnOrSuperColumn>> columnFamiliesMap = new HashMap<ByteBuffer, List<ColumnOrSuperColumn>>();
            while (results.hasNext()) {
                RowIterator iter = (RowIterator)results.next();
                Throwable throwable = null;
                try {
                    List<ColumnOrSuperColumn> thriftifiedColumns = this.thriftifyPartition(iter, subColumnsOnly, iter.isReverseOrder(), cellLimit);
                    columnFamiliesMap.put(iter.partitionKey().getKey(), thriftifiedColumns);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iter == null) continue;
                    if (throwable != null) {
                        try {
                            iter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iter.close();
                }
            }
            HashMap<ByteBuffer, List<ColumnOrSuperColumn>> hashMap = columnFamiliesMap;
            return hashMap;
        }
    }

    public List<ColumnOrSuperColumn> get_slice(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(key), (Object)"column_parent", (Object)column_parent.toString(), (Object)"predicate", (Object)predicate.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("get_slice", (Map<String, String>)traceParameters);
        } else {
            logger.debug("get_slice");
        }
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            this.state().hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.SELECT);
            List<ColumnOrSuperColumn> result = this.getSliceInternal(keyspace, key, column_parent, FBUtilities.nowInSeconds(), predicate, consistency_level, cState);
            List<ColumnOrSuperColumn> list = result == null ? Collections.emptyList() : result;
            return list;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    private List<ColumnOrSuperColumn> getSliceInternal(String keyspace, ByteBuffer key, ColumnParent column_parent, int nowInSec, SlicePredicate predicate, ConsistencyLevel consistency_level, ClientState cState) throws org.apache.cassandra.exceptions.InvalidRequestException, UnavailableException, TimedOutException {
        return this.multigetSliceInternal(keyspace, Collections.singletonList(key), column_parent, nowInSec, predicate, consistency_level, cState).get(key);
    }

    public Map<ByteBuffer, List<ColumnOrSuperColumn>> multiget_slice(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ArrayList keysList = Lists.newArrayList();
            for (ByteBuffer key : keys) {
                keysList.add(ByteBufferUtil.bytesToHex(key));
            }
            ImmutableMap traceParameters = ImmutableMap.of((Object)"keys", (Object)((Object)keysList).toString(), (Object)"column_parent", (Object)column_parent.toString(), (Object)"predicate", (Object)predicate.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("multiget_slice", (Map<String, String>)traceParameters);
        } else {
            logger.debug("multiget_slice");
        }
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.SELECT);
            Map<ByteBuffer, List<ColumnOrSuperColumn>> map = this.multigetSliceInternal(keyspace, keys, column_parent, FBUtilities.nowInSeconds(), predicate, consistency_level, cState);
            return map;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    private ClusteringIndexFilter toInternalFilter(CFMetaData metadata, ColumnParent parent, SliceRange range) {
        if (metadata.isSuper() && parent.isSetSuper_column()) {
            return new ClusteringIndexNamesFilter(FBUtilities.singleton(new Clustering(parent.bufferForSuper_column()), metadata.comparator), range.reversed);
        }
        return new ClusteringIndexSliceFilter(this.makeSlices(metadata, range), range.reversed);
    }

    private Slices makeSlices(CFMetaData metadata, SliceRange range) {
        ByteBuffer start = range.reversed ? range.finish : range.start;
        ByteBuffer finish = range.reversed ? range.start : range.finish;
        return Slices.with(metadata.comparator, Slice.make(LegacyLayout.decodeBound((CFMetaData)metadata, (ByteBuffer)start, (boolean)true).bound, LegacyLayout.decodeBound((CFMetaData)metadata, (ByteBuffer)finish, (boolean)false).bound));
    }

    private ClusteringIndexFilter toInternalFilter(CFMetaData metadata, ColumnParent parent, SlicePredicate predicate) throws org.apache.cassandra.exceptions.InvalidRequestException {
        try {
            if (predicate.column_names != null) {
                if (metadata.isSuper()) {
                    if (parent.isSetSuper_column()) {
                        return new ClusteringIndexNamesFilter(FBUtilities.singleton(new Clustering(parent.bufferForSuper_column()), metadata.comparator), false);
                    }
                    TreeSet<Clusterable> clusterings = new TreeSet<Clusterable>(metadata.comparator);
                    for (ByteBuffer bb : predicate.column_names) {
                        clusterings.add(new Clustering(bb));
                    }
                    return new ClusteringIndexNamesFilter(clusterings, false);
                }
                TreeSet<Clusterable> clusterings = new TreeSet<Clusterable>(metadata.comparator);
                for (ByteBuffer bb : predicate.column_names) {
                    LegacyLayout.LegacyCellName name = LegacyLayout.decodeCellName(metadata, parent.bufferForSuper_column(), bb);
                    clusterings.add(name.clustering);
                }
                return new ClusteringIndexNamesFilter(clusterings, false);
            }
            return this.toInternalFilter(metadata, parent, predicate.slice_range);
        }
        catch (UnknownColumnException e) {
            throw new org.apache.cassandra.exceptions.InvalidRequestException(e.getMessage());
        }
    }

    private ColumnFilter makeColumnFilter(CFMetaData metadata, ColumnParent parent, SliceRange range) {
        if (metadata.isSuper() && parent.isSetSuper_column()) {
            ColumnFilter.Builder builder = ColumnFilter.selectionBuilder();
            ColumnDefinition def = metadata.compactValueColumn();
            ByteBuffer start = range.reversed ? range.finish : range.start;
            ByteBuffer finish = range.reversed ? range.start : range.finish;
            builder.slice(def, start.hasRemaining() ? CellPath.create(start) : CellPath.BOTTOM, finish.hasRemaining() ? CellPath.create(finish) : CellPath.TOP);
            AbstractType<?> cmp = metadata.thriftColumnNameType();
            for (ColumnDefinition column : metadata.partitionColumns()) {
                ByteBuffer name;
                if (CompactTables.isSuperColumnMapColumn(column) || cmp.compare(name = column.name.bytes, start) < 0 || cmp.compare(finish, name) > 0) continue;
                builder.add(column);
            }
            return builder.build();
        }
        return this.makeColumnFilter(metadata, this.makeSlices(metadata, range));
    }

    private ColumnFilter makeColumnFilter(CFMetaData metadata, Slices slices) {
        PartitionColumns columns = metadata.partitionColumns();
        if (metadata.isStaticCompactTable() && !columns.statics.isEmpty()) {
            PartitionColumns.Builder builder = PartitionColumns.builder();
            builder.addAll(columns.regulars);
            for (ColumnDefinition def : columns.statics) {
                if (!slices.selects(new Clustering(def.name.bytes))) continue;
                builder.add(def);
            }
            columns = builder.build();
        }
        return ColumnFilter.selection(columns);
    }

    private ColumnFilter makeColumnFilter(CFMetaData metadata, ColumnParent parent, SlicePredicate predicate) throws org.apache.cassandra.exceptions.InvalidRequestException {
        try {
            if (predicate.column_names != null) {
                if (metadata.isSuper()) {
                    if (parent.isSetSuper_column()) {
                        ColumnFilter.Builder builder = ColumnFilter.selectionBuilder();
                        ColumnDefinition dynamicDef = metadata.compactValueColumn();
                        for (ByteBuffer bb : predicate.column_names) {
                            ColumnDefinition staticDef = metadata.getColumnDefinition(bb);
                            if (staticDef == null) {
                                builder.select(dynamicDef, CellPath.create(bb));
                                continue;
                            }
                            builder.add(staticDef);
                        }
                        return builder.build();
                    }
                    return ColumnFilter.all(metadata);
                }
                PartitionColumns.Builder builder = new PartitionColumns.Builder();
                for (ByteBuffer bb : predicate.column_names) {
                    LegacyLayout.LegacyCellName name = LegacyLayout.decodeCellName(metadata, parent.bufferForSuper_column(), bb);
                    builder.add(name.column);
                }
                return ColumnFilter.selection(builder.build());
            }
            return this.makeColumnFilter(metadata, parent, predicate.slice_range);
        }
        catch (UnknownColumnException e) {
            throw new org.apache.cassandra.exceptions.InvalidRequestException(e.getMessage());
        }
    }

    private DataLimits getLimits(int partitionLimit, boolean countSuperColumns, SlicePredicate predicate) {
        int cellsPerPartition = predicate.slice_range == null ? Integer.MAX_VALUE : predicate.slice_range.count;
        return this.getLimits(partitionLimit, countSuperColumns, cellsPerPartition);
    }

    private DataLimits getLimits(int partitionLimit, boolean countSuperColumns, int perPartitionCount) {
        return countSuperColumns ? DataLimits.superColumnCountingLimits(partitionLimit, perPartitionCount) : DataLimits.thriftLimits(partitionLimit, perPartitionCount);
    }

    private Map<ByteBuffer, List<ColumnOrSuperColumn>> multigetSliceInternal(String keyspace, List<ByteBuffer> keys, ColumnParent column_parent, int nowInSec, SlicePredicate predicate, ConsistencyLevel consistency_level, ClientState cState) throws org.apache.cassandra.exceptions.InvalidRequestException, UnavailableException, TimedOutException {
        CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_parent.column_family);
        ThriftValidation.validateColumnParent(metadata, column_parent);
        ThriftValidation.validatePredicate(metadata, column_parent, predicate);
        org.apache.cassandra.db.ConsistencyLevel consistencyLevel = ThriftConversion.fromThrift(consistency_level);
        consistencyLevel.validateForRead(keyspace);
        ArrayList commands = new ArrayList(keys.size());
        ColumnFilter columnFilter = this.makeColumnFilter(metadata, column_parent, predicate);
        ClusteringIndexFilter filter = this.toInternalFilter(metadata, column_parent, predicate);
        DataLimits limits = this.getLimits(1, metadata.isSuper() && !column_parent.isSetSuper_column(), predicate);
        for (ByteBuffer key : keys) {
            ThriftValidation.validateKey(metadata, key);
            DecoratedKey dk = metadata.decorateKey(key);
            commands.add(SinglePartitionReadCommand.create(true, metadata, nowInSec, columnFilter, RowFilter.NONE, limits, dk, filter));
        }
        return this.getSlice(commands, column_parent.isSetSuper_column(), limits.perPartitionCount(), consistencyLevel, cState);
    }

    /*
     * Exception decompiling
     */
    public ColumnOrSuperColumn get(ByteBuffer key, ColumnPath column_path, ConsistencyLevel consistency_level) throws InvalidRequestException, NotFoundException, UnavailableException, TimedOutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int get_count(ByteBuffer key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(key), (Object)"column_parent", (Object)column_parent.toString(), (Object)"predicate", (Object)predicate.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("get_count", (Map<String, String>)traceParameters);
        } else {
            logger.debug("get_count");
        }
        try {
            ClusteringIndexFilter filter;
            ColumnFilter columnFilter;
            int pageSize;
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.SELECT);
            Keyspace keyspaceName = Keyspace.open(keyspace);
            ColumnFamilyStore cfs = keyspaceName.getColumnFamilyStore(column_parent.column_family);
            int nowInSec = FBUtilities.nowInSeconds();
            if (predicate.column_names != null) {
                int n = this.getSliceInternal(keyspace, key, column_parent, nowInSec, predicate, consistency_level, cState).size();
                return n;
            }
            if (cfs.getMeanColumns() > 0) {
                int averageColumnSize = (int)((Long)cfs.metric.meanPartitionSize.getValue() / (long)cfs.getMeanColumns());
                pageSize = Math.min(1024, 0x400000 / averageColumnSize);
                pageSize = Math.max(2, pageSize);
                logger.debug("average row column size is {}; using pageSize of {}", (Object)averageColumnSize, (Object)pageSize);
            } else {
                pageSize = 1024;
            }
            SliceRange sliceRange = predicate.slice_range == null ? new SliceRange(ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, Integer.MAX_VALUE) : predicate.slice_range;
            CFMetaData metadata = cfs.metadata;
            if (metadata.isSuper() && !column_parent.isSetSuper_column()) {
                columnFilter = ColumnFilter.all(metadata);
                filter = new ClusteringIndexSliceFilter(this.makeSlices(metadata, sliceRange), sliceRange.reversed);
            } else {
                columnFilter = this.makeColumnFilter(metadata, column_parent, sliceRange);
                filter = this.toInternalFilter(metadata, column_parent, sliceRange);
            }
            DataLimits limits = this.getLimits(1, metadata.isSuper() && !column_parent.isSetSuper_column(), predicate);
            DecoratedKey dk = metadata.decorateKey(key);
            int n = QueryPagers.countPaged(metadata, dk, columnFilter, filter, limits, ThriftConversion.fromThrift(consistency_level), cState, pageSize, nowInSec, true);
            return n;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRequestException(e.getMessage());
        }
        catch (RequestExecutionException e) {
            throw ThriftConversion.rethrow(e);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public Map<ByteBuffer, Integer> multiget_count(List<ByteBuffer> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ArrayList keysList = Lists.newArrayList();
            for (ByteBuffer key : keys) {
                keysList.add(ByteBufferUtil.bytesToHex(key));
            }
            ImmutableMap traceParameters = ImmutableMap.of((Object)"keys", (Object)((Object)keysList).toString(), (Object)"column_parent", (Object)column_parent.toString(), (Object)"predicate", (Object)predicate.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("multiget_count", (Map<String, String>)traceParameters);
        } else {
            logger.debug("multiget_count");
        }
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.SELECT);
            HashMap<ByteBuffer, Integer> counts = new HashMap<ByteBuffer, Integer>();
            Map<ByteBuffer, List<ColumnOrSuperColumn>> columnFamiliesMap = this.multigetSliceInternal(keyspace, keys, column_parent, FBUtilities.nowInSeconds(), predicate, consistency_level, cState);
            for (Map.Entry<ByteBuffer, List<ColumnOrSuperColumn>> cf : columnFamiliesMap.entrySet()) {
                counts.put(cf.getKey(), cf.getValue().size());
            }
            HashMap<ByteBuffer, Integer> hashMap = counts;
            return hashMap;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    private Cell cellFromColumn(CFMetaData metadata, LegacyLayout.LegacyCellName name, Column column) {
        CellPath path = name.collectionElement == null ? null : CellPath.create(name.collectionElement);
        return column.ttl == 0 ? BufferCell.live(metadata, name.column, column.timestamp, column.value, path) : BufferCell.expiring(name.column, column.timestamp, column.ttl, FBUtilities.nowInSeconds(), column.value, path);
    }

    private void internal_insert(ByteBuffer key, ColumnParent column_parent, Column column, ConsistencyLevel consistency_level) throws RequestValidationException, UnavailableException, TimedOutException {
        org.apache.cassandra.db.Mutation mutation;
        ThriftClientState cState = this.state();
        String keyspace = cState.getKeyspace();
        cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.MODIFY);
        CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_parent.column_family, false);
        if (metadata.isMaterializedView()) {
            throw new org.apache.cassandra.exceptions.InvalidRequestException("Cannot modify Materialized Views directly");
        }
        ThriftValidation.validateKey(metadata, key);
        ThriftValidation.validateColumnParent(metadata, column_parent);
        if (metadata.isSuper() && column_parent.super_column == null) {
            throw new org.apache.cassandra.exceptions.InvalidRequestException("missing mandatory super column name for super CF " + column_parent.column_family);
        }
        ThriftValidation.validateColumnNames(metadata, column_parent, Collections.singletonList(column.name));
        ThriftValidation.validateColumnData(metadata, column_parent.super_column, column);
        try {
            LegacyLayout.LegacyCellName name = LegacyLayout.decodeCellName(metadata, column_parent.super_column, column.name);
            Cell cell = this.cellFromColumn(metadata, name, column);
            PartitionUpdate update = PartitionUpdate.singleRowUpdate(metadata, key, (Row)BTreeRow.singleCellRow(name.clustering, cell));
            Keyspace.open((String)metadata.ksName).getColumnFamilyStore((String)metadata.cfName).indexManager.validate(update);
            mutation = new org.apache.cassandra.db.Mutation(update);
        }
        catch (UnknownColumnException | MarshalException e) {
            throw new org.apache.cassandra.exceptions.InvalidRequestException(e.getMessage());
        }
        this.doInsert(consistency_level, Collections.singletonList(mutation));
    }

    public void insert(ByteBuffer key, ColumnParent column_parent, Column column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(key), (Object)"column_parent", (Object)column_parent.toString(), (Object)"column", (Object)column.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("insert", (Map<String, String>)traceParameters);
        } else {
            logger.debug("insert");
        }
        try {
            this.internal_insert(key, column_parent, column, consistency_level);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    /*
     * Exception decompiling
     */
    public CASResult cas(ByteBuffer key, String column_family, List<Column> expected, List<Column> updates, ConsistencyLevel serial_consistency_level, ConsistencyLevel commit_consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private LegacyLayout.LegacyCell toLegacyCell(CFMetaData metadata, Column column, int nowInSec) throws UnknownColumnException {
        return this.toLegacyCell(metadata, null, column, nowInSec);
    }

    private LegacyLayout.LegacyCell toLegacyCell(CFMetaData metadata, ByteBuffer superColumnName, Column column, int nowInSec) throws UnknownColumnException {
        return column.ttl > 0 ? LegacyLayout.LegacyCell.expiring(metadata, superColumnName, column.name, column.value, column.timestamp, column.ttl, nowInSec) : LegacyLayout.LegacyCell.regular(metadata, superColumnName, column.name, column.value, column.timestamp);
    }

    private LegacyLayout.LegacyCell toLegacyDeletion(CFMetaData metadata, ByteBuffer name, long timestamp, int nowInSec) throws UnknownColumnException {
        return this.toLegacyDeletion(metadata, null, name, timestamp, nowInSec);
    }

    private LegacyLayout.LegacyCell toLegacyDeletion(CFMetaData metadata, ByteBuffer superColumnName, ByteBuffer name, long timestamp, int nowInSec) throws UnknownColumnException {
        return LegacyLayout.LegacyCell.tombstone(metadata, superColumnName, name, timestamp, nowInSec);
    }

    private LegacyLayout.LegacyCell toCounterLegacyCell(CFMetaData metadata, CounterColumn column) throws UnknownColumnException {
        return this.toCounterLegacyCell(metadata, null, column);
    }

    private LegacyLayout.LegacyCell toCounterLegacyCell(CFMetaData metadata, ByteBuffer superColumnName, CounterColumn column) throws UnknownColumnException {
        return LegacyLayout.LegacyCell.counter(metadata, superColumnName, column.name, column.value);
    }

    private void sortAndMerge(CFMetaData metadata, List<LegacyLayout.LegacyCell> cells, int nowInSec) {
        Collections.sort(cells, LegacyLayout.legacyCellComparator(metadata));
        Comparator<LegacyLayout.LegacyCellName> comparator = LegacyLayout.legacyCellNameComparator(metadata, false);
        int previous = 0;
        for (int current = 1; current < cells.size(); ++current) {
            LegacyLayout.LegacyCell pc = cells.get(previous);
            LegacyLayout.LegacyCell cc = cells.get(current);
            int cmp = comparator.compare(pc.name, cc.name);
            if (cmp == 0) {
                Conflicts.Resolution res = metadata.isCounter() ? Conflicts.resolveCounter(pc.timestamp, pc.isLive(nowInSec), pc.value, cc.timestamp, cc.isLive(nowInSec), cc.value) : Conflicts.resolveRegular(pc.timestamp, pc.isLive(nowInSec), pc.localDeletionTime, pc.value, cc.timestamp, cc.isLive(nowInSec), cc.localDeletionTime, cc.value);
                switch (res) {
                    case LEFT_WINS: {
                        break;
                    }
                    case RIGHT_WINS: {
                        cells.set(previous, cc);
                        break;
                    }
                    case MERGE: {
                        assert (metadata.isCounter());
                        ByteBuffer merged = Conflicts.mergeCounterValues(pc.value, cc.value);
                        cells.set(previous, LegacyLayout.LegacyCell.counter(pc.name, merged));
                    }
                }
                continue;
            }
            if (++previous == current) continue;
            cells.set(previous, cc);
        }
        for (int i = cells.size() - 1; i > previous; --i) {
            cells.remove(i);
        }
    }

    private List<LegacyLayout.LegacyCell> toLegacyCells(CFMetaData metadata, List<Column> columns, int nowInSec) throws UnknownColumnException {
        ArrayList<LegacyLayout.LegacyCell> cells = new ArrayList<LegacyLayout.LegacyCell>(columns.size());
        for (Column column : columns) {
            cells.add(this.toLegacyCell(metadata, column, nowInSec));
        }
        this.sortAndMerge(metadata, cells, nowInSec);
        return cells;
    }

    private List<IMutation> createMutationList(ConsistencyLevel consistency_level, Map<ByteBuffer, Map<String, List<Mutation>>> mutation_map, boolean allowCounterMutations) throws RequestValidationException, InvalidRequestException {
        ArrayList<IMutation> mutations = new ArrayList<IMutation>();
        ThriftClientState cState = this.state();
        String keyspace = cState.getKeyspace();
        int nowInSec = FBUtilities.nowInSeconds();
        for (Map.Entry<ByteBuffer, Map<String, List<Mutation>>> mutationEntry : mutation_map.entrySet()) {
            ByteBuffer key = mutationEntry.getKey();
            org.apache.cassandra.db.Mutation standardMutation = null;
            org.apache.cassandra.db.Mutation counterMutation = null;
            Map<String, List<Mutation>> columnFamilyToMutations = mutationEntry.getValue();
            for (Map.Entry<String, List<Mutation>> columnFamilyMutations : columnFamilyToMutations.entrySet()) {
                String cfName = columnFamilyMutations.getKey();
                List<Mutation> muts = columnFamilyMutations.getValue();
                cState.hasColumnFamilyAccess(keyspace, cfName, Permission.MODIFY);
                CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, cfName);
                if (metadata.isMaterializedView()) {
                    throw new org.apache.cassandra.exceptions.InvalidRequestException("Cannot modify Materialized Views directly");
                }
                ThriftValidation.validateKey(metadata, key);
                if (metadata.isCounter()) {
                    ThriftConversion.fromThrift(consistency_level).validateCounterForWrite(metadata);
                }
                MutableDeletionInfo delInfo = MutableDeletionInfo.live();
                ArrayList<LegacyLayout.LegacyCell> cells = new ArrayList<LegacyLayout.LegacyCell>();
                for (Mutation m : muts) {
                    ThriftValidation.validateMutation(metadata, m);
                    if (m.deletion != null) {
                        this.deleteColumnOrSuperColumn(delInfo, cells, metadata, m.deletion, nowInSec);
                    }
                    if (m.column_or_supercolumn == null) continue;
                    this.addColumnOrSuperColumn(cells, metadata, m.column_or_supercolumn, nowInSec);
                }
                this.sortAndMerge(metadata, cells, nowInSec);
                DecoratedKey dk = metadata.decorateKey(key);
                PartitionUpdate update = PartitionUpdate.fromIterator(LegacyLayout.toUnfilteredRowIterator(metadata, dk, delInfo, cells.iterator()));
                Keyspace.open((String)metadata.ksName).getColumnFamilyStore((String)metadata.cfName).indexManager.validate(update);
                org.apache.cassandra.db.Mutation mutation = metadata.isCounter() ? (counterMutation = counterMutation == null ? new org.apache.cassandra.db.Mutation(keyspace, dk) : counterMutation) : (standardMutation = standardMutation == null ? new org.apache.cassandra.db.Mutation(keyspace, dk) : standardMutation);
                mutation.add(update);
            }
            if (standardMutation != null && !standardMutation.isEmpty()) {
                mutations.add(standardMutation);
            }
            if (counterMutation == null || counterMutation.isEmpty()) continue;
            if (allowCounterMutations) {
                mutations.add(new CounterMutation(counterMutation, ThriftConversion.fromThrift(consistency_level)));
                continue;
            }
            throw new org.apache.cassandra.exceptions.InvalidRequestException("Counter mutations are not allowed in atomic batches");
        }
        return mutations;
    }

    private void addColumnOrSuperColumn(List<LegacyLayout.LegacyCell> cells, CFMetaData cfm, ColumnOrSuperColumn cosc, int nowInSec) throws InvalidRequestException {
        try {
            if (cosc.super_column != null) {
                for (Column column : cosc.super_column.columns) {
                    cells.add(this.toLegacyCell(cfm, cosc.super_column.name, column, nowInSec));
                }
            } else if (cosc.column != null) {
                cells.add(this.toLegacyCell(cfm, cosc.column, nowInSec));
            } else if (cosc.counter_super_column != null) {
                for (CounterColumn column : cosc.counter_super_column.columns) {
                    cells.add(this.toCounterLegacyCell(cfm, cosc.counter_super_column.name, column));
                }
            } else {
                cells.add(this.toCounterLegacyCell(cfm, cosc.counter_column));
            }
        }
        catch (UnknownColumnException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    private void addRange(CFMetaData cfm, MutableDeletionInfo delInfo, Slice.Bound start, Slice.Bound end, long timestamp, int nowInSec) {
        delInfo.add(new RangeTombstone(Slice.make(start, end), new DeletionTime(timestamp, nowInSec)), cfm.comparator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteColumnOrSuperColumn(MutableDeletionInfo delInfo, List<LegacyLayout.LegacyCell> cells, CFMetaData cfm, Deletion del, int nowInSec) throws InvalidRequestException {
        if (del.predicate != null && del.predicate.column_names != null) {
            for (ByteBuffer c : del.predicate.column_names) {
                try {
                    if (del.super_column == null && cfm.isSuper()) {
                        this.addRange(cfm, delInfo, Slice.Bound.inclusiveStartOf(c), Slice.Bound.inclusiveEndOf(c), del.timestamp, nowInSec);
                        continue;
                    }
                    if (del.super_column != null) {
                        cells.add(this.toLegacyDeletion(cfm, del.super_column, c, del.timestamp, nowInSec));
                        continue;
                    }
                    cells.add(this.toLegacyDeletion(cfm, c, del.timestamp, nowInSec));
                }
                catch (UnknownColumnException e) {
                    throw new InvalidRequestException(e.getMessage());
                }
            }
            return;
        } else if (del.predicate != null && del.predicate.slice_range != null) {
            if (del.super_column != null) throw new InvalidRequestException("Cannot delete a range of subcolumns in a super column");
            this.addRange(cfm, delInfo, LegacyLayout.decodeBound((CFMetaData)cfm, (ByteBuffer)del.predicate.getSlice_range().start, (boolean)true).bound, LegacyLayout.decodeBound((CFMetaData)cfm, (ByteBuffer)del.predicate.getSlice_range().finish, (boolean)false).bound, del.timestamp, nowInSec);
            return;
        } else if (del.super_column != null) {
            this.addRange(cfm, delInfo, Slice.Bound.inclusiveStartOf(del.super_column), Slice.Bound.inclusiveEndOf(del.super_column), del.timestamp, nowInSec);
            return;
        } else {
            delInfo.add(new DeletionTime(del.timestamp, nowInSec));
        }
    }

    public void batch_mutate(Map<ByteBuffer, Map<String, List<Mutation>>> mutation_map, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            LinkedHashMap traceParameters = Maps.newLinkedHashMap();
            for (Map.Entry<ByteBuffer, Map<String, List<Mutation>>> mutationEntry : mutation_map.entrySet()) {
                traceParameters.put(ByteBufferUtil.bytesToHex(mutationEntry.getKey()), Joiner.on((String)";").withKeyValueSeparator(":").join(mutationEntry.getValue()));
            }
            traceParameters.put("consistency_level", consistency_level.name());
            Tracing.instance.begin("batch_mutate", traceParameters);
        } else {
            logger.debug("batch_mutate");
        }
        try {
            this.doInsert(consistency_level, this.createMutationList(consistency_level, mutation_map, true));
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public void atomic_batch_mutate(Map<ByteBuffer, Map<String, List<Mutation>>> mutation_map, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            LinkedHashMap traceParameters = Maps.newLinkedHashMap();
            for (Map.Entry<ByteBuffer, Map<String, List<Mutation>>> mutationEntry : mutation_map.entrySet()) {
                traceParameters.put(ByteBufferUtil.bytesToHex(mutationEntry.getKey()), Joiner.on((String)";").withKeyValueSeparator(":").join(mutationEntry.getValue()));
            }
            traceParameters.put("consistency_level", consistency_level.name());
            Tracing.instance.begin("atomic_batch_mutate", traceParameters);
        } else {
            logger.debug("atomic_batch_mutate");
        }
        try {
            this.doInsert(consistency_level, this.createMutationList(consistency_level, mutation_map, false), true);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    private void internal_remove(ByteBuffer key, ColumnPath column_path, long timestamp, ConsistencyLevel consistency_level, boolean isCommutativeOp) throws RequestValidationException, UnavailableException, TimedOutException {
        PartitionUpdate update;
        ThriftClientState cState = this.state();
        String keyspace = cState.getKeyspace();
        cState.hasColumnFamilyAccess(keyspace, column_path.column_family, Permission.MODIFY);
        CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_path.column_family, isCommutativeOp);
        if (metadata.isMaterializedView()) {
            throw new org.apache.cassandra.exceptions.InvalidRequestException("Cannot modify Materialized Views directly");
        }
        ThriftValidation.validateKey(metadata, key);
        ThriftValidation.validateColumnPathOrParent(metadata, column_path);
        if (isCommutativeOp) {
            ThriftConversion.fromThrift(consistency_level).validateCounterForWrite(metadata);
        }
        DecoratedKey dk = metadata.decorateKey(key);
        int nowInSec = FBUtilities.nowInSeconds();
        if (column_path.super_column == null && column_path.column == null) {
            update = PartitionUpdate.fullPartitionDelete(metadata, dk, timestamp, nowInSec);
        } else if (column_path.super_column != null && column_path.column == null) {
            BTreeRow row = BTreeRow.emptyDeletedRow(new Clustering(column_path.super_column), new DeletionTime(timestamp, nowInSec));
            update = PartitionUpdate.singleRowUpdate(metadata, dk, (Row)row);
        } else {
            try {
                LegacyLayout.LegacyCellName name = LegacyLayout.decodeCellName(metadata, column_path.super_column, column_path.column);
                CellPath path = name.collectionElement == null ? null : CellPath.create(name.collectionElement);
                BufferCell cell = BufferCell.tombstone(name.column, timestamp, nowInSec, path);
                update = PartitionUpdate.singleRowUpdate(metadata, dk, (Row)BTreeRow.singleCellRow(name.clustering, cell));
            }
            catch (UnknownColumnException e) {
                throw new org.apache.cassandra.exceptions.InvalidRequestException(e.getMessage());
            }
        }
        org.apache.cassandra.db.Mutation mutation = new org.apache.cassandra.db.Mutation(update);
        if (isCommutativeOp) {
            this.doInsert(consistency_level, Collections.singletonList(new CounterMutation(mutation, ThriftConversion.fromThrift(consistency_level))));
        } else {
            this.doInsert(consistency_level, Collections.singletonList(mutation));
        }
    }

    public void remove(ByteBuffer key, ColumnPath column_path, long timestamp, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(key), (Object)"column_path", (Object)column_path.toString(), (Object)"timestamp", (Object)(timestamp + ""), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("remove", (Map<String, String>)traceParameters);
        } else {
            logger.debug("remove");
        }
        try {
            this.internal_remove(key, column_path, timestamp, consistency_level, false);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    private void doInsert(ConsistencyLevel consistency_level, List<? extends IMutation> mutations) throws UnavailableException, TimedOutException, org.apache.cassandra.exceptions.InvalidRequestException {
        this.doInsert(consistency_level, mutations, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInsert(ConsistencyLevel consistency_level, List<? extends IMutation> mutations, boolean mutateAtomically) throws UnavailableException, TimedOutException, org.apache.cassandra.exceptions.InvalidRequestException {
        org.apache.cassandra.db.ConsistencyLevel consistencyLevel = ThriftConversion.fromThrift(consistency_level);
        consistencyLevel.validateForWrite(this.state().getKeyspace());
        if (mutations.isEmpty()) {
            return;
        }
        long timeout = Long.MAX_VALUE;
        for (IMutation iMutation : mutations) {
            timeout = Longs.min((long[])new long[]{timeout, iMutation.getTimeout()});
        }
        this.schedule(timeout);
        try {
            StorageProxy.mutateWithTriggers(mutations, consistencyLevel, mutateAtomically);
        }
        catch (RequestExecutionException e) {
            ThriftConversion.rethrow(e);
        }
        finally {
            this.release();
        }
    }

    private void validateLogin() throws InvalidRequestException {
        try {
            this.state().validateLogin();
        }
        catch (UnauthorizedException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    public KsDef describe_keyspace(String keyspaceName) throws NotFoundException, InvalidRequestException {
        this.validateLogin();
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(keyspaceName);
        if (ksm == null) {
            throw new NotFoundException();
        }
        return ThriftConversion.toThrift(ksm);
    }

    /*
     * Exception decompiling
     */
    public List<KeySlice> get_range_slices(ColumnParent column_parent, SlicePredicate predicate, KeyRange range, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<KeySlice> get_paged_slice(String column_family, KeyRange range, ByteBuffer start_column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<KeySlice> thriftifyKeySlices(PartitionIterator results, ColumnParent column_parent, int cellLimit) {
        try (PartitionIterator iter = results;){
            ArrayList<KeySlice> keySlices = new ArrayList<KeySlice>();
            while (iter.hasNext()) {
                RowIterator partition = (RowIterator)iter.next();
                Throwable throwable = null;
                try {
                    List<ColumnOrSuperColumn> thriftifiedColumns = this.thriftifyPartition(partition, column_parent.super_column != null, partition.isReverseOrder(), cellLimit);
                    keySlices.add(new KeySlice(partition.partitionKey().getKey(), thriftifiedColumns));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (partition == null) continue;
                    if (throwable != null) {
                        try {
                            partition.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    partition.close();
                }
            }
            ArrayList<KeySlice> arrayList = keySlices;
            return arrayList;
        }
    }

    /*
     * Exception decompiling
     */
    public List<KeySlice> get_indexed_slices(ColumnParent column_parent, IndexClause index_clause, SlicePredicate column_predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<KsDef> describe_keyspaces() throws TException, InvalidRequestException {
        this.validateLogin();
        Set<String> keyspaces = Schema.instance.getKeyspaces();
        ArrayList<KsDef> ksset = new ArrayList<KsDef>(keyspaces.size());
        for (String ks : keyspaces) {
            try {
                ksset.add(this.describe_keyspace(ks));
            }
            catch (NotFoundException nfe) {
                logger.info("Failed to find metadata for keyspace '{}'. Continuing... ", (Object)ks);
            }
        }
        return ksset;
    }

    public String describe_cluster_name() throws TException {
        return DatabaseDescriptor.getClusterName();
    }

    public String describe_version() throws TException {
        return "20.1.0";
    }

    public List<TokenRange> describe_ring(String keyspace) throws InvalidRequestException {
        try {
            return StorageService.instance.describeRing(keyspace);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public List<TokenRange> describe_local_ring(String keyspace) throws InvalidRequestException, TException {
        try {
            return StorageService.instance.describeLocalRing(keyspace);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public Map<String, String> describe_token_map() throws InvalidRequestException {
        return StorageService.instance.getTokenToEndpointMap();
    }

    public String describe_partitioner() throws TException {
        return StorageService.instance.getPartitionerName();
    }

    public String describe_snitch() throws TException {
        if (DatabaseDescriptor.getEndpointSnitch() instanceof DynamicEndpointSnitch) {
            return ((DynamicEndpointSnitch)DatabaseDescriptor.getEndpointSnitch()).subsnitch.getClass().getName();
        }
        return DatabaseDescriptor.getEndpointSnitch().getClass().getName();
    }

    @Deprecated
    public List<String> describe_splits(String cfName, String start_token, String end_token, int keys_per_split) throws TException, InvalidRequestException {
        List<CfSplit> splits = this.describe_splits_ex(cfName, start_token, end_token, keys_per_split);
        ArrayList<String> result = new ArrayList<String>(splits.size() + 1);
        result.add(splits.get(0).getStart_token());
        for (CfSplit cfSplit : splits) {
            result.add(cfSplit.getEnd_token());
        }
        return result;
    }

    public List<CfSplit> describe_splits_ex(String cfName, String start_token, String end_token, int keys_per_split) throws InvalidRequestException, TException {
        try {
            Token.TokenFactory tf = StorageService.instance.getTokenFactory();
            Range<Token> tr = new Range<Token>(tf.fromString(start_token), tf.fromString(end_token));
            List<Pair<Range<Token>, Long>> splits = StorageService.instance.getSplits(this.state().getKeyspace(), cfName, tr, keys_per_split);
            ArrayList<CfSplit> result = new ArrayList<CfSplit>(splits.size());
            for (Pair<Range<Token>, Long> split : splits) {
                result.add(new CfSplit(((Token)((Range)split.left).left).toString(), ((Token)((Range)split.left).right).toString(), ((Long)split.right).longValue()));
            }
            return result;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public void login(AuthenticationRequest auth_request) throws TException {
        try {
            this.state().login(DatabaseDescriptor.getAuthenticator().legacyAuthenticate(auth_request.getCredentials()));
        }
        catch (AuthenticationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    private void schedule(long timeoutMS) throws UnavailableException {
        try {
            this.requestScheduler.queue(Thread.currentThread(), this.state().getSchedulingValue(), timeoutMS);
        }
        catch (TimeoutException e) {
            throw new UnavailableException();
        }
    }

    private void release() {
        this.requestScheduler.release();
    }

    public String system_add_column_family(CfDef cf_def) throws TException {
        logger.debug("add_column_family");
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasKeyspaceAccess(keyspace, Permission.CREATE);
            cf_def.unsetId();
            CFMetaData cfm = ThriftConversion.fromThrift(cf_def);
            cfm.params.compaction.validate();
            if (!cfm.getTriggers().isEmpty()) {
                this.state().ensureIsSuper("Only superusers are allowed to add triggers.");
            }
            MigrationManager.announceNewColumnFamily(cfm);
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public String system_drop_column_family(String column_family) throws InvalidRequestException, SchemaDisagreementException, TException {
        logger.debug("drop_column_family");
        ThriftClientState cState = this.state();
        try {
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_family, Permission.DROP);
            CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_family);
            if (metadata.isMaterializedView()) {
                throw new org.apache.cassandra.exceptions.InvalidRequestException("Cannot drop Materialized Views from Thrift");
            }
            MigrationManager.announceColumnFamilyDrop(keyspace, column_family);
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public String system_add_keyspace(KsDef ks_def) throws InvalidRequestException, SchemaDisagreementException, TException {
        logger.debug("add_keyspace");
        try {
            ThriftValidation.validateKeyspaceNotSystem(ks_def.name);
            this.state().hasAllKeyspacesAccess(Permission.CREATE);
            ThriftValidation.validateKeyspaceNotYetExisting(ks_def.name);
            for (CfDef cf : ks_def.cf_defs) {
                if (cf.getKeyspace().equals(ks_def.getName())) continue;
                throw new InvalidRequestException("CfDef (" + cf.getName() + ") had a keyspace definition that did not match KsDef");
            }
            ArrayList<CFMetaData> cfDefs = new ArrayList<CFMetaData>(ks_def.cf_defs.size());
            for (CfDef cf_def : ks_def.cf_defs) {
                cf_def.unsetId();
                CFMetaData cfm = ThriftConversion.fromThrift(cf_def);
                if (!cfm.getTriggers().isEmpty()) {
                    this.state().ensureIsSuper("Only superusers are allowed to add triggers.");
                }
                cfDefs.add(cfm);
            }
            MigrationManager.announceNewKeyspace(ThriftConversion.fromThrift(ks_def, cfDefs.toArray(new CFMetaData[cfDefs.size()])));
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public String system_drop_keyspace(String keyspace) throws InvalidRequestException, SchemaDisagreementException, TException {
        logger.debug("drop_keyspace");
        try {
            ThriftValidation.validateKeyspaceNotSystem(keyspace);
            this.state().hasKeyspaceAccess(keyspace, Permission.DROP);
            MigrationManager.announceKeyspaceDrop(keyspace);
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public String system_update_keyspace(KsDef ks_def) throws InvalidRequestException, SchemaDisagreementException, TException {
        logger.debug("update_keyspace");
        try {
            ThriftValidation.validateKeyspaceNotSystem(ks_def.name);
            this.state().hasKeyspaceAccess(ks_def.name, Permission.ALTER);
            ThriftValidation.validateKeyspace(ks_def.name);
            if (ks_def.getCf_defs() != null && ks_def.getCf_defs().size() > 0) {
                throw new InvalidRequestException("Keyspace update must not contain any table definitions.");
            }
            MigrationManager.announceKeyspaceUpdate(ThriftConversion.fromThrift(ks_def, new CFMetaData[0]));
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public String system_update_column_family(CfDef cf_def) throws InvalidRequestException, SchemaDisagreementException, TException {
        logger.debug("update_column_family");
        try {
            if (cf_def.keyspace == null || cf_def.name == null) {
                throw new InvalidRequestException("Keyspace and CF name must be set.");
            }
            this.state().hasColumnFamilyAccess(cf_def.keyspace, cf_def.name, Permission.ALTER);
            CFMetaData oldCfm = Schema.instance.getCFMetaData(cf_def.keyspace, cf_def.name);
            if (oldCfm == null) {
                throw new InvalidRequestException("Could not find table definition to modify.");
            }
            if (oldCfm.isMaterializedView()) {
                throw new InvalidRequestException("Cannot modify Materialized View table " + oldCfm.cfName + " as it may break the schema. You should use cqlsh to modify Materialized View tables instead.");
            }
            if (!oldCfm.getMaterializedViews().isEmpty()) {
                throw new InvalidRequestException("Cannot modify table with Materialized View " + oldCfm.cfName + " as it may break the schema. You should use cqlsh to modify tables with Materialized Views instead.");
            }
            if (!oldCfm.isThriftCompatible()) {
                throw new InvalidRequestException("Cannot modify CQL3 table " + oldCfm.cfName + " as it may break the schema. You should use cqlsh to modify CQL3 tables instead.");
            }
            CFMetaData cfm = ThriftConversion.fromThriftForUpdate(cf_def, oldCfm);
            cfm.params.compaction.validate();
            if (!oldCfm.getTriggers().equals(cfm.getTriggers())) {
                this.state().ensureIsSuper("Only superusers are allowed to add or remove triggers.");
            }
            MigrationManager.announceColumnFamilyUpdate(cfm, true);
            return Schema.instance.getVersion().toString();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(String cfname) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        ThriftClientState cState = this.state();
        try {
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, cfname, Permission.MODIFY);
            CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, cfname, false);
            if (metadata.isMaterializedView()) {
                throw new org.apache.cassandra.exceptions.InvalidRequestException("Cannot truncate Materialized Views");
            }
            if (this.startSessionIfRequested()) {
                Tracing.instance.begin("truncate", (Map<String, String>)ImmutableMap.of((Object)"cf", (Object)cfname, (Object)"ks", (Object)keyspace));
            } else {
                logger.debug("truncating {}.{}", (Object)cState.getKeyspace(), (Object)cfname);
            }
            this.schedule(DatabaseDescriptor.getTruncateRpcTimeout());
            try {
                StorageProxy.truncateBlocking(cState.getKeyspace(), cfname);
            }
            finally {
                this.release();
            }
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (org.apache.cassandra.exceptions.UnavailableException e) {
            throw ThriftConversion.toThrift(e);
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
        catch (IOException e) {
            throw (UnavailableException)new UnavailableException().initCause((Throwable)e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public void set_keyspace(String keyspace) throws InvalidRequestException, TException {
        try {
            this.state().setKeyspace(keyspace);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public Map<String, List<String>> describe_schema_versions() throws TException, InvalidRequestException {
        logger.debug("checking schema agreement");
        return StorageProxy.describeSchemaVersions();
    }

    public void add(ByteBuffer key, ColumnParent column_parent, CounterColumn column, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"column_parent", (Object)column_parent.toString(), (Object)"column", (Object)column.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("add", (Map<String, String>)traceParameters);
        } else {
            logger.debug("add");
        }
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            cState.hasColumnFamilyAccess(keyspace, column_parent.column_family, Permission.MODIFY);
            CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, column_parent.column_family, true);
            if (metadata.isMaterializedView()) {
                throw new org.apache.cassandra.exceptions.InvalidRequestException("Cannot modify Materialized Views directly");
            }
            ThriftValidation.validateKey(metadata, key);
            ThriftConversion.fromThrift(consistency_level).validateCounterForWrite(metadata);
            ThriftValidation.validateColumnParent(metadata, column_parent);
            if (metadata.isSuper() && column_parent.super_column == null) {
                throw new InvalidRequestException("missing mandatory super column name for super CF " + column_parent.column_family);
            }
            ThriftValidation.validateColumnNames(metadata, column_parent, Arrays.asList(column.name));
            try {
                LegacyLayout.LegacyCellName name = LegacyLayout.decodeCellName(metadata, column_parent.super_column, column.name);
                ByteBuffer value = CounterContext.instance().createLocal(column.value);
                CellPath path = name.collectionElement == null ? null : CellPath.create(name.collectionElement);
                BufferCell cell = BufferCell.live(metadata, name.column, FBUtilities.timestampMicros(), value, path);
                PartitionUpdate update = PartitionUpdate.singleRowUpdate(metadata, key, (Row)BTreeRow.singleCellRow(name.clustering, cell));
                org.apache.cassandra.db.Mutation mutation = new org.apache.cassandra.db.Mutation(update);
                this.doInsert(consistency_level, Arrays.asList(new CounterMutation(mutation, ThriftConversion.fromThrift(consistency_level))));
            }
            catch (UnknownColumnException | MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public void remove_counter(ByteBuffer key, ColumnPath path, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException, TException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(key), (Object)"column_path", (Object)path.toString(), (Object)"consistency_level", (Object)consistency_level.name());
            Tracing.instance.begin("remove_counter", (Map<String, String>)traceParameters);
        } else {
            logger.debug("remove_counter");
        }
        try {
            this.internal_remove(key, path, FBUtilities.timestampMicros(), consistency_level, true);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    private static String uncompress(ByteBuffer query, Compression compression) throws InvalidRequestException {
        String queryString = null;
        try {
            switch (compression) {
                case GZIP: {
                    DataOutputBuffer decompressed = new DataOutputBuffer();
                    byte[] outBuffer = new byte[1024];
                    byte[] inBuffer = new byte[1024];
                    Inflater decompressor = new Inflater();
                    int lenRead = 0;
                    do {
                        if (decompressor.needsInput()) {
                            lenRead = query.remaining() < 1024 ? query.remaining() : 1024;
                        }
                        query.get(inBuffer, 0, lenRead);
                        decompressor.setInput(inBuffer, 0, lenRead);
                        int lenWrite = 0;
                        while ((lenWrite = decompressor.inflate(outBuffer)) != 0) {
                            decompressed.write(outBuffer, 0, lenWrite);
                        }
                    } while (!decompressor.finished());
                    decompressor.end();
                    queryString = new String(decompressed.getData(), 0, decompressed.getLength(), StandardCharsets.UTF_8);
                    break;
                }
                case NONE: {
                    try {
                        queryString = ByteBufferUtil.string(query);
                        break;
                    }
                    catch (CharacterCodingException ex) {
                        throw new InvalidRequestException(ex.getMessage());
                    }
                }
            }
        }
        catch (DataFormatException e) {
            throw new InvalidRequestException("Error deflating query string.");
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return queryString;
    }

    public CqlResult execute_cql_query(ByteBuffer query, Compression compression) throws TException {
        throw new InvalidRequestException("CQL2 has been removed in Cassandra 3.0. Please use CQL3 instead");
    }

    public CqlResult execute_cql3_query(ByteBuffer query, Compression compression, ConsistencyLevel cLevel) throws TException {
        try {
            String queryString = CassandraServer.uncompress(query, compression);
            if (this.startSessionIfRequested()) {
                Tracing.instance.begin("execute_cql3_query", (Map<String, String>)ImmutableMap.of((Object)"query", (Object)queryString, (Object)"consistency_level", (Object)cLevel.name()));
            } else {
                logger.debug("execute_cql3_query");
            }
            ThriftClientState cState = this.state();
            CqlResult cqlResult = ClientState.getCQLQueryHandler().process(queryString, cState.getQueryState(), QueryOptions.fromProtocolV2(ThriftConversion.fromThrift(cLevel), Collections.emptyList()), null).toThriftResult();
            return cqlResult;
        }
        catch (RequestExecutionException e) {
            throw ThriftConversion.rethrow(e);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public CqlPreparedResult prepare_cql_query(ByteBuffer query, Compression compression) throws TException {
        throw new InvalidRequestException("CQL2 has been removed in Cassandra 3.0. Please use CQL3 instead");
    }

    public CqlPreparedResult prepare_cql3_query(ByteBuffer query, Compression compression) throws TException {
        logger.debug("prepare_cql3_query");
        String queryString = CassandraServer.uncompress(query, compression);
        ThriftClientState cState = this.state();
        try {
            cState.validateLogin();
            return ClientState.getCQLQueryHandler().prepare(queryString, cState.getQueryState(), null).toThriftPreparedResult();
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
    }

    public CqlResult execute_prepared_cql_query(int itemId, List<ByteBuffer> bindVariables) throws TException {
        throw new InvalidRequestException("CQL2 has been removed in Cassandra 3.0. Please use CQL3 instead");
    }

    public CqlResult execute_prepared_cql3_query(int itemId, List<ByteBuffer> bindVariables, ConsistencyLevel cLevel) throws TException {
        if (this.startSessionIfRequested()) {
            Tracing.instance.begin("execute_prepared_cql3_query", (Map<String, String>)ImmutableMap.of((Object)"consistency_level", (Object)cLevel.name()));
        } else {
            logger.debug("execute_prepared_cql3_query");
        }
        try {
            ThriftClientState cState = this.state();
            ParsedStatement.Prepared prepared = ClientState.getCQLQueryHandler().getPreparedForThrift(itemId);
            if (prepared == null) {
                throw new InvalidRequestException(String.format("Prepared query with ID %d not found (either the query was not prepared on this host (maybe the host has been restarted?) or you have prepared too many queries and it has been evicted from the internal cache)", itemId));
            }
            logger.trace("Retrieved prepared statement #{} with {} bind markers", (Object)itemId, (Object)prepared.statement.getBoundTerms());
            CqlResult cqlResult = ClientState.getCQLQueryHandler().processPrepared(prepared.statement, cState.getQueryState(), QueryOptions.fromProtocolV2(ThriftConversion.fromThrift(cLevel), bindVariables), null).toThriftResult();
            return cqlResult;
        }
        catch (RequestExecutionException e) {
            throw ThriftConversion.rethrow(e);
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public List<ColumnOrSuperColumn> get_multi_slice(MultiSliceRequest request) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (this.startSessionIfRequested()) {
            ImmutableMap traceParameters = ImmutableMap.of((Object)"key", (Object)ByteBufferUtil.bytesToHex(request.key), (Object)"column_parent", (Object)request.column_parent.toString(), (Object)"consistency_level", (Object)request.consistency_level.name(), (Object)"count", (Object)String.valueOf(request.count), (Object)"column_slices", (Object)request.column_slices.toString());
            Tracing.instance.begin("get_multi_slice", (Map<String, String>)traceParameters);
        } else {
            logger.debug("get_multi_slice");
        }
        try {
            ThriftClientState cState = this.state();
            String keyspace = cState.getKeyspace();
            this.state().hasColumnFamilyAccess(keyspace, request.getColumn_parent().column_family, Permission.SELECT);
            CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, request.getColumn_parent().column_family);
            if (metadata.isSuper()) {
                throw new org.apache.cassandra.exceptions.InvalidRequestException("get_multi_slice does not support super columns");
            }
            ThriftValidation.validateColumnParent(metadata, request.getColumn_parent());
            org.apache.cassandra.db.ConsistencyLevel consistencyLevel = ThriftConversion.fromThrift(request.getConsistency_level());
            consistencyLevel.validateForRead(keyspace);
            Slices.Builder builder = new Slices.Builder(metadata.comparator, request.getColumn_slices().size());
            for (int i = 0; i < request.getColumn_slices().size(); ++i) {
                CassandraServer.fixOptionalSliceParameters((ColumnSlice)request.getColumn_slices().get(i));
                Slice.Bound start = LegacyLayout.decodeBound((CFMetaData)metadata, (ByteBuffer)((ColumnSlice)request.getColumn_slices().get((int)i)).start, (boolean)true).bound;
                Slice.Bound finish = LegacyLayout.decodeBound((CFMetaData)metadata, (ByteBuffer)((ColumnSlice)request.getColumn_slices().get((int)i)).finish, (boolean)false).bound;
                int compare = metadata.comparator.compare(start, finish);
                if (!request.reversed && compare > 0) {
                    throw new InvalidRequestException(String.format("Column slice at index %d had start greater than finish", i));
                }
                if (request.reversed && compare < 0) {
                    throw new InvalidRequestException(String.format("Reversed column slice at index %d had start less than finish", i));
                }
                builder.add(request.reversed ? Slice.make(finish, start) : Slice.make(start, finish));
            }
            Slices slices = builder.build();
            ColumnFilter columns = this.makeColumnFilter(metadata, slices);
            ClusteringIndexSliceFilter filter = new ClusteringIndexSliceFilter(slices, request.reversed);
            DataLimits limits = this.getLimits(1, false, request.count);
            ThriftValidation.validateKey(metadata, request.key);
            DecoratedKey dk = metadata.decorateKey(request.key);
            SinglePartitionReadCommand<?> cmd = SinglePartitionReadCommand.create(true, metadata, FBUtilities.nowInSeconds(), columns, RowFilter.NONE, limits, dk, filter);
            List<ColumnOrSuperColumn> list = this.getSlice(Collections.singletonList(cmd), false, limits.perPartitionCount(), consistencyLevel, cState).entrySet().iterator().next().getValue();
            return list;
        }
        catch (RequestValidationException e) {
            throw ThriftConversion.toThrift(e);
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    private static void fixOptionalSliceParameters(ColumnSlice columnSlice) {
        if (!columnSlice.isSetStart()) {
            columnSlice.setStart(new byte[0]);
        }
        if (!columnSlice.isSetFinish()) {
            columnSlice.setFinish(new byte[0]);
        }
    }

    public void set_cql_version(String version) {
    }

    public ByteBuffer trace_next_query() throws TException {
        UUID sessionId = UUIDGen.getTimeUUID();
        this.state().getQueryState().prepareTracingSession(sessionId);
        return TimeUUIDType.instance.decompose(sessionId);
    }

    private boolean startSessionIfRequested() {
        if (this.state().getQueryState().traceNextQuery()) {
            this.state().getQueryState().createTracingSession();
            return true;
        }
        return false;
    }

    private void registerMetrics() {
        ClientMetrics.instance.addCounter("connectedThriftClients", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ThriftSessionManager.instance.getConnectedClients();
            }
        });
    }

    private static /* synthetic */ ByteBuffer lambda$cas$226(Column column) {
        return column.name;
    }

    private static class ThriftCASRequest
    implements CASRequest {
        private final CFMetaData metadata;
        private final DecoratedKey key;
        private final FilteredPartition expected;
        private final PartitionUpdate updates;

        private ThriftCASRequest(FilteredPartition expected, PartitionUpdate updates) {
            this.metadata = updates.metadata();
            this.key = updates.partitionKey();
            this.expected = expected;
            this.updates = updates;
        }

        @Override
        public SinglePartitionReadCommand readCommand(int nowInSec) {
            if (this.expected == null || this.expected.isEmpty()) {
                ClusteringIndexSliceFilter filter = new ClusteringIndexSliceFilter(Slices.ALL, false);
                DataLimits limits = DataLimits.thriftLimits(1, 1);
                return new SinglePartitionSliceCommand(false, true, this.metadata, nowInSec, ColumnFilter.all(this.metadata), RowFilter.NONE, limits, this.key, filter);
            }
            BTreeSet.Builder<Clusterable> clusterings = BTreeSet.builder(this.metadata.comparator);
            for (Row row : this.expected) {
                clusterings.add(row.clustering());
            }
            PartitionColumns columns = this.expected.staticRow().isEmpty() ? this.metadata.partitionColumns().withoutStatics() : this.metadata.partitionColumns();
            ClusteringIndexNamesFilter filter = new ClusteringIndexNamesFilter(clusterings.build(), false);
            return SinglePartitionReadCommand.create(true, this.metadata, nowInSec, ColumnFilter.selection(columns), RowFilter.NONE, DataLimits.NONE, this.key, filter);
        }

        @Override
        public boolean appliesTo(FilteredPartition current) {
            if (this.expected == null || this.expected.isEmpty()) {
                return current.isEmpty();
            }
            if (current.isEmpty()) {
                return false;
            }
            for (Row e : this.expected) {
                Row c = current.getRow(e.clustering());
                if (c == null) {
                    return false;
                }
                SearchIterator<ColumnDefinition, ColumnData> searchIter = c.searchIterator();
                for (ColumnData expectedData : e) {
                    ColumnDefinition column = expectedData.column();
                    ColumnData currentData = searchIter.next(column);
                    if (currentData == null) {
                        return false;
                    }
                    if (column.isSimple()) {
                        if (((Cell)currentData).value().equals(((Cell)expectedData).value())) continue;
                        return false;
                    }
                    ComplexColumnData currentComplexData = (ComplexColumnData)currentData;
                    for (Cell expectedCell : (ComplexColumnData)expectedData) {
                        Cell currentCell = currentComplexData.getCell(expectedCell.path());
                        if (currentCell != null && currentCell.value().equals(expectedCell.value())) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public PartitionUpdate makeUpdates(FilteredPartition current) {
            return this.updates;
        }
    }
}

