/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.schema.Functions;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.schema.Types;

public final class KeyspaceMetadata {
    public final String name;
    public final KeyspaceParams params;
    public final Tables tables;
    public final Types types;
    public final Functions functions;

    private KeyspaceMetadata(String name, KeyspaceParams params, Tables tables, Types types, Functions functions) {
        this.name = name;
        this.params = params;
        this.tables = tables;
        this.types = types;
        this.functions = functions;
    }

    public static KeyspaceMetadata create(String name, KeyspaceParams params) {
        return new KeyspaceMetadata(name, params, Tables.none(), Types.none(), Functions.none());
    }

    public static KeyspaceMetadata create(String name, KeyspaceParams params, Tables tables) {
        return new KeyspaceMetadata(name, params, tables, Types.none(), Functions.none());
    }

    public static KeyspaceMetadata create(String name, KeyspaceParams params, Tables tables, Types types, Functions functions) {
        return new KeyspaceMetadata(name, params, tables, types, functions);
    }

    public KeyspaceMetadata withSwapped(KeyspaceParams params) {
        return new KeyspaceMetadata(this.name, params, this.tables, this.types, this.functions);
    }

    public KeyspaceMetadata withSwapped(Tables tables) {
        return new KeyspaceMetadata(this.name, this.params, tables, this.types, this.functions);
    }

    public KeyspaceMetadata withSwapped(Types types) {
        return new KeyspaceMetadata(this.name, this.params, this.tables, types, this.functions);
    }

    public KeyspaceMetadata withSwapped(Functions functions) {
        return new KeyspaceMetadata(this.name, this.params, this.tables, this.types, functions);
    }

    public Set<String> existingIndexNames(String cfToExclude) {
        HashSet<String> indexNames = new HashSet<String>();
        for (CFMetaData table : this.tables) {
            if (cfToExclude != null && table.cfName.equals(cfToExclude)) continue;
            for (IndexMetadata index : table.getIndexes()) {
                indexNames.add(index.name);
            }
        }
        return indexNames;
    }

    public Optional<CFMetaData> findIndexedTable(String indexName) {
        for (CFMetaData cfm : this.tables) {
            if (!cfm.getIndexes().has(indexName)) continue;
            return Optional.of(cfm);
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.params, this.tables, this.functions, this.types});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyspaceMetadata)) {
            return false;
        }
        KeyspaceMetadata other = (KeyspaceMetadata)o;
        return this.name.equals(other.name) && this.params.equals(other.params) && this.tables.equals(other.tables) && this.functions.equals(other.functions) && this.types.equals(other.types);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("params", (Object)this.params).add("tables", (Object)this.tables).add("functions", (Object)this.functions).add("types", (Object)this.types).toString();
    }

    public void validate() {
        if (!CFMetaData.isNameValid(this.name)) {
            throw new ConfigurationException(String.format("Keyspace name must not be empty, more than %s characters long, or contain non-alphanumeric-underscore characters (got \"%s\")", 48, this.name));
        }
        this.tables.forEach(CFMetaData::validate);
    }
}

