/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.Memory;
import org.apache.cassandra.io.util.SafeMemory;

public class SafeMemoryWriter
extends DataOutputBuffer {
    private SafeMemory memory;

    public SafeMemoryWriter(long initialCapacity) {
        this(new SafeMemory(initialCapacity));
    }

    private SafeMemoryWriter(SafeMemory memory) {
        super(SafeMemoryWriter.tailBuffer(memory).order(ByteOrder.BIG_ENDIAN));
        this.memory = memory;
    }

    public SafeMemory currentBuffer() {
        return this.memory;
    }

    @Override
    protected void reallocate(long newCapacity) {
        if (newCapacity != this.capacity()) {
            long position = this.length();
            ByteOrder order = this.buffer.order();
            SafeMemory oldBuffer = this.memory;
            this.memory = this.memory.copy(newCapacity);
            this.buffer = SafeMemoryWriter.tailBuffer(this.memory);
            int newPosition = (int)(position - SafeMemoryWriter.tailOffset(this.memory));
            this.buffer.position(newPosition);
            this.buffer.order(order);
            oldBuffer.free();
        }
    }

    public void setCapacity(long newCapacity) {
        this.reallocate(newCapacity);
    }

    @Override
    public void close() {
        this.memory.close();
    }

    public Throwable close(Throwable accumulate) {
        return this.memory.close(accumulate);
    }

    public long length() {
        return SafeMemoryWriter.tailOffset(this.memory) + (long)this.buffer.position();
    }

    public long capacity() {
        return this.memory.size();
    }

    @Override
    public SafeMemoryWriter order(ByteOrder order) {
        super.order(order);
        return this;
    }

    private static long tailOffset(Memory memory) {
        return Math.max(0L, memory.size - Integer.MAX_VALUE);
    }

    private static ByteBuffer tailBuffer(Memory memory) {
        return memory.asByteBuffer(SafeMemoryWriter.tailOffset(memory), (int)Math.min(memory.size, Integer.MAX_VALUE));
    }
}

