/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.util.concurrent.RateLimiter;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.TreeMap;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.compress.CompressedRandomAccessReader;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.compress.CompressedThrottledReader;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.ICompressedFile;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.utils.concurrent.Ref;

public class CompressedSegmentedFile
extends SegmentedFile
implements ICompressedFile {
    public final CompressionMetadata metadata;
    private static final boolean useMmap = DatabaseDescriptor.getDiskAccessMode() == Config.DiskAccessMode.mmap;
    private static int MAX_SEGMENT_SIZE = Integer.MAX_VALUE;
    private final TreeMap<Long, MappedByteBuffer> chunkSegments;

    public CompressedSegmentedFile(ChannelProxy channel, int bufferSize, CompressionMetadata metadata) {
        this(channel, bufferSize, metadata, CompressedSegmentedFile.createMappedSegments(channel, metadata));
    }

    public CompressedSegmentedFile(ChannelProxy channel, int bufferSize, CompressionMetadata metadata, TreeMap<Long, MappedByteBuffer> chunkSegments) {
        super(new Cleanup(channel, metadata, chunkSegments), channel, bufferSize, metadata.dataLength, metadata.compressedFileLength);
        this.metadata = metadata;
        this.chunkSegments = chunkSegments;
    }

    private CompressedSegmentedFile(CompressedSegmentedFile copy) {
        super(copy);
        this.metadata = copy.metadata;
        this.chunkSegments = copy.chunkSegments;
    }

    @Override
    public ChannelProxy channel() {
        return this.channel;
    }

    @Override
    public TreeMap<Long, MappedByteBuffer> chunkSegments() {
        return this.chunkSegments;
    }

    static TreeMap<Long, MappedByteBuffer> createMappedSegments(ChannelProxy channel, CompressionMetadata metadata) {
        if (!useMmap) {
            return null;
        }
        TreeMap<Long, MappedByteBuffer> chunkSegments = new TreeMap<Long, MappedByteBuffer>();
        long lastSegmentOffset = 0L;
        long segmentSize = 0L;
        for (long offset = 0L; offset < metadata.dataLength; offset += (long)metadata.chunkLength()) {
            CompressionMetadata.Chunk chunk = metadata.chunkFor(offset);
            if (segmentSize + (long)chunk.length + 4L > (long)MAX_SEGMENT_SIZE) {
                chunkSegments.put(lastSegmentOffset, channel.map(FileChannel.MapMode.READ_ONLY, lastSegmentOffset, segmentSize));
                lastSegmentOffset += segmentSize;
                segmentSize = 0L;
            }
            segmentSize += (long)(chunk.length + 4);
        }
        if (segmentSize > 0L) {
            chunkSegments.put(lastSegmentOffset, channel.map(FileChannel.MapMode.READ_ONLY, lastSegmentOffset, segmentSize));
        }
        return chunkSegments;
    }

    @Override
    public CompressedSegmentedFile sharedCopy() {
        return new CompressedSegmentedFile(this);
    }

    @Override
    public void addTo(Ref.IdentityCollection identities) {
        super.addTo(identities);
        this.metadata.addTo(identities);
    }

    @Override
    public void dropPageCache(long before) {
        if (before >= this.metadata.dataLength) {
            super.dropPageCache(0L);
        }
        super.dropPageCache(this.metadata.chunkFor((long)before).offset);
    }

    @Override
    public RandomAccessReader createReader() {
        return CompressedRandomAccessReader.open(this);
    }

    @Override
    public RandomAccessReader createThrottledReader(RateLimiter limiter) {
        return CompressedThrottledReader.open(this, limiter);
    }

    @Override
    public CompressionMetadata getMetadata() {
        return this.metadata;
    }

    public static class Builder
    extends SegmentedFile.Builder {
        protected final CompressedSequentialWriter writer;

        public Builder(CompressedSequentialWriter writer) {
            this.writer = writer;
        }

        @Override
        public void addPotentialBoundary(long boundary) {
        }

        protected CompressionMetadata metadata(String path, long overrideLength) {
            if (this.writer == null) {
                return CompressionMetadata.create(path);
            }
            return this.writer.open(overrideLength);
        }

        @Override
        public SegmentedFile complete(ChannelProxy channel, int bufferSize, long overrideLength) {
            return new CompressedSegmentedFile(channel, bufferSize, this.metadata(channel.filePath(), overrideLength));
        }
    }

    private static final class Cleanup
    extends SegmentedFile.Cleanup {
        final CompressionMetadata metadata;
        final TreeMap<Long, MappedByteBuffer> chunkSegments;

        protected Cleanup(ChannelProxy channel, CompressionMetadata metadata, TreeMap<Long, MappedByteBuffer> chunkSegments) {
            super(channel);
            this.metadata = metadata;
            this.chunkSegments = chunkSegments;
        }

        @Override
        public void tidy() {
            super.tidy();
            this.metadata.close();
            if (this.chunkSegments != null) {
                for (MappedByteBuffer segment : this.chunkSegments.values()) {
                    FileUtils.clean(segment);
                }
            }
        }
    }
}

