/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import java.io.IOException;
import java.util.zip.CRC32;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.DataIntegrityMetadata;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ChecksummedRandomAccessReader
extends RandomAccessReader {
    private final DataIntegrityMetadata.ChecksumValidator validator;
    private final File file;

    protected ChecksummedRandomAccessReader(File file, ChannelProxy channel, DataIntegrityMetadata.ChecksumValidator validator) {
        super(channel, validator.chunkSize, -1L, BufferType.ON_HEAP);
        this.validator = validator;
        this.file = file;
    }

    public static ChecksummedRandomAccessReader open(File file, File crcFile) throws IOException {
        ChannelProxy channel = new ChannelProxy(file);
        RandomAccessReader crcReader = RandomAccessReader.open(crcFile);
        DataIntegrityMetadata.ChecksumValidator validator = new DataIntegrityMetadata.ChecksumValidator(new CRC32(), crcReader, file.getPath());
        return new ChecksummedRandomAccessReader(file, channel, validator);
    }

    @Override
    protected void reBuffer() {
        int n;
        long desiredPosition = this.current();
        this.bufferOffset = desiredPosition / (long)this.buffer.capacity() * (long)this.buffer.capacity();
        this.buffer.clear();
        long position = this.bufferOffset;
        while (this.buffer.hasRemaining() && (n = this.channel.read(this.buffer, position)) >= 0) {
            position += (long)n;
        }
        this.buffer.flip();
        try {
            this.validator.validate(ByteBufferUtil.getArray(this.buffer), 0, this.buffer.remaining());
        }
        catch (IOException e) {
            throw new CorruptFileException(e, this.file);
        }
        this.buffer.position((int)(desiredPosition - this.bufferOffset));
    }

    @Override
    public void seek(long newPosition) {
        this.validator.seek(newPosition);
        super.seek(newPosition);
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.channel.close();
            this.validator.close();
        }
    }

    public static class CorruptFileException
    extends RuntimeException {
        public final File file;

        public CorruptFileException(Exception cause, File file) {
            super(cause);
            this.file = file;
        }
    }
}

