/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.zip.CRC32;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.compress.CorruptBlockException;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.util.DataIntegrityMetadata;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.utils.Throwables;

public class CompressedSequentialWriter
extends SequentialWriter {
    private final DataIntegrityMetadata.ChecksumWriter crcMetadata;
    private long chunkOffset = 0L;
    private final CompressionMetadata.Writer metadataWriter;
    private final ICompressor compressor;
    private ByteBuffer compressed;
    private int chunkCount = 0;
    private long uncompressedSize = 0L;
    private long compressedSize = 0L;
    private final MetadataCollector sstableMetadataCollector;
    private final ByteBuffer crcCheckBuffer = ByteBuffer.allocate(4);

    public CompressedSequentialWriter(File file, String offsetsPath, CompressionParams parameters, MetadataCollector sstableMetadataCollector) {
        super(file, parameters.chunkLength(), parameters.getSstableCompressor().preferredBufferType());
        this.compressor = parameters.getSstableCompressor();
        this.compressed = this.compressor.preferredBufferType().allocate(this.compressor.initialCompressedBufferLength(this.buffer.capacity()));
        this.metadataWriter = CompressionMetadata.Writer.open(parameters, offsetsPath);
        this.sstableMetadataCollector = sstableMetadataCollector;
        this.crcMetadata = new DataIntegrityMetadata.ChecksumWriter(new DataOutputStream(Channels.newOutputStream(this.channel)));
    }

    @Override
    public long getOnDiskFilePointer() {
        try {
            return this.fchannel.position();
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void flushData() {
        this.seekToChunkStart();
        try {
            this.buffer.flip();
            this.compressed.clear();
            this.compressor.compress(this.buffer, this.compressed);
        }
        catch (IOException e) {
            throw new RuntimeException("Compression exception", e);
        }
        int compressedLength = this.compressed.position();
        this.uncompressedSize += (long)this.buffer.position();
        this.compressedSize += (long)compressedLength;
        try {
            this.metadataWriter.addOffset(this.chunkOffset);
            ++this.chunkCount;
            this.compressed.flip();
            this.channel.write(this.compressed);
            this.compressed.rewind();
            this.crcMetadata.appendDirect(this.compressed, true);
            this.lastFlushOffset += (long)(compressedLength + 4);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
        this.chunkOffset += (long)(compressedLength + 4);
        if (this.runPostFlush != null) {
            this.runPostFlush.run();
        }
    }

    public CompressionMetadata open(long overrideLength) {
        if (overrideLength <= 0L) {
            overrideLength = this.uncompressedSize;
        }
        return this.metadataWriter.open(overrideLength, this.chunkOffset);
    }

    @Override
    public FileMark mark() {
        if (!this.buffer.hasRemaining()) {
            this.doFlush();
        }
        return new CompressedFileWriterMark(this.chunkOffset, this.current(), this.buffer.position(), this.chunkCount + 1);
    }

    @Override
    public synchronized void resetAndTruncate(FileMark mark) {
        assert (mark instanceof CompressedFileWriterMark);
        CompressedFileWriterMark realMark = (CompressedFileWriterMark)mark;
        long truncateTarget = realMark.uncDataOffset;
        if (realMark.chunkOffset == this.chunkOffset) {
            this.buffer.position(realMark.validBufferBytes);
            return;
        }
        this.syncInternal();
        this.chunkOffset = realMark.chunkOffset;
        int chunkSize = (int)(this.metadataWriter.chunkOffsetBy(realMark.nextChunkIndex) - this.chunkOffset - 4L);
        if (this.compressed.capacity() < chunkSize) {
            this.compressed = this.compressor.preferredBufferType().allocate(chunkSize);
        }
        try {
            this.compressed.clear();
            this.compressed.limit(chunkSize);
            this.fchannel.position(this.chunkOffset);
            this.fchannel.read(this.compressed);
            try {
                this.buffer.clear();
                this.compressed.flip();
                this.compressor.uncompress(this.compressed, this.buffer);
            }
            catch (IOException e) {
                throw new CorruptBlockException(this.getPath(), this.chunkOffset, chunkSize);
            }
            CRC32 checksum = new CRC32();
            this.compressed.rewind();
            checksum.update(this.compressed);
            this.crcCheckBuffer.clear();
            this.fchannel.read(this.crcCheckBuffer);
            this.crcCheckBuffer.flip();
            if (this.crcCheckBuffer.getInt() != (int)checksum.getValue()) {
                throw new CorruptBlockException(this.getPath(), this.chunkOffset, chunkSize);
            }
        }
        catch (CorruptBlockException e) {
            throw new CorruptSSTableException((Exception)e, this.getPath());
        }
        catch (EOFException e) {
            throw new CorruptSSTableException((Exception)new CorruptBlockException(this.getPath(), this.chunkOffset, chunkSize), this.getPath());
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
        this.buffer.position(realMark.validBufferBytes);
        this.bufferOffset = truncateTarget - (long)this.buffer.position();
        this.chunkCount = realMark.nextChunkIndex - 1;
        this.truncate(this.chunkOffset);
        this.metadataWriter.resetAndTruncate(realMark.nextChunkIndex - 1);
    }

    private void seekToChunkStart() {
        if (this.getOnDiskFilePointer() != this.chunkOffset) {
            try {
                this.fchannel.position(this.chunkOffset);
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, this.getPath());
            }
        }
    }

    @Override
    protected SequentialWriter.TransactionalProxy txnProxy() {
        return new TransactionalProxy();
    }

    protected static class CompressedFileWriterMark
    implements FileMark {
        final long chunkOffset;
        final long uncDataOffset;
        final int validBufferBytes;
        final int nextChunkIndex;

        public CompressedFileWriterMark(long chunkOffset, long uncDataOffset, int validBufferBytes, int nextChunkIndex) {
            this.chunkOffset = chunkOffset;
            this.uncDataOffset = uncDataOffset;
            this.validBufferBytes = validBufferBytes;
            this.nextChunkIndex = nextChunkIndex;
        }
    }

    protected class TransactionalProxy
    extends SequentialWriter.TransactionalProxy {
        protected TransactionalProxy() {
            super(CompressedSequentialWriter.this);
        }

        @Override
        protected Throwable doCommit(Throwable accumulate) {
            return CompressedSequentialWriter.this.metadataWriter.commit(accumulate);
        }

        @Override
        protected Throwable doAbort(Throwable accumulate) {
            return super.doAbort(CompressedSequentialWriter.this.metadataWriter.abort(accumulate));
        }

        @Override
        protected void doPrepare() {
            CompressedSequentialWriter.this.syncInternal();
            if (CompressedSequentialWriter.this.descriptor != null) {
                CompressedSequentialWriter.this.crcMetadata.writeFullChecksum(CompressedSequentialWriter.this.descriptor);
            }
            CompressedSequentialWriter.this.releaseFileHandle();
            CompressedSequentialWriter.this.sstableMetadataCollector.addCompressionRatio(CompressedSequentialWriter.this.compressedSize, CompressedSequentialWriter.this.uncompressedSize);
            CompressedSequentialWriter.this.metadataWriter.finalizeLength(CompressedSequentialWriter.this.current(), CompressedSequentialWriter.this.chunkCount).prepareToCommit();
        }

        @Override
        protected Throwable doPreCleanup(Throwable accumulate) {
            accumulate = super.doPreCleanup(accumulate);
            if (CompressedSequentialWriter.this.compressed != null) {
                try {
                    FileUtils.clean(CompressedSequentialWriter.this.compressed);
                }
                catch (Throwable t) {
                    accumulate = Throwables.merge(accumulate, t);
                }
                CompressedSequentialWriter.this.compressed = null;
            }
            return accumulate;
        }
    }
}

