/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.ArrivalWindow;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetectorMBean;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureDetector
implements IFailureDetector,
FailureDetectorMBean {
    private static final Logger logger = LoggerFactory.getLogger(FailureDetector.class);
    public static final String MBEAN_NAME = "org.apache.cassandra.net:type=FailureDetector";
    private static final int SAMPLE_SIZE = 1000;
    protected static final long INITIAL_VALUE_NANOS = TimeUnit.NANOSECONDS.convert(FailureDetector.getInitialValue(), TimeUnit.MILLISECONDS);
    private static final long DEFAULT_MAX_PAUSE = 5000000000L;
    private static final long MAX_LOCAL_PAUSE_IN_NANOS = FailureDetector.getMaxLocalPause();
    private long lastInterpret = System.nanoTime();
    private boolean wasPaused = false;
    public static final IFailureDetector instance = new FailureDetector();
    private final double PHI_FACTOR = 1.0 / Math.log(10.0);
    private final Map<InetAddress, ArrivalWindow> arrivalSamples = new Hashtable<InetAddress, ArrivalWindow>();
    private final List<IFailureDetectionEventListener> fdEvntListeners = new CopyOnWriteArrayList<IFailureDetectionEventListener>();

    private static long getMaxLocalPause() {
        if (System.getProperty("cassandra.max_local_pause_in_ms") != null) {
            long pause = Long.parseLong(System.getProperty("cassandra.max_local_pause_in_ms"));
            logger.warn("Overriding max local pause time to {}ms", (Object)pause);
            return pause * 1000000L;
        }
        return 5000000000L;
    }

    public FailureDetector() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(this, new ObjectName(MBEAN_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static long getInitialValue() {
        String newvalue = System.getProperty("cassandra.fd_initial_value_ms");
        if (newvalue == null) {
            return 2000L;
        }
        logger.info("Overriding FD INITIAL_VALUE to {}ms", (Object)newvalue);
        return Integer.parseInt(newvalue);
    }

    @Override
    public String getAllEndpointStates() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : Gossiper.instance.endpointStateMap.entrySet()) {
            sb.append(entry.getKey()).append("\n");
            this.appendEndpointState(sb, (EndpointState)entry.getValue());
        }
        return sb.toString();
    }

    @Override
    public Map<String, String> getSimpleStates() {
        HashMap<String, String> nodesStatus = new HashMap<String, String>(Gossiper.instance.endpointStateMap.size());
        for (Map.Entry entry : Gossiper.instance.endpointStateMap.entrySet()) {
            if (((EndpointState)entry.getValue()).isAlive()) {
                nodesStatus.put(((InetAddress)entry.getKey()).toString(), "UP");
                continue;
            }
            nodesStatus.put(((InetAddress)entry.getKey()).toString(), "DOWN");
        }
        return nodesStatus;
    }

    @Override
    public int getDownEndpointCount() {
        int count = 0;
        for (Map.Entry entry : Gossiper.instance.endpointStateMap.entrySet()) {
            if (((EndpointState)entry.getValue()).isAlive()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getUpEndpointCount() {
        int count = 0;
        for (Map.Entry entry : Gossiper.instance.endpointStateMap.entrySet()) {
            if (!((EndpointState)entry.getValue()).isAlive()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public String getEndpointState(String address) throws UnknownHostException {
        StringBuilder sb = new StringBuilder();
        EndpointState endpointState = Gossiper.instance.getEndpointStateForEndpoint(InetAddress.getByName(address));
        this.appendEndpointState(sb, endpointState);
        return sb.toString();
    }

    private void appendEndpointState(StringBuilder sb, EndpointState endpointState) {
        sb.append("  generation:").append(endpointState.getHeartBeatState().getGeneration()).append("\n");
        sb.append("  heartbeat:").append(endpointState.getHeartBeatState().getHeartBeatVersion()).append("\n");
        for (Map.Entry<ApplicationState, VersionedValue> state : endpointState.applicationState.entrySet()) {
            if (state.getKey() == ApplicationState.TOKENS) continue;
            sb.append("  ").append((Object)state.getKey()).append(":").append(state.getValue().value).append("\n");
        }
    }

    @Override
    public void dumpInterArrivalTimes() {
        File file = FileUtils.createTempFile("failuredetector-", ".dat");
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file, true));){
            ((OutputStream)os).write(this.toString().getBytes());
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, file);
        }
    }

    @Override
    public void setPhiConvictThreshold(double phi) {
        DatabaseDescriptor.setPhiConvictThreshold(phi);
    }

    @Override
    public double getPhiConvictThreshold() {
        return DatabaseDescriptor.getPhiConvictThreshold();
    }

    @Override
    public boolean isAlive(InetAddress ep) {
        if (ep.equals(FBUtilities.getBroadcastAddress())) {
            return true;
        }
        EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(ep);
        if (epState == null) {
            logger.error("unknown endpoint {}", (Object)ep);
        }
        return epState != null && epState.isAlive();
    }

    @Override
    public void report(InetAddress ep) {
        if (logger.isTraceEnabled()) {
            logger.trace("reporting {}", (Object)ep);
        }
        long now = System.nanoTime();
        ArrivalWindow heartbeatWindow = this.arrivalSamples.get(ep);
        if (heartbeatWindow == null) {
            heartbeatWindow = new ArrivalWindow(1000);
            heartbeatWindow.add(now, ep);
            this.arrivalSamples.put(ep, heartbeatWindow);
        } else {
            heartbeatWindow.add(now, ep);
        }
    }

    @Override
    public void interpret(InetAddress ep) {
        ArrivalWindow hbWnd = this.arrivalSamples.get(ep);
        if (hbWnd == null) {
            return;
        }
        long now = System.nanoTime();
        long diff = now - this.lastInterpret;
        this.lastInterpret = now;
        if (diff > MAX_LOCAL_PAUSE_IN_NANOS) {
            logger.warn("Not marking nodes down due to local pause of {} > {}", (Object)diff, (Object)MAX_LOCAL_PAUSE_IN_NANOS);
            this.wasPaused = true;
            return;
        }
        if (this.wasPaused) {
            this.wasPaused = false;
            return;
        }
        double phi = hbWnd.phi(now);
        if (logger.isTraceEnabled()) {
            logger.trace("PHI for {} : {}", (Object)ep, (Object)phi);
        }
        if (this.PHI_FACTOR * phi > this.getPhiConvictThreshold()) {
            logger.trace("notifying listeners that {} is down", (Object)ep);
            logger.trace("intervals: {} mean: {}", (Object)hbWnd, (Object)hbWnd.mean());
            for (IFailureDetectionEventListener listener : this.fdEvntListeners) {
                listener.convict(ep, phi);
            }
        }
    }

    @Override
    public void forceConviction(InetAddress ep) {
        logger.debug("Forcing conviction of {}", (Object)ep);
        for (IFailureDetectionEventListener listener : this.fdEvntListeners) {
            listener.convict(ep, this.getPhiConvictThreshold());
        }
    }

    @Override
    public void remove(InetAddress ep) {
        this.arrivalSamples.remove(ep);
    }

    @Override
    public void registerFailureDetectionEventListener(IFailureDetectionEventListener listener) {
        this.fdEvntListeners.add(listener);
    }

    @Override
    public void unregisterFailureDetectionEventListener(IFailureDetectionEventListener listener) {
        this.fdEvntListeners.remove(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set<InetAddress> eps = this.arrivalSamples.keySet();
        sb.append("-----------------------------------------------------------------------");
        for (InetAddress ep : eps) {
            ArrivalWindow hWnd = this.arrivalSamples.get(ep);
            sb.append(ep + " : ");
            sb.append(hWnd);
            sb.append(System.getProperty("line.separator"));
        }
        sb.append("-----------------------------------------------------------------------");
        return sb.toString();
    }

    public static void main(String[] args) {
    }
}

