/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnCondition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Json;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.CompactTables;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public class UpdateStatement
extends ModificationStatement {
    private static final Constants.Value EMPTY = new Constants.Value(ByteBufferUtil.EMPTY_BYTE_BUFFER);

    private UpdateStatement(ModificationStatement.StatementType type, int boundTerms, CFMetaData cfm, Attributes attrs) {
        super(type, boundTerms, cfm, attrs);
    }

    @Override
    public boolean requireFullClusteringKey() {
        return true;
    }

    @Override
    public void addUpdateForKey(PartitionUpdate update, CBuilder cbuilder, UpdateParameters params) throws InvalidRequestException {
        if (this.updatesRegularRows()) {
            params.newRow(cbuilder.build());
            if (this.type == ModificationStatement.StatementType.INSERT && this.cfm.isCQLTable()) {
                params.addPrimaryKeyLivenessInfo();
            }
            List<Operation> updates = this.getRegularOperations();
            if (this.cfm.isCompactTable() && updates.isEmpty()) {
                if (CompactTables.hasEmptyCompactValue(this.cfm)) {
                    updates = Collections.singletonList(new Constants.Setter(this.cfm.compactValueColumn(), EMPTY));
                } else {
                    throw new InvalidRequestException(String.format("Column %s is mandatory for this COMPACT STORAGE table", this.cfm.compactValueColumn().name));
                }
            }
            for (Operation op : updates) {
                op.execute(update.partitionKey(), params);
            }
            update.add(params.buildRow());
        }
        if (this.updatesStaticRow()) {
            params.newRow(Clustering.STATIC_CLUSTERING);
            for (Operation op : this.getStaticOperations()) {
                op.execute(update.partitionKey(), params);
            }
            update.add(params.buildRow());
        }
        params.validateIndexedColumns(update);
    }

    public static class ParsedUpdate
    extends ModificationStatement.Parsed {
        private final List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> updates;
        private final List<Relation> whereClause;

        public ParsedUpdate(CFName name, Attributes.Raw attrs, List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> updates, List<Relation> whereClause, List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions, boolean ifExists) {
            super(name, attrs, conditions, false, ifExists);
            this.updates = updates;
            this.whereClause = whereClause;
        }

        @Override
        protected ModificationStatement prepareInternal(CFMetaData cfm, VariableSpecifications boundNames, Attributes attrs) throws InvalidRequestException {
            UpdateStatement stmt = new UpdateStatement(ModificationStatement.StatementType.UPDATE, boundNames.size(), cfm, attrs);
            for (Pair<ColumnIdentifier.Raw, Operation.RawUpdate> entry : this.updates) {
                ColumnDefinition def = cfm.getColumnDefinition(((ColumnIdentifier.Raw)entry.left).prepare(cfm));
                if (def == null) {
                    throw new InvalidRequestException(String.format("Unknown identifier %s", entry.left));
                }
                Operation operation = ((Operation.RawUpdate)entry.right).prepare(this.keyspace(), def);
                operation.collectMarkerSpecification(boundNames);
                switch (def.kind) {
                    case PARTITION_KEY: 
                    case CLUSTERING: {
                        throw new InvalidRequestException(String.format("PRIMARY KEY part %s found in SET part", entry.left));
                    }
                }
                stmt.addOperation(operation);
            }
            stmt.processWhereClause(this.whereClause, boundNames);
            return stmt;
        }
    }

    public static class ParsedInsertJson
    extends ModificationStatement.Parsed {
        private final Json.Raw jsonValue;

        public ParsedInsertJson(CFName name, Attributes.Raw attrs, Json.Raw jsonValue, boolean ifNotExists) {
            super(name, attrs, null, ifNotExists, false);
            this.jsonValue = jsonValue;
        }

        @Override
        protected ModificationStatement prepareInternal(CFMetaData cfm, VariableSpecifications boundNames, Attributes attrs) throws InvalidRequestException {
            UpdateStatement stmt = new UpdateStatement(ModificationStatement.StatementType.INSERT, boundNames.size(), cfm, attrs);
            if (stmt.isCounter()) {
                throw new InvalidRequestException("INSERT statements are not allowed on counter tables, use UPDATE instead");
            }
            Collection<ColumnDefinition> defs = cfm.allColumns();
            Json.Prepared prepared = this.jsonValue.prepareAndCollectMarkers(cfm, defs, boundNames);
            for (ColumnDefinition def : defs) {
                if (def.isPrimaryKeyColumn()) {
                    stmt.addKeyValue(def, prepared.getPrimaryKeyValueForColumn(def));
                    continue;
                }
                stmt.addOperation(prepared.getSetOperationForColumn(def));
            }
            return stmt;
        }
    }

    public static class ParsedInsert
    extends ModificationStatement.Parsed {
        private final List<ColumnIdentifier.Raw> columnNames;
        private final List<Term.Raw> columnValues;

        public ParsedInsert(CFName name, Attributes.Raw attrs, List<ColumnIdentifier.Raw> columnNames, List<Term.Raw> columnValues, boolean ifNotExists) {
            super(name, attrs, null, ifNotExists, false);
            this.columnNames = columnNames;
            this.columnValues = columnValues;
        }

        @Override
        protected ModificationStatement prepareInternal(CFMetaData cfm, VariableSpecifications boundNames, Attributes attrs) throws InvalidRequestException {
            UpdateStatement stmt = new UpdateStatement(ModificationStatement.StatementType.INSERT, boundNames.size(), cfm, attrs);
            if (stmt.isCounter()) {
                throw new InvalidRequestException("INSERT statements are not allowed on counter tables, use UPDATE instead");
            }
            if (this.columnNames == null) {
                throw new InvalidRequestException("Column names for INSERT must be provided when using VALUES");
            }
            if (this.columnNames.isEmpty()) {
                throw new InvalidRequestException("No columns provided to INSERT");
            }
            if (this.columnNames.size() != this.columnValues.size()) {
                throw new InvalidRequestException("Unmatched column names/values");
            }
            String ks = this.keyspace();
            for (int i = 0; i < this.columnNames.size(); ++i) {
                ColumnIdentifier id = this.columnNames.get(i).prepare(cfm);
                ColumnDefinition def = cfm.getColumnDefinition(id);
                if (def == null) {
                    throw new InvalidRequestException(String.format("Unknown identifier %s", id));
                }
                for (int j = 0; j < i; ++j) {
                    ColumnIdentifier otherId = this.columnNames.get(j).prepare(cfm);
                    if (!id.equals(otherId)) continue;
                    throw new InvalidRequestException(String.format("Multiple definitions found for column %s", id));
                }
                Term.Raw value = this.columnValues.get(i);
                if (def.isPrimaryKeyColumn()) {
                    Term t = value.prepare(ks, def);
                    t.collectMarkerSpecification(boundNames);
                    stmt.addKeyValue(def, t);
                    continue;
                }
                Operation operation = new Operation.SetValue(value).prepare(ks, def);
                operation.collectMarkerSpecification(boundNames);
                stmt.addOperation(operation);
            }
            return stmt;
        }
    }
}

