/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.MaterializedViewDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.selection.RawSelector;
import org.apache.cassandra.cql3.selection.Selectable;
import org.apache.cassandra.cql3.statements.CFProperties;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.view.MaterializedView;
import org.apache.cassandra.exceptions.AlreadyExistsException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.Event;

public class CreateMaterializedViewStatement
extends SchemaAlteringStatement {
    private final CFName baseName;
    private final List<RawSelector> selectClause;
    private final List<ColumnIdentifier.Raw> notNullWhereClause;
    private final List<ColumnIdentifier.Raw> partitionKeys;
    private final List<ColumnIdentifier.Raw> clusteringKeys;
    public final CFProperties properties = new CFProperties();
    private final boolean ifNotExists;

    public CreateMaterializedViewStatement(CFName viewName, CFName baseName, List<RawSelector> selectClause, List<ColumnIdentifier.Raw> notNullWhereClause, List<ColumnIdentifier.Raw> partitionKeys, List<ColumnIdentifier.Raw> clusteringKeys, boolean ifNotExists) {
        super(viewName);
        this.baseName = baseName;
        this.selectClause = selectClause;
        this.notNullWhereClause = notNullWhereClause;
        this.partitionKeys = partitionKeys;
        this.clusteringKeys = clusteringKeys;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        if (!this.baseName.hasKeyspace()) {
            this.baseName.setKeyspace(this.keyspace(), true);
        }
        state.hasColumnFamilyAccess(this.keyspace(), this.baseName.getColumnFamily(), Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws RequestValidationException {
        boolean bl;
        this.properties.validate();
        if (this.properties.useCompactStorage) {
            throw new InvalidRequestException("Cannot use 'COMPACT STORAGE' when defining a materialized view");
        }
        if (!this.baseName.getKeyspace().equals(this.keyspace())) {
            throw new InvalidRequestException("Cannot create a materialized view on a table in a separate keyspace");
        }
        CFMetaData cfm = ThriftValidation.validateColumnFamily(this.baseName.getKeyspace(), this.baseName.getColumnFamily());
        if (cfm.isCounter()) {
            throw new InvalidRequestException("Materialized views are not supported on counter tables");
        }
        if (cfm.isMaterializedView()) {
            throw new InvalidRequestException("Materialized views cannot be created against other materialized views");
        }
        HashSet<ColumnIdentifier> included = new HashSet<ColumnIdentifier>();
        for (RawSelector rawSelector : this.selectClause) {
            Selectable.Raw selectable = rawSelector.selectable;
            if (selectable instanceof Selectable.WithFieldSelection.Raw) {
                throw new InvalidRequestException("Cannot select out a part of type when defining a materialized view");
            }
            if (selectable instanceof Selectable.WithFunction.Raw) {
                throw new InvalidRequestException("Cannot use function when defining a materialized view");
            }
            if (selectable instanceof Selectable.WritetimeOrTTL.Raw) {
                throw new InvalidRequestException("Cannot use function when defining a materialized view");
            }
            ColumnIdentifier identifier = (ColumnIdentifier)selectable.prepare(cfm);
            if (rawSelector.alias != null) {
                throw new InvalidRequestException(String.format("Cannot alias column '%s' as '%s' when defining a materialized view", identifier.toString(), rawSelector.alias.toString()));
            }
            ColumnDefinition cdef = cfm.getColumnDefinition(identifier);
            if (cdef == null) {
                throw new InvalidRequestException("Unknown column name detected in CREATE MATERIALIZED VIEW statement : " + identifier);
            }
            if (cdef.isStatic()) {
                ClientWarn.warn(String.format("Unable to include static column '%s' in Materialized View SELECT statement", identifier));
                continue;
            }
            included.add(identifier);
        }
        HashSet<ColumnIdentifier.Raw> targetPrimaryKeys = new HashSet<ColumnIdentifier.Raw>();
        for (Object identifier : Iterables.concat(this.partitionKeys, this.clusteringKeys)) {
            if (!targetPrimaryKeys.add((ColumnIdentifier.Raw)identifier)) {
                throw new InvalidRequestException("Duplicate entry found in PRIMARY KEY: " + identifier);
            }
            ColumnDefinition cdef = cfm.getColumnDefinition(((ColumnIdentifier.Raw)identifier).prepare(cfm));
            if (cdef == null) {
                throw new InvalidRequestException("Unknown column name detected in CREATE MATERIALIZED VIEW statement : " + identifier);
            }
            if (cfm.getColumnDefinition((ColumnIdentifier)((ColumnIdentifier.Raw)identifier).prepare((CFMetaData)cfm)).type.isMultiCell()) {
                throw new InvalidRequestException(String.format("Cannot use MultiCell column '%s' in PRIMARY KEY of materialized view", identifier));
            }
            if (!cdef.isStatic()) continue;
            throw new InvalidRequestException(String.format("Cannot use Static column '%s' in PRIMARY KEY of materialized view", identifier));
        }
        HashSet<ColumnIdentifier> hashSet = new HashSet<ColumnIdentifier>();
        for (ColumnDefinition definition : Iterables.concat(cfm.partitionKeyColumns(), cfm.clusteringColumns())) {
            hashSet.add(definition.name);
        }
        ArrayList<ColumnIdentifier> targetClusteringColumns = new ArrayList<ColumnIdentifier>();
        ArrayList<ColumnIdentifier> targetPartitionKeys = new ArrayList<ColumnIdentifier>();
        HashSet<ColumnIdentifier> notNullColumns = new HashSet<ColumnIdentifier>();
        if (this.notNullWhereClause != null) {
            for (ColumnIdentifier.Raw raw : this.notNullWhereClause) {
                notNullColumns.add(raw.prepare(cfm));
            }
        }
        boolean hasNonPKColumn = false;
        for (ColumnIdentifier.Raw raw : this.partitionKeys) {
            hasNonPKColumn = CreateMaterializedViewStatement.getColumnIdentifier(cfm, hashSet, hasNonPKColumn, raw, targetPartitionKeys, notNullColumns);
        }
        for (ColumnIdentifier.Raw raw : this.clusteringKeys) {
            hasNonPKColumn = CreateMaterializedViewStatement.getColumnIdentifier(cfm, hashSet, hasNonPKColumn, raw, targetClusteringColumns, notNullColumns);
        }
        boolean bl2 = false;
        StringBuilder columnNames = new StringBuilder();
        for (ColumnDefinition def : cfm.allColumns()) {
            ColumnIdentifier identifier;
            if (!def.isPrimaryKeyColumn() || targetClusteringColumns.contains(identifier = def.name) || targetPartitionKeys.contains(identifier)) continue;
            if (bl) {
                columnNames.append(',');
            } else {
                bl = true;
            }
            columnNames.append(identifier);
        }
        if (bl) {
            throw new InvalidRequestException(String.format("Cannot create Materialized View %s without primary key columns from base %s (%s)", this.columnFamily(), this.baseName.getColumnFamily(), columnNames.toString()));
        }
        if (targetPartitionKeys.isEmpty()) {
            throw new InvalidRequestException("Must select at least a column for a Materialized View");
        }
        if (targetClusteringColumns.isEmpty()) {
            throw new InvalidRequestException("No columns are defined for Materialized View other than primary key");
        }
        MaterializedViewDefinition definition = new MaterializedViewDefinition(this.baseName.getColumnFamily(), this.columnFamily(), targetPartitionKeys, targetClusteringColumns, included);
        CFMetaData indexCf = MaterializedView.getCFMetaData(definition, cfm, this.properties);
        try {
            MigrationManager.announceNewColumnFamily(indexCf, isLocalOnly);
        }
        catch (AlreadyExistsException e) {
            if (this.ifNotExists) {
                return false;
            }
            throw e;
        }
        CFMetaData newCfm = cfm.copy();
        newCfm.materializedViews(newCfm.getMaterializedViews().with(definition));
        MigrationManager.announceColumnFamilyUpdate(newCfm, false, isLocalOnly);
        return true;
    }

    private static boolean getColumnIdentifier(CFMetaData cfm, Set<ColumnIdentifier> basePK, boolean hasNonPKColumn, ColumnIdentifier.Raw raw, List<ColumnIdentifier> columns, Set<ColumnIdentifier> allowedPKColumns) {
        ColumnIdentifier identifier = raw.prepare(cfm);
        boolean isPk = basePK.contains(identifier);
        if (!isPk && hasNonPKColumn) {
            throw new InvalidRequestException(String.format("Cannot include more than one non-primary key column '%s' in materialized view partition key", identifier));
        }
        if (!allowedPKColumns.contains(identifier)) {
            throw new InvalidRequestException(String.format("Primary key column '%s' is required to be filtered by 'IS NOT NULL'", identifier));
        }
        columns.add(identifier);
        return !isPk;
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(Event.SchemaChange.Change.CREATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }
}

