/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Tuples;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.restrictions.MultiColumnRestriction;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.exceptions.InvalidRequestException;

public class MultiColumnRelation
extends Relation {
    private final List<ColumnIdentifier.Raw> entities;
    private final Term.MultiColumnRaw valuesOrMarker;
    private final List<? extends Term.MultiColumnRaw> inValues;
    private final Tuples.INRaw inMarker;

    private MultiColumnRelation(List<ColumnIdentifier.Raw> entities, Operator relationType, Term.MultiColumnRaw valuesOrMarker, List<? extends Term.MultiColumnRaw> inValues, Tuples.INRaw inMarker) {
        this.entities = entities;
        this.relationType = relationType;
        this.valuesOrMarker = valuesOrMarker;
        this.inValues = inValues;
        this.inMarker = inMarker;
    }

    public static MultiColumnRelation createNonInRelation(List<ColumnIdentifier.Raw> entities, Operator relationType, Term.MultiColumnRaw valuesOrMarker) {
        assert (relationType != Operator.IN);
        return new MultiColumnRelation(entities, relationType, valuesOrMarker, null, null);
    }

    public static MultiColumnRelation createInRelation(List<ColumnIdentifier.Raw> entities, List<? extends Term.MultiColumnRaw> inValues) {
        return new MultiColumnRelation(entities, Operator.IN, null, inValues, null);
    }

    public static MultiColumnRelation createSingleMarkerInRelation(List<ColumnIdentifier.Raw> entities, Tuples.INRaw inMarker) {
        return new MultiColumnRelation(entities, Operator.IN, null, null, inMarker);
    }

    public List<ColumnIdentifier.Raw> getEntities() {
        return this.entities;
    }

    private Term.MultiColumnRaw getValue() {
        return this.relationType == Operator.IN ? this.inMarker : this.valuesOrMarker;
    }

    @Override
    public boolean isMultiColumn() {
        return true;
    }

    @Override
    protected Restriction newEQRestriction(CFMetaData cfm, VariableSpecifications boundNames) throws InvalidRequestException {
        List<ColumnDefinition> receivers = this.receivers(cfm);
        Term term = this.toTerm(receivers, this.getValue(), cfm.ksName, boundNames);
        return new MultiColumnRestriction.EQRestriction(receivers, term);
    }

    @Override
    protected Restriction newINRestriction(CFMetaData cfm, VariableSpecifications boundNames) throws InvalidRequestException {
        List<ColumnDefinition> receivers = this.receivers(cfm);
        List<Term> terms = this.toTerms(receivers, this.inValues, cfm.ksName, boundNames);
        if (terms == null) {
            Term term = this.toTerm(receivers, this.getValue(), cfm.ksName, boundNames);
            return new MultiColumnRestriction.InRestrictionWithMarker(receivers, (AbstractMarker)term);
        }
        return new MultiColumnRestriction.InRestrictionWithValues(receivers, terms);
    }

    @Override
    protected Restriction newSliceRestriction(CFMetaData cfm, VariableSpecifications boundNames, Bound bound, boolean inclusive) throws InvalidRequestException {
        List<ColumnDefinition> receivers = this.receivers(cfm);
        Term term = this.toTerm(this.receivers(cfm), this.getValue(), cfm.ksName, boundNames);
        return new MultiColumnRestriction.SliceRestriction(receivers, bound, inclusive, term);
    }

    @Override
    protected Restriction newContainsRestriction(CFMetaData cfm, VariableSpecifications boundNames, boolean isKey) throws InvalidRequestException {
        throw RequestValidations.invalidRequest("%s cannot be used for Multi-column relations", new Object[]{this.operator()});
    }

    @Override
    protected Term toTerm(List<? extends ColumnSpecification> receivers, Term.Raw raw, String keyspace, VariableSpecifications boundNames) throws InvalidRequestException {
        Term term = ((Term.MultiColumnRaw)raw).prepare(keyspace, receivers);
        term.collectMarkerSpecification(boundNames);
        return term;
    }

    protected List<ColumnDefinition> receivers(CFMetaData cfm) throws InvalidRequestException {
        ArrayList<ColumnDefinition> names = new ArrayList<ColumnDefinition>(this.getEntities().size());
        int previousPosition = -1;
        for (ColumnIdentifier.Raw raw : this.getEntities()) {
            ColumnDefinition def = this.toColumnDefinition(cfm, raw);
            RequestValidations.checkTrue(def.isClusteringColumn(), "Multi-column relations can only be applied to clustering columns but was applied to: %s", def.name);
            RequestValidations.checkFalse(names.contains(def), "Column \"%s\" appeared twice in a relation: %s", def.name, this);
            RequestValidations.checkFalse(previousPosition != -1 && def.position() != previousPosition + 1, "Clustering columns must appear in the PRIMARY KEY order in multi-column relations: %s", this);
            names.add(def);
            previousPosition = def.position();
        }
        return names;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(Tuples.tupleToString(this.entities));
        if (this.isIN()) {
            return builder.append(" IN ").append(this.inMarker != null ? Character.valueOf('?') : Tuples.tupleToString(this.inValues)).toString();
        }
        return builder.append(" ").append((Object)this.relationType).append(" ").append(this.valuesOrMarker).toString();
    }
}

