/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.SimpleStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.StorageService;

public final class KeyspaceParams {
    public static final boolean DEFAULT_DURABLE_WRITES = true;
    public final boolean durableWrites;
    public final Replication replication;

    public KeyspaceParams(boolean durableWrites, Replication replication) {
        this.durableWrites = durableWrites;
        this.replication = replication;
    }

    public static KeyspaceParams create(boolean durableWrites, Map<String, String> replication) {
        return new KeyspaceParams(durableWrites, Replication.fromMap(replication));
    }

    public static KeyspaceParams local() {
        return new KeyspaceParams(true, Replication.local());
    }

    public static KeyspaceParams simple(int replicationFactor) {
        return new KeyspaceParams(true, Replication.simple(replicationFactor));
    }

    public static KeyspaceParams simpleTransient(int replicationFactor) {
        return new KeyspaceParams(false, Replication.simple(replicationFactor));
    }

    public void validate(String name) {
        this.replication.validate(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyspaceParams)) {
            return false;
        }
        KeyspaceParams p = (KeyspaceParams)o;
        return this.durableWrites == p.durableWrites && this.replication.equals(p.replication);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.durableWrites, this.replication});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add(Option.DURABLE_WRITES.toString(), this.durableWrites).add(Option.REPLICATION.toString(), (Object)this.replication).toString();
    }

    public static final class Replication {
        public static String CLASS = "class";
        public final Class<? extends AbstractReplicationStrategy> klass;
        public final ImmutableMap<String, String> options;

        private Replication(Class<? extends AbstractReplicationStrategy> klass, Map<String, String> options) {
            this.klass = klass;
            this.options = ImmutableMap.copyOf(options);
        }

        private static Replication local() {
            return new Replication(LocalStrategy.class, (Map<String, String>)ImmutableMap.of());
        }

        private static Replication simple(int replicationFactor) {
            return new Replication(SimpleStrategy.class, (Map<String, String>)ImmutableMap.of((Object)"replication_factor", (Object)Integer.toString(replicationFactor)));
        }

        public void validate(String name) {
            TokenMetadata tmd = StorageService.instance.getTokenMetadata();
            IEndpointSnitch eps = DatabaseDescriptor.getEndpointSnitch();
            AbstractReplicationStrategy.validateReplicationStrategy(name, this.klass, tmd, eps, this.options);
        }

        public static Replication fromMap(Map<String, String> map) {
            HashMap<String, String> options = new HashMap<String, String>(map);
            String className = (String)options.remove(CLASS);
            Class<AbstractReplicationStrategy> klass = AbstractReplicationStrategy.getClass(className);
            return new Replication(klass, options);
        }

        public Map<String, String> asMap() {
            HashMap<String, String> map = new HashMap<String, String>((Map<String, String>)this.options);
            map.put(CLASS, this.klass.getName());
            return map;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Replication)) {
                return false;
            }
            Replication r = (Replication)o;
            return this.klass.equals(r.klass) && this.options.equals(r.options);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.klass, this.options});
        }

        public String toString() {
            Objects.ToStringHelper helper = Objects.toStringHelper((Object)this);
            helper.add(CLASS, (Object)this.klass.getName());
            for (Map.Entry entry : this.options.entrySet()) {
                helper.add((String)entry.getKey(), entry.getValue());
            }
            return helper.toString();
        }
    }

    public static enum Option {
        DURABLE_WRITES,
        REPLICATION;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

