/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.util.concurrent.RateLimiter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.io.sstable.IndexSummaryBuilder;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.BufferedSegmentedFile;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.CompressedSegmentedFile;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.MmappedSegmentedFile;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.ThrottledReader;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.SharedCloseableImpl;

public abstract class SegmentedFile
extends SharedCloseableImpl {
    public final ChannelProxy channel;
    public final int bufferSize;
    public final long length;
    public final long onDiskLength;

    SegmentedFile(Cleanup cleanup, ChannelProxy channel, int bufferSize, long length) {
        this(cleanup, channel, bufferSize, length, length);
    }

    protected SegmentedFile(Cleanup cleanup, ChannelProxy channel, int bufferSize, long length, long onDiskLength) {
        super(cleanup);
        this.channel = channel;
        this.bufferSize = bufferSize;
        this.length = length;
        this.onDiskLength = onDiskLength;
    }

    public SegmentedFile(SegmentedFile copy) {
        super(copy);
        this.channel = copy.channel;
        this.bufferSize = copy.bufferSize;
        this.length = copy.length;
        this.onDiskLength = copy.onDiskLength;
    }

    public String path() {
        return this.channel.filePath();
    }

    @Override
    public abstract SegmentedFile sharedCopy();

    public RandomAccessReader createReader() {
        return RandomAccessReader.open(this.channel, this.bufferSize, this.length);
    }

    public RandomAccessReader createThrottledReader(RateLimiter limiter) {
        assert (limiter != null);
        return ThrottledReader.open(this.channel, this.bufferSize, this.length, limiter);
    }

    public FileDataInput getSegment(long position) {
        RandomAccessReader reader = this.createReader();
        reader.seek(position);
        return reader;
    }

    public void dropPageCache(long before) {
        CLibrary.trySkipCache(this.channel.getFileDescriptor(), 0L, before, this.path());
    }

    public static Builder getBuilder(Config.DiskAccessMode mode, boolean compressed) {
        return compressed ? new CompressedSegmentedFile.Builder(null) : (mode == Config.DiskAccessMode.mmap ? new MmappedSegmentedFile.Builder() : new BufferedSegmentedFile.Builder());
    }

    public static Builder getCompressedBuilder(CompressedSequentialWriter writer) {
        return new CompressedSegmentedFile.Builder(writer);
    }

    public Iterator<FileDataInput> iterator(long position) {
        return new SegmentIterator(position);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(path='" + this.path() + "'" + ", length=" + this.length + ")";
    }

    final class SegmentIterator
    implements Iterator<FileDataInput> {
        private long nextpos;

        public SegmentIterator(long position) {
            this.nextpos = position;
        }

        @Override
        public boolean hasNext() {
            return this.nextpos < SegmentedFile.this.length;
        }

        @Override
        public FileDataInput next() {
            long position = this.nextpos;
            if (position >= SegmentedFile.this.length) {
                throw new NoSuchElementException();
            }
            FileDataInput segment = SegmentedFile.this.getSegment(this.nextpos);
            try {
                this.nextpos += segment.bytesRemaining();
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, SegmentedFile.this.path());
            }
            return segment;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static final class Segment
    extends Pair<Long, MappedByteBuffer>
    implements Comparable<Segment> {
        public Segment(long offset, MappedByteBuffer segment) {
            super(offset, segment);
        }

        @Override
        public final int compareTo(Segment that) {
            return (int)Math.signum((Long)this.left - (Long)that.left);
        }
    }

    public static abstract class Builder
    implements AutoCloseable {
        private ChannelProxy channel;

        public abstract void addPotentialBoundary(long var1);

        protected abstract SegmentedFile complete(ChannelProxy var1, int var2, long var3);

        private SegmentedFile complete(String path, int bufferSize, long overrideLength) {
            ChannelProxy channelCopy = this.getChannel(path);
            try {
                return this.complete(channelCopy, bufferSize, overrideLength);
            }
            catch (Throwable t) {
                channelCopy.close();
                throw t;
            }
        }

        public SegmentedFile buildData(Descriptor desc, StatsMetadata stats, IndexSummaryBuilder.ReadableBoundary boundary) {
            return this.complete(desc.filenameFor(Component.DATA), this.bufferSize(stats), boundary.dataLength);
        }

        public SegmentedFile buildData(Descriptor desc, StatsMetadata stats) {
            return this.complete(desc.filenameFor(Component.DATA), this.bufferSize(stats), -1L);
        }

        public SegmentedFile buildIndex(Descriptor desc, IndexSummary indexSummary, IndexSummaryBuilder.ReadableBoundary boundary) {
            return this.complete(desc.filenameFor(Component.PRIMARY_INDEX), this.bufferSize(desc, indexSummary), boundary.indexLength);
        }

        public SegmentedFile buildIndex(Descriptor desc, IndexSummary indexSummary) {
            return this.complete(desc.filenameFor(Component.PRIMARY_INDEX), this.bufferSize(desc, indexSummary), -1L);
        }

        private int bufferSize(StatsMetadata stats) {
            return Builder.bufferSize(stats.estimatedPartitionSize.percentile(DatabaseDescriptor.getDiskOptimizationEstimatePercentile()));
        }

        private int bufferSize(Descriptor desc, IndexSummary indexSummary) {
            File file = new File(desc.filenameFor(Component.PRIMARY_INDEX));
            return Builder.bufferSize(file.length() / (long)indexSummary.size());
        }

        static int bufferSize(long recordSize) {
            Config.DiskOptimizationStrategy strategy = DatabaseDescriptor.getDiskOptimizationStrategy();
            if (strategy == Config.DiskOptimizationStrategy.ssd) {
                double pageCrossProbability = (double)(recordSize % 4096L) / 4096.0;
                if (pageCrossProbability - DatabaseDescriptor.getDiskOptimizationPageCrossChance() > -1.0E-16) {
                    recordSize += 4096L;
                }
                return Builder.roundBufferSize(recordSize);
            }
            if (strategy == Config.DiskOptimizationStrategy.spinning) {
                return Builder.roundBufferSize(recordSize + 4096L);
            }
            throw new IllegalStateException("Unsupported disk optimization strategy: " + (Object)((Object)strategy));
        }

        static int roundBufferSize(long size) {
            if (size <= 0L) {
                return 4096;
            }
            size = size + 4095L & 0xFFFFFFFFFFFFF000L;
            return (int)Math.min(size, 65536L);
        }

        public void serializeBounds(DataOutput out) throws IOException {
            out.writeUTF(DatabaseDescriptor.getDiskAccessMode().name());
        }

        public void deserializeBounds(DataInput in) throws IOException {
            if (!in.readUTF().equals(DatabaseDescriptor.getDiskAccessMode().name())) {
                throw new IOException("Cannot deserialize SSTable Summary component because the DiskAccessMode was changed!");
            }
        }

        public Throwable close(Throwable accumulate) {
            if (this.channel != null) {
                return this.channel.close(accumulate);
            }
            return accumulate;
        }

        @Override
        public void close() {
            Throwables.maybeFail(this.close(null));
        }

        private ChannelProxy getChannel(String path) {
            if (this.channel != null) {
                if (this.channel.filePath().equals(path)) {
                    return this.channel.sharedCopy();
                }
                this.channel.close();
            }
            this.channel = new ChannelProxy(path);
            return this.channel.sharedCopy();
        }
    }

    protected static abstract class Cleanup
    implements RefCounted.Tidy {
        final ChannelProxy channel;

        protected Cleanup(ChannelProxy channel) {
            this.channel = channel;
        }

        @Override
        public String name() {
            return this.channel.filePath();
        }

        @Override
        public void tidy() {
            this.channel.close();
        }
    }
}

