/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.metadata;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import com.google.common.collect.Maps;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.partitions.PartitionStatisticsCollector;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.CompactionMetadata;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.MurmurHash;
import org.apache.cassandra.utils.StreamingHistogram;

public class MetadataCollector
implements PartitionStatisticsCollector {
    public static final double NO_COMPRESSION_RATIO = -1.0;
    protected EstimatedHistogram estimatedPartitionSize = MetadataCollector.defaultPartitionSizeHistogram();
    protected EstimatedHistogram estimatedCellPerPartitionCount = MetadataCollector.defaultCellPerPartitionCountHistogram();
    protected ReplayPosition replayPosition = ReplayPosition.NONE;
    protected final MinMaxLongTracker timestampTracker = new MinMaxLongTracker();
    protected final MinMaxIntTracker localDeletionTimeTracker = new MinMaxIntTracker(Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected final MinMaxIntTracker ttlTracker = new MinMaxIntTracker(0, 0);
    protected double compressionRatio = -1.0;
    protected Set<Integer> ancestors = new HashSet<Integer>();
    protected StreamingHistogram estimatedTombstoneDropTime = MetadataCollector.defaultTombstoneDropTimeHistogram();
    protected int sstableLevel;
    protected ByteBuffer[] minClusteringValues;
    protected ByteBuffer[] maxClusteringValues;
    protected boolean hasLegacyCounterShards = false;
    protected long totalColumnsSet;
    protected long totalRows;
    protected ICardinality cardinality = new HyperLogLogPlus(13, 25);
    private final ClusteringComparator comparator;

    static EstimatedHistogram defaultCellPerPartitionCountHistogram() {
        return new EstimatedHistogram(114);
    }

    static EstimatedHistogram defaultPartitionSizeHistogram() {
        return new EstimatedHistogram(150);
    }

    static StreamingHistogram defaultTombstoneDropTimeHistogram() {
        return new StreamingHistogram(100);
    }

    public static StatsMetadata defaultStatsMetadata() {
        return new StatsMetadata(MetadataCollector.defaultPartitionSizeHistogram(), MetadataCollector.defaultCellPerPartitionCountHistogram(), ReplayPosition.NONE, Long.MIN_VALUE, Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, -1.0, MetadataCollector.defaultTombstoneDropTimeHistogram(), 0, Collections.emptyList(), Collections.emptyList(), true, 0L, -1L, -1L);
    }

    public MetadataCollector(ClusteringComparator comparator) {
        this.comparator = comparator;
        this.minClusteringValues = new ByteBuffer[comparator.size()];
        this.maxClusteringValues = new ByteBuffer[comparator.size()];
    }

    public MetadataCollector(Iterable<SSTableReader> sstables, ClusteringComparator comparator, int level, boolean skipAncestors) {
        this(comparator);
        this.replayPosition(ReplayPosition.getReplayPosition(sstables));
        this.sstableLevel(level);
        if (!skipAncestors) {
            for (SSTableReader sstable : sstables) {
                this.addAncestor(sstable.descriptor.generation);
                for (Integer i : sstable.getAncestors()) {
                    if (!new File(sstable.descriptor.withGeneration(i).filenameFor(Component.DATA)).exists()) continue;
                    this.addAncestor(i);
                }
            }
        }
    }

    public MetadataCollector(Iterable<SSTableReader> sstables, ClusteringComparator comparator, int level) {
        this(sstables, comparator, level, false);
    }

    public MetadataCollector addKey(ByteBuffer key) {
        long hashed = MurmurHash.hash2_64(key, key.position(), key.remaining(), 0L);
        this.cardinality.offerHashed(hashed);
        return this;
    }

    public MetadataCollector addPartitionSizeInBytes(long partitionSize) {
        this.estimatedPartitionSize.add(partitionSize);
        return this;
    }

    public MetadataCollector addCellPerPartitionCount(long cellCount) {
        this.estimatedCellPerPartitionCount.add(cellCount);
        return this;
    }

    public MetadataCollector mergeTombstoneHistogram(StreamingHistogram histogram) {
        this.estimatedTombstoneDropTime.merge(histogram);
        return this;
    }

    public MetadataCollector addCompressionRatio(long compressed, long uncompressed) {
        this.compressionRatio = (double)compressed / (double)uncompressed;
        return this;
    }

    @Override
    public void update(LivenessInfo newInfo) {
        if (newInfo.isEmpty()) {
            return;
        }
        this.updateTimestamp(newInfo.timestamp());
        if (newInfo.isExpiring()) {
            this.updateTTL(newInfo.ttl());
            this.updateLocalDeletionTime(newInfo.localExpirationTime());
        }
    }

    @Override
    public void update(Cell cell) {
        this.updateTimestamp(cell.timestamp());
        this.updateTTL(cell.ttl());
        this.updateLocalDeletionTime(cell.localDeletionTime());
    }

    @Override
    public void update(DeletionTime dt) {
        if (!dt.isLive()) {
            this.updateTimestamp(dt.markedForDeleteAt());
            this.updateLocalDeletionTime(dt.localDeletionTime());
        }
    }

    @Override
    public void updateColumnSetPerRow(long columnSetInRow) {
        this.totalColumnsSet += columnSetInRow;
        ++this.totalRows;
    }

    private void updateTimestamp(long newTimestamp) {
        this.timestampTracker.update(newTimestamp);
    }

    private void updateLocalDeletionTime(int newLocalDeletionTime) {
        this.localDeletionTimeTracker.update(newLocalDeletionTime);
        this.estimatedTombstoneDropTime.update(newLocalDeletionTime);
    }

    private void updateTTL(int newTTL) {
        this.ttlTracker.update(newTTL);
    }

    public MetadataCollector replayPosition(ReplayPosition replayPosition) {
        this.replayPosition = replayPosition;
        return this;
    }

    public MetadataCollector addAncestor(int generation) {
        this.ancestors.add(generation);
        return this;
    }

    public MetadataCollector sstableLevel(int sstableLevel) {
        this.sstableLevel = sstableLevel;
        return this;
    }

    public MetadataCollector updateClusteringValues(ClusteringPrefix clustering) {
        int size = clustering.size();
        for (int i = 0; i < size; ++i) {
            AbstractType<?> type = this.comparator.subtype(i);
            ByteBuffer newValue = clustering.get(i);
            this.minClusteringValues[i] = MetadataCollector.min(this.minClusteringValues[i], newValue, type);
            this.maxClusteringValues[i] = MetadataCollector.max(this.maxClusteringValues[i], newValue, type);
        }
        return this;
    }

    private static ByteBuffer min(ByteBuffer b1, ByteBuffer b2, AbstractType<?> comparator) {
        if (b1 == null) {
            return b2;
        }
        if (b2 == null) {
            return b1;
        }
        if (comparator.compare(b1, b2) >= 0) {
            return b2;
        }
        return b1;
    }

    private static ByteBuffer max(ByteBuffer b1, ByteBuffer b2, AbstractType<?> comparator) {
        if (b1 == null) {
            return b2;
        }
        if (b2 == null) {
            return b1;
        }
        if (comparator.compare(b1, b2) >= 0) {
            return b1;
        }
        return b2;
    }

    @Override
    public void updateHasLegacyCounterShards(boolean hasLegacyCounterShards) {
        this.hasLegacyCounterShards = this.hasLegacyCounterShards || hasLegacyCounterShards;
    }

    public Map<MetadataType, MetadataComponent> finalizeMetadata(String partitioner, double bloomFilterFPChance, long repairedAt, SerializationHeader header) {
        HashMap components = Maps.newHashMap();
        components.put(MetadataType.VALIDATION, new ValidationMetadata(partitioner, bloomFilterFPChance));
        components.put(MetadataType.STATS, new StatsMetadata(this.estimatedPartitionSize, this.estimatedCellPerPartitionCount, this.replayPosition, this.timestampTracker.min(), this.timestampTracker.max(), this.localDeletionTimeTracker.min(), this.localDeletionTimeTracker.max(), this.ttlTracker.min(), this.ttlTracker.max(), this.compressionRatio, this.estimatedTombstoneDropTime, this.sstableLevel, MetadataCollector.makeList(this.minClusteringValues), MetadataCollector.makeList(this.maxClusteringValues), this.hasLegacyCounterShards, repairedAt, this.totalColumnsSet, this.totalRows));
        components.put(MetadataType.COMPACTION, new CompactionMetadata(this.ancestors, this.cardinality));
        components.put(MetadataType.HEADER, header.toComponent());
        return components;
    }

    private static List<ByteBuffer> makeList(ByteBuffer[] values) {
        ArrayList<ByteBuffer> l = new ArrayList<ByteBuffer>(values.length);
        for (int i = 0; i < values.length && values[i] != null; ++i) {
            l.add(values[i]);
        }
        return l;
    }

    public static class MinMaxIntTracker {
        private final int defaultMin;
        private final int defaultMax;
        private boolean isSet = false;
        private int min;
        private int max;

        public MinMaxIntTracker() {
            this(Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        public MinMaxIntTracker(int defaultMin, int defaultMax) {
            this.defaultMin = defaultMin;
            this.defaultMax = defaultMax;
        }

        public void update(int value) {
            if (!this.isSet) {
                this.min = this.max = value;
                this.isSet = true;
            } else {
                if (value < this.min) {
                    this.min = value;
                }
                if (value > this.max) {
                    this.max = value;
                }
            }
        }

        public int min() {
            return this.isSet ? this.min : this.defaultMin;
        }

        public int max() {
            return this.isSet ? this.max : this.defaultMax;
        }
    }

    public static class MinMaxLongTracker {
        private final long defaultMin;
        private final long defaultMax;
        private boolean isSet = false;
        private long min;
        private long max;

        public MinMaxLongTracker() {
            this(Long.MIN_VALUE, Long.MAX_VALUE);
        }

        public MinMaxLongTracker(long defaultMin, long defaultMax) {
            this.defaultMin = defaultMin;
            this.defaultMax = defaultMax;
        }

        public void update(long value) {
            if (!this.isSet) {
                this.min = this.max = value;
                this.isSet = true;
            } else {
                if (value < this.min) {
                    this.min = value;
                }
                if (value > this.max) {
                    this.max = value;
                }
            }
        }

        public long min() {
            return this.isSet ? this.min : this.defaultMin;
        }

        public long max() {
            return this.isSet ? this.max : this.defaultMax;
        }
    }
}

