/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import com.google.common.collect.AbstractIterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;

public abstract class LazilyInitializedUnfilteredRowIterator
extends AbstractIterator<Unfiltered>
implements UnfilteredRowIterator {
    private final DecoratedKey partitionKey;
    private UnfilteredRowIterator iterator;

    public LazilyInitializedUnfilteredRowIterator(DecoratedKey partitionKey) {
        this.partitionKey = partitionKey;
    }

    protected abstract UnfilteredRowIterator initializeIterator();

    private void maybeInit() {
        if (this.iterator == null) {
            this.iterator = this.initializeIterator();
        }
    }

    @Override
    public CFMetaData metadata() {
        this.maybeInit();
        return this.iterator.metadata();
    }

    @Override
    public PartitionColumns columns() {
        this.maybeInit();
        return this.iterator.columns();
    }

    @Override
    public boolean isReverseOrder() {
        this.maybeInit();
        return this.iterator.isReverseOrder();
    }

    @Override
    public DecoratedKey partitionKey() {
        return this.partitionKey;
    }

    @Override
    public DeletionTime partitionLevelDeletion() {
        this.maybeInit();
        return this.iterator.partitionLevelDeletion();
    }

    @Override
    public Row staticRow() {
        this.maybeInit();
        return this.iterator.staticRow();
    }

    @Override
    public EncodingStats stats() {
        this.maybeInit();
        return this.iterator.stats();
    }

    protected Unfiltered computeNext() {
        this.maybeInit();
        return this.iterator.hasNext() ? (Unfiltered)this.iterator.next() : (Unfiltered)this.endOfData();
    }

    @Override
    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
        }
    }
}

