/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DeletionPurger;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.AbstractRow;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Cells;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.BTreeSearchIterator;
import org.apache.cassandra.utils.btree.UpdateFunction;

public class BTreeBackedRow
extends AbstractRow {
    private static final ColumnData[] NO_DATA = new ColumnData[0];
    private static final long EMPTY_SIZE = ObjectSizes.measure(BTreeBackedRow.emptyRow(Clustering.EMPTY));
    private final Clustering clustering;
    private final Columns columns;
    private final LivenessInfo primaryKeyLivenessInfo;
    private final DeletionTime deletion;
    private final Object[] btree;
    private final int minLocalDeletionTime;

    private BTreeBackedRow(Clustering clustering, Columns columns, LivenessInfo primaryKeyLivenessInfo, DeletionTime deletion, Object[] btree, int minLocalDeletionTime) {
        this.clustering = clustering;
        this.columns = columns;
        this.primaryKeyLivenessInfo = primaryKeyLivenessInfo;
        this.deletion = deletion;
        this.btree = btree;
        this.minLocalDeletionTime = minLocalDeletionTime;
    }

    public static BTreeBackedRow create(Clustering clustering, Columns columns, LivenessInfo primaryKeyLivenessInfo, DeletionTime deletion, Object[] btree) {
        int minDeletionTime = Math.min(BTreeBackedRow.minDeletionTime(primaryKeyLivenessInfo), BTreeBackedRow.minDeletionTime(deletion));
        if (minDeletionTime != Integer.MIN_VALUE) {
            for (ColumnData cd : BTree.iterable(btree)) {
                minDeletionTime = Math.min(minDeletionTime, BTreeBackedRow.minDeletionTime(cd));
            }
        }
        return new BTreeBackedRow(clustering, columns, primaryKeyLivenessInfo, deletion, btree, minDeletionTime);
    }

    public static BTreeBackedRow emptyRow(Clustering clustering) {
        return new BTreeBackedRow(clustering, Columns.NONE, LivenessInfo.EMPTY, DeletionTime.LIVE, BTree.empty(), Integer.MAX_VALUE);
    }

    public static BTreeBackedRow singleCellRow(Clustering clustering, Cell cell) {
        if (cell.column().isSimple()) {
            return new BTreeBackedRow(clustering, Columns.of(cell.column()), LivenessInfo.EMPTY, DeletionTime.LIVE, BTree.singleton(cell), BTreeBackedRow.minDeletionTime(cell));
        }
        ComplexColumnData complexData = new ComplexColumnData(cell.column(), new Cell[]{cell}, DeletionTime.LIVE);
        return new BTreeBackedRow(clustering, Columns.of(cell.column()), LivenessInfo.EMPTY, DeletionTime.LIVE, BTree.singleton(complexData), BTreeBackedRow.minDeletionTime(cell));
    }

    public static BTreeBackedRow emptyDeletedRow(Clustering clustering, DeletionTime deletion) {
        assert (!deletion.isLive());
        return new BTreeBackedRow(clustering, Columns.NONE, LivenessInfo.EMPTY, deletion, BTree.empty(), Integer.MIN_VALUE);
    }

    public static BTreeBackedRow noCellLiveRow(Clustering clustering, LivenessInfo primaryKeyLivenessInfo) {
        assert (!primaryKeyLivenessInfo.isEmpty());
        return new BTreeBackedRow(clustering, Columns.NONE, primaryKeyLivenessInfo, DeletionTime.LIVE, BTree.empty(), BTreeBackedRow.minDeletionTime(primaryKeyLivenessInfo));
    }

    private static int minDeletionTime(Cell cell) {
        return cell.isTombstone() ? Integer.MIN_VALUE : cell.localDeletionTime();
    }

    private static int minDeletionTime(LivenessInfo info) {
        return info.isExpiring() ? info.localExpirationTime() : Integer.MAX_VALUE;
    }

    private static int minDeletionTime(DeletionTime dt) {
        return dt.isLive() ? Integer.MAX_VALUE : Integer.MIN_VALUE;
    }

    private static int minDeletionTime(ComplexColumnData cd) {
        Cell cell;
        int min = BTreeBackedRow.minDeletionTime(cd.complexDeletion());
        Iterator<Cell> iterator = cd.iterator();
        while (iterator.hasNext() && (min = Math.min(min, BTreeBackedRow.minDeletionTime(cell = iterator.next()))) != Integer.MIN_VALUE) {
        }
        return min;
    }

    private static int minDeletionTime(ColumnData cd) {
        return cd.column().isSimple() ? BTreeBackedRow.minDeletionTime((Cell)cd) : BTreeBackedRow.minDeletionTime((ComplexColumnData)cd);
    }

    private static int minDeletionTime(Object[] btree, LivenessInfo info, DeletionTime rowDeletion) {
        ColumnData cd;
        int min = Math.min(BTreeBackedRow.minDeletionTime(info), BTreeBackedRow.minDeletionTime(rowDeletion));
        Iterator iterator = BTree.iterable(btree).iterator();
        while (iterator.hasNext() && (min = Math.min(min, BTreeBackedRow.minDeletionTime(cd = (ColumnData)iterator.next()))) != Integer.MIN_VALUE) {
        }
        return min;
    }

    @Override
    public Clustering clustering() {
        return this.clustering;
    }

    @Override
    public Columns columns() {
        return this.columns;
    }

    @Override
    public LivenessInfo primaryKeyLivenessInfo() {
        return this.primaryKeyLivenessInfo;
    }

    @Override
    public DeletionTime deletion() {
        return this.deletion;
    }

    @Override
    public Cell getCell(ColumnDefinition c) {
        assert (!c.isComplex());
        return (Cell)((Object)BTree.find(this.btree, ColumnDefinition.asymmetricColumnDataComparator, c));
    }

    @Override
    public Cell getCell(ColumnDefinition c, CellPath path) {
        assert (c.isComplex());
        ComplexColumnData cd = this.getComplexColumnData(c);
        if (cd == null) {
            return null;
        }
        return cd.getCell(path);
    }

    @Override
    public ComplexColumnData getComplexColumnData(ColumnDefinition c) {
        assert (c.isComplex());
        return (ComplexColumnData)((Object)BTree.find(this.btree, ColumnDefinition.asymmetricColumnDataComparator, c));
    }

    @Override
    public Iterator<ColumnData> iterator() {
        return this.searchIterator();
    }

    @Override
    public Iterable<Cell> cells() {
        return () -> new CellIterator();
    }

    public BTreeSearchIterator<ColumnDefinition, ColumnData> searchIterator() {
        return BTree.slice(this.btree, ColumnDefinition.asymmetricColumnDataComparator, BTree.Dir.ASC);
    }

    @Override
    public Row filter(ColumnFilter filter, CFMetaData metadata) {
        return this.filter(filter, DeletionTime.LIVE, false, metadata);
    }

    @Override
    public Row filter(ColumnFilter filter, DeletionTime activeDeletion, boolean setActiveDeletionToRow, CFMetaData metadata) {
        Map<ByteBuffer, CFMetaData.DroppedColumn> droppedColumns = metadata.getDroppedColumns();
        if (filter.includesAllColumns() && (activeDeletion.isLive() || this.deletion.supersedes(activeDeletion)) && droppedColumns.isEmpty()) {
            return this;
        }
        boolean mayHaveShadowed = activeDeletion.supersedes(this.deletion);
        LivenessInfo newInfo = this.primaryKeyLivenessInfo;
        DeletionTime newDeletion = this.deletion;
        if (mayHaveShadowed) {
            if (activeDeletion.deletes(newInfo.timestamp())) {
                newInfo = LivenessInfo.EMPTY;
            }
            newDeletion = setActiveDeletionToRow ? activeDeletion : DeletionTime.LIVE;
        }
        Columns columns = filter.fetchedColumns().columns(this.isStatic());
        Predicate<ColumnDefinition> inclusionTester = columns.inOrderInclusionTester();
        return this.transformAndFilter(newInfo, newDeletion, (Function<ColumnData, ColumnData>)((Function)cd -> {
            ColumnDefinition column = cd.column();
            if (!inclusionTester.test(column)) {
                return null;
            }
            CFMetaData.DroppedColumn dropped = (CFMetaData.DroppedColumn)droppedColumns.get(column.name.bytes);
            if (column.isComplex()) {
                return ((ComplexColumnData)cd).filter(filter, mayHaveShadowed ? activeDeletion : DeletionTime.LIVE, dropped);
            }
            Cell cell = (Cell)cd;
            return !(dropped != null && cell.timestamp() <= dropped.droppedTime || mayHaveShadowed && activeDeletion.deletes(cell)) ? cell : null;
        }));
    }

    @Override
    public boolean hasComplexDeletion() {
        for (ColumnData cd : BTree.iterable(this.btree, BTree.Dir.DESC)) {
            if (cd.column().isSimple()) {
                return false;
            }
            if (((ComplexColumnData)cd).complexDeletion().isLive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Row markCounterLocalToBeCleared() {
        return this.transformAndFilter(this.primaryKeyLivenessInfo, this.deletion, (Function<ColumnData, ColumnData>)((Function)cd -> cd.column().cellValueType().isCounter() ? cd.markCounterLocalToBeCleared() : cd));
    }

    @Override
    public boolean hasDeletion(int nowInSec) {
        return nowInSec >= this.minLocalDeletionTime;
    }

    @Override
    public Row updateAllTimestamp(long newTimestamp) {
        LivenessInfo newInfo = this.primaryKeyLivenessInfo.isEmpty() ? this.primaryKeyLivenessInfo : this.primaryKeyLivenessInfo.withUpdatedTimestamp(newTimestamp);
        DeletionTime newDeletion = this.deletion.isLive() ? this.deletion : new DeletionTime(newTimestamp - 1L, this.deletion.localDeletionTime());
        return this.transformAndFilter(newInfo, newDeletion, (Function<ColumnData, ColumnData>)((Function)cd -> cd.updateAllTimestamp(newTimestamp)));
    }

    @Override
    public Row purge(DeletionPurger purger, int nowInSec) {
        if (!this.hasDeletion(nowInSec)) {
            return this;
        }
        LivenessInfo newInfo = purger.shouldPurge(this.primaryKeyLivenessInfo, nowInSec) ? LivenessInfo.EMPTY : this.primaryKeyLivenessInfo;
        DeletionTime newDeletion = purger.shouldPurge(this.deletion) ? DeletionTime.LIVE : this.deletion;
        return this.transformAndFilter(newInfo, newDeletion, (Function<ColumnData, ColumnData>)((Function)cd -> cd.purge(purger, nowInSec)));
    }

    private Row transformAndFilter(LivenessInfo info, DeletionTime deletion, Function<ColumnData, ColumnData> function) {
        Object[] transformed = BTree.transformAndFilter(this.btree, function);
        if (this.btree == transformed && info == this.primaryKeyLivenessInfo && deletion == this.deletion) {
            return this;
        }
        if (info.isEmpty() && deletion.isLive() && BTree.isEmpty(transformed)) {
            return null;
        }
        int minDeletionTime = BTreeBackedRow.minDeletionTime(transformed, info, deletion);
        return new BTreeBackedRow(this.clustering, this.columns, info, deletion, transformed, minDeletionTime);
    }

    @Override
    public int dataSize() {
        int dataSize = this.clustering.dataSize() + this.primaryKeyLivenessInfo.dataSize() + this.deletion.dataSize();
        for (ColumnData cd : this) {
            dataSize += cd.dataSize();
        }
        return dataSize;
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        long heapSize = EMPTY_SIZE + this.clustering.unsharedHeapSizeExcludingData() + BTree.sizeOfStructureOnHeap(this.btree);
        for (ColumnData cd : this) {
            heapSize += cd.unsharedHeapSizeExcludingData();
        }
        return heapSize;
    }

    public static Row.Builder sortedBuilder(Columns columns) {
        return new Builder(columns, true);
    }

    public static Row.Builder unsortedBuilder(Columns columns, int nowInSec) {
        return new Builder(columns, false, nowInSec);
    }

    public void setValue(ColumnDefinition column, CellPath path, ByteBuffer value) {
        ColumnData current = (ColumnData)((Object)BTree.find(this.btree, ColumnDefinition.asymmetricColumnDataComparator, column));
        if (column.isSimple()) {
            BTree.replaceInSitu(this.btree, ColumnData.comparator, current, ((Cell)current).withUpdatedValue(value));
        } else {
            ((ComplexColumnData)current).setValue(path, value);
        }
    }

    public static class Builder
    implements Row.Builder {
        protected final Columns columns;
        protected Clustering clustering;
        protected LivenessInfo primaryKeyLivenessInfo = LivenessInfo.EMPTY;
        protected DeletionTime deletion = DeletionTime.LIVE;
        private final boolean isSorted;
        private final BTree.Builder<Cell> cells;
        private final CellResolver resolver;
        private boolean hasComplex = false;

        protected Builder(Columns columns, boolean isSorted) {
            this(columns, isSorted, Integer.MIN_VALUE);
        }

        protected Builder(Columns columns, boolean isSorted, int nowInSecs) {
            this.columns = columns;
            this.cells = BTree.builder(ColumnData.comparator);
            this.resolver = new CellResolver(nowInSecs);
            this.isSorted = isSorted;
            this.cells.auto(false);
        }

        @Override
        public boolean isSorted() {
            return this.isSorted;
        }

        @Override
        public void newRow(Clustering clustering) {
            assert (this.clustering == null);
            this.clustering = clustering;
        }

        @Override
        public Clustering clustering() {
            return this.clustering;
        }

        protected void reset() {
            this.clustering = null;
            this.primaryKeyLivenessInfo = LivenessInfo.EMPTY;
            this.deletion = DeletionTime.LIVE;
            this.cells.reuse();
        }

        @Override
        public void addPrimaryKeyLivenessInfo(LivenessInfo info) {
            this.primaryKeyLivenessInfo = info;
        }

        @Override
        public void addRowDeletion(DeletionTime deletion) {
            this.deletion = deletion;
        }

        @Override
        public void addCell(Cell cell) {
            assert (cell.column().isStatic() == (this.clustering == Clustering.STATIC_CLUSTERING)) : "Column is " + cell.column() + ", clustering = " + this.clustering;
            this.cells.add(cell);
            this.hasComplex |= cell.column.isComplex();
        }

        @Override
        public void addComplexDeletion(ColumnDefinition column, DeletionTime complexDeletion) {
            this.cells.add(new ComplexColumnDeletion(column, complexDeletion));
            this.hasComplex = true;
        }

        @Override
        public Row build() {
            if (!this.isSorted) {
                this.cells.sort();
            }
            if (!this.isSorted | this.hasComplex) {
                this.cells.resolve(this.resolver);
            }
            Object[] btree = this.cells.build();
            int minDeletionTime = BTreeBackedRow.minDeletionTime(btree, this.primaryKeyLivenessInfo, this.deletion);
            BTreeBackedRow row = new BTreeBackedRow(this.clustering, this.columns, this.primaryKeyLivenessInfo, this.deletion, btree, minDeletionTime);
            this.reset();
            return row;
        }

        private static class CellResolver
        implements BTree.Builder.Resolver {
            final int nowInSec;

            private CellResolver(int nowInSec) {
                this.nowInSec = nowInSec;
            }

            @Override
            public ColumnData resolve(Object[] cells, int lb, int ub) {
                Cell cell = (Cell)cells[lb];
                ColumnDefinition column = cell.column;
                if (cell.column.isSimple()) {
                    assert (lb + 1 == ub || this.nowInSec != Integer.MIN_VALUE);
                    while (++lb < ub) {
                        cell = Cells.reconcile(cell, (Cell)cells[lb], this.nowInSec);
                    }
                    return cell;
                }
                Arrays.sort(cells, lb, ub, column.cellComparator());
                cell = (Cell)cells[lb];
                DeletionTime deletion = DeletionTime.LIVE;
                if (cell instanceof ComplexColumnDeletion) {
                    deletion = new DeletionTime(cell.timestamp(), cell.localDeletionTime());
                    ++lb;
                }
                List<Object> buildFrom = Arrays.asList(cells).subList(lb, ub);
                Object[] btree = BTree.build(buildFrom, UpdateFunction.noOp());
                return new ComplexColumnData(column, btree, deletion);
            }
        }

        private static class ComplexColumnDeletion
        extends BufferCell {
            public ComplexColumnDeletion(ColumnDefinition column, DeletionTime deletionTime) {
                super(column, deletionTime.markedForDeleteAt(), 0, deletionTime.localDeletionTime(), ByteBufferUtil.EMPTY_BYTE_BUFFER, CellPath.BOTTOM);
            }
        }
    }

    private class CellIterator
    extends AbstractIterator<Cell> {
        private Iterator<ColumnData> columnData;
        private Iterator<Cell> complexCells;

        private CellIterator() {
            this.columnData = BTreeBackedRow.this.iterator();
        }

        protected Cell computeNext() {
            ColumnData cd;
            while (true) {
                if (this.complexCells != null) {
                    if (this.complexCells.hasNext()) {
                        return this.complexCells.next();
                    }
                    this.complexCells = null;
                }
                if (!this.columnData.hasNext()) {
                    return (Cell)this.endOfData();
                }
                cd = this.columnData.next();
                if (!cd.column().isComplex()) break;
                this.complexCells = ((ComplexColumnData)cd).iterator();
            }
            return (Cell)cd;
        }
    }
}

