/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.CountingRowIterator;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.WrappingPartitionIterator;
import org.apache.cassandra.db.rows.RowIterator;

public class CountingPartitionIterator
extends WrappingPartitionIterator {
    protected final DataLimits.Counter counter;

    public CountingPartitionIterator(PartitionIterator result, DataLimits.Counter counter) {
        super(result);
        this.counter = counter;
    }

    public CountingPartitionIterator(PartitionIterator result, DataLimits limits, int nowInSec) {
        this(result, limits.newCounter(nowInSec, true));
    }

    public DataLimits.Counter counter() {
        return this.counter;
    }

    @Override
    public boolean hasNext() {
        if (this.counter.isDone()) {
            return false;
        }
        return super.hasNext();
    }

    @Override
    public RowIterator next() {
        return new CountingRowIterator(super.next(), this.counter);
    }
}

