/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.AbstractUnfilteredRowIterator;
import org.apache.cassandra.db.rows.BTreeBackedRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowAndDeletionMergeIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.SearchIterator;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.BTreeSearchIterator;
import org.apache.cassandra.utils.btree.UpdateFunction;
import org.apache.cassandra.utils.concurrent.Locks;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.HeapAllocator;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicBTreePartition
implements Partition {
    private static final Logger logger = LoggerFactory.getLogger(AtomicBTreePartition.class);
    public static final long EMPTY_SIZE = ObjectSizes.measure(new AtomicBTreePartition(CFMetaData.createFake("keyspace", "table"), StorageService.getPartitioner().decorateKey(ByteBuffer.allocate(1)), null));
    private static final int TRACKER_NEVER_WASTED = 0;
    private static final int TRACKER_PESSIMISTIC_LOCKING = Integer.MAX_VALUE;
    private static final int ALLOCATION_GRANULARITY_BYTES = 1024;
    private static final long EXCESS_WASTE_BYTES = 0xA00000L;
    private static final int EXCESS_WASTE_OFFSET = 10240;
    private static final int CLOCK_SHIFT = 17;
    private volatile int wasteTracker = 0;
    private static final AtomicIntegerFieldUpdater<AtomicBTreePartition> wasteTrackerUpdater = AtomicIntegerFieldUpdater.newUpdater(AtomicBTreePartition.class, "wasteTracker");
    private static final Holder EMPTY = new Holder(BTree.empty(), DeletionInfo.LIVE, Rows.EMPTY_STATIC_ROW, EncodingStats.NO_STATS);
    private final CFMetaData metadata;
    private final DecoratedKey partitionKey;
    private final MemtableAllocator allocator;
    private volatile Holder ref;
    private static final AtomicReferenceFieldUpdater<AtomicBTreePartition, Holder> refUpdater = AtomicReferenceFieldUpdater.newUpdater(AtomicBTreePartition.class, Holder.class, "ref");

    public AtomicBTreePartition(CFMetaData metadata, DecoratedKey partitionKey, MemtableAllocator allocator) {
        this.metadata = metadata;
        this.partitionKey = partitionKey;
        this.allocator = allocator;
        this.ref = EMPTY;
    }

    @Override
    public boolean isEmpty() {
        return this.ref.deletionInfo.isLive() && BTree.isEmpty(this.ref.tree) && this.ref.staticRow == null;
    }

    @Override
    public CFMetaData metadata() {
        return this.metadata;
    }

    @Override
    public DecoratedKey partitionKey() {
        return this.partitionKey;
    }

    @Override
    public DeletionTime partitionLevelDeletion() {
        return this.ref.deletionInfo.getPartitionDeletion();
    }

    @Override
    public PartitionColumns columns() {
        return this.metadata.partitionColumns();
    }

    public boolean hasRows() {
        return !BTree.isEmpty(this.ref.tree);
    }

    @Override
    public EncodingStats stats() {
        return this.ref.stats;
    }

    @Override
    public Row getRow(Clustering clustering) {
        Row row = this.searchIterator(ColumnFilter.selection(this.columns()), false).next(clustering);
        return row == null || clustering == Clustering.STATIC_CLUSTERING && row.isEmpty() ? null : row;
    }

    private Row staticRow(Holder current, ColumnFilter columns, boolean setActiveDeletionToRow) {
        DeletionTime partitionDeletion = current.deletionInfo.getPartitionDeletion();
        if (columns.fetchedColumns().statics.isEmpty() || current.staticRow.isEmpty() && partitionDeletion.isLive()) {
            return Rows.EMPTY_STATIC_ROW;
        }
        Row row = current.staticRow.filter(columns, partitionDeletion, setActiveDeletionToRow, this.metadata);
        return row == null ? Rows.EMPTY_STATIC_ROW : row;
    }

    @Override
    public SearchIterator<Clustering, Row> searchIterator(final ColumnFilter columns, final boolean reversed) {
        final Holder current = this.ref;
        return new SearchIterator<Clustering, Row>(){
            private final SearchIterator<Clustering, Row> rawIter;
            private final DeletionTime partitionDeletion;
            {
                this.rawIter = new BTreeSearchIterator<Clusterable, Row>(current.tree, ((AtomicBTreePartition)AtomicBTreePartition.this).metadata.comparator, BTree.Dir.desc(reversed));
                this.partitionDeletion = current.deletionInfo.getPartitionDeletion();
            }

            @Override
            public boolean hasNext() {
                return this.rawIter.hasNext();
            }

            @Override
            public Row next(Clustering clustering) {
                if (clustering == Clustering.STATIC_CLUSTERING) {
                    return AtomicBTreePartition.this.staticRow(current, columns, true);
                }
                Row row = this.rawIter.next(clustering);
                RangeTombstone rt = current.deletionInfo.rangeCovering(clustering);
                DeletionTime activeDeletion = this.partitionDeletion;
                if (rt != null && rt.deletionTime().supersedes(activeDeletion)) {
                    activeDeletion = rt.deletionTime();
                }
                if (row == null) {
                    return activeDeletion.isLive() ? null : BTreeBackedRow.emptyDeletedRow(clustering, activeDeletion);
                }
                return row.filter(columns, activeDeletion, true, AtomicBTreePartition.this.metadata);
            }
        };
    }

    @Override
    public UnfilteredRowIterator unfilteredIterator() {
        return this.unfilteredIterator(ColumnFilter.all(this.metadata()), Slices.ALL, false);
    }

    @Override
    public UnfilteredRowIterator unfilteredIterator(ColumnFilter selection, Slices slices, boolean reversed) {
        if (slices.size() == 0) {
            Holder current = this.ref;
            DeletionTime partitionDeletion = current.deletionInfo.getPartitionDeletion();
            if (selection.fetchedColumns().statics.isEmpty() && partitionDeletion.isLive()) {
                return UnfilteredRowIterators.emptyIterator(this.metadata, this.partitionKey, reversed);
            }
            return new AbstractUnfilteredRowIterator(this.metadata, this.partitionKey, partitionDeletion, selection.fetchedColumns(), this.staticRow(current, selection, false), reversed, current.stats){

                protected Unfiltered computeNext() {
                    return (Unfiltered)this.endOfData();
                }
            };
        }
        Holder current = this.ref;
        Row staticRow = this.staticRow(current, selection, false);
        return slices.size() == 1 ? this.sliceIterator(selection, slices.get(0), reversed, current, staticRow) : new SlicesIterator(this.metadata, this.partitionKey, selection, slices, reversed, current, staticRow);
    }

    private UnfilteredRowIterator sliceIterator(ColumnFilter selection, Slice slice, boolean reversed, Holder current, Row staticRow) {
        Slice.Bound start = slice.start() == Slice.Bound.BOTTOM ? null : slice.start();
        Slice.Bound end = slice.end() == Slice.Bound.TOP ? null : slice.end();
        BTreeSearchIterator rowIter = BTree.slice(current.tree, this.metadata.comparator, start, true, end, true, BTree.Dir.desc(reversed));
        return new RowAndDeletionMergeIterator(this.metadata, this.partitionKey, current.deletionInfo.getPartitionDeletion(), selection, staticRow, reversed, current.stats, rowIter, current.deletionInfo.rangeIterator(slice, reversed), true);
    }

    public long[] addAllWithSizeDelta(PartitionUpdate update, OpOrder.Group writeOp, SecondaryIndexManager.Updater indexer) {
        RowUpdater updater = new RowUpdater(this, this.allocator, writeOp, indexer);
        DeletionInfo inputDeletionInfoCopy = null;
        boolean monitorOwned = false;
        try {
            if (this.usePessimisticLocking()) {
                Locks.monitorEnterUnsafe(this);
                monitorOwned = true;
            }
            while (true) {
                DeletionInfo deletionInfo;
                Holder current;
                updater.ref = current = this.ref;
                updater.reset();
                if (update.deletionInfo().mayModify(current.deletionInfo)) {
                    if (inputDeletionInfoCopy == null) {
                        inputDeletionInfoCopy = update.deletionInfo().copy(HeapAllocator.instance);
                    }
                    deletionInfo = current.deletionInfo.mutableCopy().add(inputDeletionInfoCopy);
                    updater.allocated(deletionInfo.unsharedHeapSize() - current.deletionInfo.unsharedHeapSize());
                } else {
                    deletionInfo = current.deletionInfo;
                }
                Row newStatic = update.staticRow();
                Row staticRow = newStatic.isEmpty() ? current.staticRow : (current.staticRow.isEmpty() ? updater.apply(newStatic) : updater.apply(current.staticRow, newStatic));
                Object[] tree = BTree.update(current.tree, update.metadata().comparator, update, update.rowCount(), updater);
                EncodingStats newStats = current.stats.mergeWith(update.stats());
                if (tree != null && refUpdater.compareAndSet(this, current, new Holder(tree, deletionInfo, staticRow, newStats))) {
                    indexer.updateRowLevelIndexes();
                    updater.finish();
                    long[] lArray = new long[]{updater.dataSize, updater.colUpdateTimeDelta};
                    return lArray;
                }
                if (monitorOwned) continue;
                boolean shouldLock = this.usePessimisticLocking();
                if (!shouldLock) {
                    shouldLock = this.updateWastedAllocationTracker(updater.heapSize);
                }
                if (!shouldLock) continue;
                Locks.monitorEnterUnsafe(this);
                monitorOwned = true;
            }
        }
        finally {
            if (monitorOwned) {
                Locks.monitorExitUnsafe(this);
            }
        }
    }

    public boolean usePessimisticLocking() {
        return this.wasteTracker == Integer.MAX_VALUE;
    }

    private boolean updateWastedAllocationTracker(long wastedBytes) {
        if (wastedBytes < 0xA00000L) {
            int oldTrackerValue;
            int wastedAllocation = (int)(wastedBytes + 1024L - 1L) / 1024;
            while (Integer.MAX_VALUE != (oldTrackerValue = this.wasteTracker)) {
                int time = (int)(System.nanoTime() >>> 17);
                int delta = oldTrackerValue - time;
                if (oldTrackerValue == 0 || delta >= 0 || delta < -10240) {
                    delta = -10240;
                }
                if ((delta += wastedAllocation) >= 0) break;
                if (!wasteTrackerUpdater.compareAndSet(this, oldTrackerValue, AtomicBTreePartition.avoidReservedValues(time + delta))) continue;
                return false;
            }
        }
        wasteTrackerUpdater.set(this, Integer.MAX_VALUE);
        return true;
    }

    private static int avoidReservedValues(int wasteTracker) {
        if (wasteTracker == 0 || wasteTracker == Integer.MAX_VALUE) {
            return wasteTracker + 1;
        }
        return wasteTracker;
    }

    private static final class RowUpdater
    implements UpdateFunction<Row, Row> {
        final AtomicBTreePartition updating;
        final MemtableAllocator allocator;
        final OpOrder.Group writeOp;
        final SecondaryIndexManager.Updater indexer;
        final int nowInSec;
        Holder ref;
        Row.Builder regularBuilder;
        long dataSize;
        long heapSize;
        long colUpdateTimeDelta = Long.MAX_VALUE;
        final MemtableAllocator.DataReclaimer reclaimer;
        List<Row> inserted;

        private RowUpdater(AtomicBTreePartition updating, MemtableAllocator allocator, OpOrder.Group writeOp, SecondaryIndexManager.Updater indexer) {
            this.updating = updating;
            this.allocator = allocator;
            this.writeOp = writeOp;
            this.indexer = indexer;
            this.nowInSec = FBUtilities.nowInSeconds();
            this.reclaimer = allocator.reclaimer();
        }

        private Row.Builder builder(Clustering clustering) {
            boolean isStatic;
            boolean bl = isStatic = clustering == Clustering.STATIC_CLUSTERING;
            if (isStatic) {
                return this.allocator.rowBuilder(this.updating.metadata(), this.writeOp, true);
            }
            if (this.regularBuilder == null) {
                this.regularBuilder = this.allocator.rowBuilder(this.updating.metadata(), this.writeOp, false);
            }
            return this.regularBuilder;
        }

        public Row apply(Row insert) {
            Row data = Rows.copy(insert, this.builder(insert.clustering())).build();
            this.insertIntoIndexes(data);
            this.dataSize += (long)data.dataSize();
            this.heapSize += data.unsharedHeapSizeExcludingData();
            if (this.inserted == null) {
                this.inserted = new ArrayList<Row>();
            }
            this.inserted.add(data);
            return data;
        }

        @Override
        public Row apply(Row existing, Row update) {
            Columns mergedColumns = existing.columns().mergeTo(update.columns());
            Row.Builder builder = this.builder(existing.clustering());
            this.colUpdateTimeDelta = Math.min(this.colUpdateTimeDelta, Rows.merge(existing, update, mergedColumns, builder, this.nowInSec, this.indexer));
            Row reconciled = builder.build();
            this.dataSize += (long)(reconciled.dataSize() - existing.dataSize());
            this.heapSize += reconciled.unsharedHeapSizeExcludingData() - existing.unsharedHeapSizeExcludingData();
            if (this.inserted == null) {
                this.inserted = new ArrayList<Row>();
            }
            this.inserted.add(reconciled);
            this.discard(existing);
            return reconciled;
        }

        private void insertIntoIndexes(Row toInsert) {
            if (this.indexer == SecondaryIndexManager.nullUpdater) {
                return;
            }
            this.maybeIndexPrimaryKeyColumns(toInsert);
            Clustering clustering = toInsert.clustering();
            for (Cell cell : toInsert.cells()) {
                this.indexer.insert(clustering, cell);
            }
        }

        private void maybeIndexPrimaryKeyColumns(Row row) {
            long timestamp = row.primaryKeyLivenessInfo().timestamp();
            int ttl = row.primaryKeyLivenessInfo().ttl();
            for (Cell cell : row.cells()) {
                long cellTimestamp = cell.timestamp();
                if (!cell.isLive(this.nowInSec) || cellTimestamp <= timestamp) continue;
                timestamp = cellTimestamp;
                ttl = cell.ttl();
            }
            this.indexer.maybeIndex(row.clustering(), timestamp, ttl, row.deletion());
        }

        protected void reset() {
            this.dataSize = 0L;
            this.heapSize = 0L;
            if (this.inserted != null) {
                for (Row row : this.inserted) {
                    this.abort(row);
                }
                this.inserted.clear();
            }
            this.reclaimer.cancel();
        }

        protected void abort(Row abort) {
            this.reclaimer.reclaimImmediately(abort);
        }

        protected void discard(Row discard) {
            this.reclaimer.reclaim(discard);
        }

        @Override
        public boolean abortEarly() {
            return this.updating.ref != this.ref;
        }

        @Override
        public void allocated(long heapSize) {
            this.heapSize += heapSize;
        }

        protected void finish() {
            this.allocator.onHeap().adjust(this.heapSize, this.writeOp);
            this.reclaimer.commit();
        }
    }

    private static final class Holder {
        final DeletionInfo deletionInfo;
        final Object[] tree;
        final Row staticRow;
        final EncodingStats stats;

        Holder(Object[] tree, DeletionInfo deletionInfo, Row staticRow, EncodingStats stats) {
            this.tree = tree;
            this.deletionInfo = deletionInfo;
            this.staticRow = staticRow;
            this.stats = stats;
        }

        Holder with(DeletionInfo info) {
            return new Holder(this.tree, info, this.staticRow, this.stats);
        }
    }

    public class SlicesIterator
    extends AbstractUnfilteredRowIterator {
        private final Holder current;
        private final ColumnFilter selection;
        private final Slices slices;
        private int idx;
        private Iterator<Unfiltered> currentSlice;

        private SlicesIterator(CFMetaData metadata, DecoratedKey key, ColumnFilter selection, Slices slices, boolean isReversed, Holder holder, Row staticRow) {
            super(metadata, key, holder.deletionInfo.getPartitionDeletion(), selection.fetchedColumns(), staticRow, isReversed, holder.stats);
            this.current = holder;
            this.selection = selection;
            this.slices = slices;
        }

        protected Unfiltered computeNext() {
            while (true) {
                if (this.currentSlice == null) {
                    if (this.idx >= this.slices.size()) {
                        return (Unfiltered)this.endOfData();
                    }
                    int sliceIdx = this.isReverseOrder ? this.slices.size() - this.idx - 1 : this.idx;
                    this.currentSlice = AtomicBTreePartition.this.sliceIterator(this.selection, this.slices.get(sliceIdx), this.isReverseOrder, this.current, Rows.EMPTY_STATIC_ROW);
                    ++this.idx;
                }
                if (this.currentSlice.hasNext()) {
                    return this.currentSlice.next();
                }
                this.currentSlice = null;
            }
        }
    }
}

