/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.MutableDeletionInfo;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.partitions.ArrayBackedPartition;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.SliceableUnfilteredRowIterator;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIteratorSerializer;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class ArrayBackedCachedPartition
extends ArrayBackedPartition
implements CachedPartition {
    private final int createdAtInSec;
    private final int cachedLiveRows;
    private final int rowsWithNonExpiringCells;
    private final int nonTombstoneCellCount;
    private final int nonExpiringLiveCells;

    private ArrayBackedCachedPartition(CFMetaData metadata, DecoratedKey partitionKey, PartitionColumns columns, Row staticRow, List<Row> rows, DeletionInfo deletionInfo, EncodingStats stats, int createdAtInSec, int cachedLiveRows, int rowsWithNonExpiringCells, int nonTombstoneCellCount, int nonExpiringLiveCells) {
        super(metadata, partitionKey, columns, staticRow, rows, deletionInfo, stats);
        this.createdAtInSec = createdAtInSec;
        this.cachedLiveRows = cachedLiveRows;
        this.rowsWithNonExpiringCells = rowsWithNonExpiringCells;
        this.nonTombstoneCellCount = nonTombstoneCellCount;
        this.nonExpiringLiveCells = nonExpiringLiveCells;
    }

    public static ArrayBackedCachedPartition create(UnfilteredRowIterator iterator, int nowInSec) {
        return ArrayBackedCachedPartition.create(iterator, 16, nowInSec);
    }

    public static ArrayBackedCachedPartition create(UnfilteredRowIterator iterator, int initialRowCapacity, int nowInSec) {
        CFMetaData metadata = iterator.metadata();
        boolean reversed = iterator.isReverseOrder();
        ArrayList<Row> rows = new ArrayList<Row>(initialRowCapacity);
        MutableDeletionInfo.Builder deletionBuilder = MutableDeletionInfo.builder(iterator.partitionLevelDeletion(), metadata.comparator, reversed);
        int cachedLiveRows = 0;
        int rowsWithNonExpiringCells = 0;
        int nonTombstoneCellCount = 0;
        int nonExpiringLiveCells = 0;
        while (iterator.hasNext()) {
            Unfiltered unfiltered = (Unfiltered)iterator.next();
            if (unfiltered.kind() == Unfiltered.Kind.ROW) {
                Row row = (Row)unfiltered;
                rows.add(row);
                if (row.hasLiveData(nowInSec)) {
                    ++cachedLiveRows;
                }
                boolean hasNonExpiringCell = false;
                for (Cell cell : row.cells()) {
                    if (cell.isTombstone()) continue;
                    ++nonTombstoneCellCount;
                    if (cell.isExpiring()) continue;
                    hasNonExpiringCell = true;
                    ++nonExpiringLiveCells;
                }
                if (!hasNonExpiringCell) continue;
                ++rowsWithNonExpiringCells;
                continue;
            }
            deletionBuilder.add((RangeTombstoneMarker)unfiltered);
        }
        if (reversed) {
            Collections.reverse(rows);
        }
        return new ArrayBackedCachedPartition(metadata, iterator.partitionKey(), iterator.columns(), iterator.staticRow(), rows, deletionBuilder.build(), iterator.stats(), nowInSec, cachedLiveRows, rowsWithNonExpiringCells, nonTombstoneCellCount, nonExpiringLiveCells);
    }

    @Override
    public Row lastRow() {
        if (this.rows.isEmpty()) {
            return null;
        }
        return (Row)this.rows.get(this.rows.size() - 1);
    }

    @Override
    public int cachedLiveRows() {
        return this.cachedLiveRows;
    }

    @Override
    public int rowsWithNonExpiringCells() {
        return this.rowsWithNonExpiringCells;
    }

    @Override
    public int nonTombstoneCellCount() {
        return this.nonTombstoneCellCount;
    }

    @Override
    public int nonExpiringLiveCells() {
        return this.nonExpiringLiveCells;
    }

    static class Serializer
    implements ISerializer<CachedPartition> {
        Serializer() {
        }

        @Override
        public void serialize(CachedPartition partition, DataOutputPlus out) throws IOException {
            int version = 10;
            assert (partition instanceof ArrayBackedCachedPartition);
            ArrayBackedCachedPartition p = (ArrayBackedCachedPartition)partition;
            out.writeInt(p.createdAtInSec);
            out.writeInt(p.cachedLiveRows);
            out.writeInt(p.rowsWithNonExpiringCells);
            out.writeInt(p.nonTombstoneCellCount);
            out.writeInt(p.nonExpiringLiveCells);
            CFMetaData.serializer.serialize(partition.metadata(), out, version);
            try (SliceableUnfilteredRowIterator iter = p.sliceableUnfilteredIterator();){
                UnfilteredRowIteratorSerializer.serializer.serialize(iter, out, version, p.rowCount());
            }
        }

        @Override
        public CachedPartition deserialize(DataInputPlus in) throws IOException {
            int version = 10;
            int createdAtInSec = in.readInt();
            int cachedLiveRows = in.readInt();
            int rowsWithNonExpiringCells = in.readInt();
            int nonTombstoneCellCount = in.readInt();
            int nonExpiringLiveCells = in.readInt();
            CFMetaData metadata = CFMetaData.serializer.deserialize(in, version);
            UnfilteredRowIteratorSerializer.Header header = UnfilteredRowIteratorSerializer.serializer.deserializeHeader(in, version, metadata, SerializationHelper.Flag.LOCAL);
            assert (!header.isReversed && header.rowEstimate >= 0);
            MutableDeletionInfo.Builder deletionBuilder = MutableDeletionInfo.builder(header.partitionDeletion, metadata.comparator, false);
            ArrayList<Row> rows = new ArrayList<Row>(header.rowEstimate);
            try (UnfilteredRowIterator partition = UnfilteredRowIteratorSerializer.serializer.deserialize(in, version, metadata, SerializationHelper.Flag.LOCAL, header);){
                while (partition.hasNext()) {
                    Unfiltered unfiltered = (Unfiltered)partition.next();
                    if (unfiltered.kind() == Unfiltered.Kind.ROW) {
                        rows.add((Row)unfiltered);
                        continue;
                    }
                    deletionBuilder.add((RangeTombstoneMarker)unfiltered);
                }
            }
            return new ArrayBackedCachedPartition(metadata, header.key, header.sHeader.columns(), header.staticRow, rows, deletionBuilder.build(), header.sHeader.stats(), createdAtInSec, cachedLiveRows, rowsWithNonExpiringCells, nonTombstoneCellCount, nonExpiringLiveCells);
        }

        @Override
        public long serializedSize(CachedPartition partition) {
            int version = 10;
            assert (partition instanceof ArrayBackedCachedPartition);
            ArrayBackedCachedPartition p = (ArrayBackedCachedPartition)partition;
            try (SliceableUnfilteredRowIterator iter = p.sliceableUnfilteredIterator();){
                long l = (long)(TypeSizes.sizeof(p.createdAtInSec) + TypeSizes.sizeof(p.cachedLiveRows) + TypeSizes.sizeof(p.rowsWithNonExpiringCells) + TypeSizes.sizeof(p.nonTombstoneCellCount) + TypeSizes.sizeof(p.nonExpiringLiveCells)) + CFMetaData.serializer.serializedSize(partition.metadata(), version) + UnfilteredRowIteratorSerializer.serializer.serializedSize(iter, 10, p.rowCount());
                return l;
            }
        }
    }
}

