/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.SinglePartitionNamesCommand;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.index.AbstractSimplePerColumnSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.index.composites.CompositesIndex;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.AlteringUnfilteredRowIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositesSearcher
extends SecondaryIndexSearcher {
    private static final Logger logger = LoggerFactory.getLogger(CompositesSearcher.class);

    public CompositesSearcher(SecondaryIndexManager indexManager, Set<ColumnDefinition> columns) {
        super(indexManager, columns);
    }

    private boolean isMatchingEntry(DecoratedKey partitionKey, CompositesIndex.IndexedEntry entry, ReadCommand command) {
        return command.selects(partitionKey, entry.indexedEntryClustering);
    }

    @Override
    protected UnfilteredPartitionIterator queryDataFromIndex(AbstractSimplePerColumnSecondaryIndex secondaryIdx, final DecoratedKey indexKey, final RowIterator indexHits, final ReadCommand command, final ReadOrderGroup orderGroup) {
        assert (indexHits.staticRow() == Rows.EMPTY_STATIC_ROW);
        assert (secondaryIdx instanceof CompositesIndex);
        final CompositesIndex index = (CompositesIndex)secondaryIdx;
        return new UnfilteredPartitionIterator(){
            private CompositesIndex.IndexedEntry nextEntry;
            private UnfilteredRowIterator next;

            @Override
            public boolean isForThrift() {
                return command.isForThrift();
            }

            @Override
            public CFMetaData metadata() {
                return command.metadata();
            }

            @Override
            public boolean hasNext() {
                return this.prepareNext();
            }

            @Override
            public UnfilteredRowIterator next() {
                if (this.next == null) {
                    this.prepareNext();
                }
                UnfilteredRowIterator toReturn = this.next;
                this.next = null;
                return toReturn;
            }

            private boolean prepareNext() {
                if (this.next != null) {
                    return true;
                }
                if (this.nextEntry == null) {
                    if (!indexHits.hasNext()) {
                        return false;
                    }
                    this.nextEntry = index.decodeEntry(indexKey, (Row)indexHits.next());
                }
                BTreeSet.Builder<Clusterable> clusterings = BTreeSet.builder(CompositesSearcher.this.baseCfs.getComparator());
                ArrayList<CompositesIndex.IndexedEntry> entries = new ArrayList<CompositesIndex.IndexedEntry>();
                DecoratedKey partitionKey = ((CompositesSearcher)CompositesSearcher.this).baseCfs.partitioner.decorateKey(this.nextEntry.indexedKey);
                while (this.nextEntry != null && partitionKey.getKey().equals(this.nextEntry.indexedKey)) {
                    if (CompositesSearcher.this.isMatchingEntry(partitionKey, this.nextEntry, command)) {
                        clusterings.add(this.nextEntry.indexedEntryClustering);
                        entries.add(this.nextEntry);
                    }
                    this.nextEntry = indexHits.hasNext() ? index.decodeEntry(indexKey, (Row)indexHits.next()) : null;
                }
                if (clusterings.isEmpty()) {
                    return this.prepareNext();
                }
                ClusteringIndexNamesFilter filter = new ClusteringIndexNamesFilter(clusterings.build(), false);
                SinglePartitionNamesCommand dataCmd = new SinglePartitionNamesCommand(this.metadata(), command.nowInSec(), command.columnFilter(), command.rowFilter(), DataLimits.NONE, partitionKey, filter);
                UnfilteredRowIterator dataIter = CompositesSearcher.this.filterStaleEntries(dataCmd.queryMemtableAndDisk(CompositesSearcher.this.baseCfs, orderGroup.baseReadOpOrderGroup()), index, indexKey.getKey(), entries, orderGroup.writeOpOrderGroup(), command.nowInSec());
                if (dataIter.isEmpty()) {
                    dataIter.close();
                    return this.prepareNext();
                }
                this.next = dataIter;
                return true;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                indexHits.close();
                if (this.next != null) {
                    this.next.close();
                }
            }
        };
    }

    private UnfilteredRowIterator filterStaleEntries(UnfilteredRowIterator dataIter, final CompositesIndex index, final ByteBuffer indexValue, final List<CompositesIndex.IndexedEntry> entries, final OpOrder.Group writeOp, final int nowInSec) {
        return new AlteringUnfilteredRowIterator(dataIter){
            private int entriesIdx;

            @Override
            protected Row computeNext(Row row) {
                CompositesIndex.IndexedEntry entry = this.findEntry(row.clustering(), writeOp, nowInSec);
                if (!index.isStale(row, indexValue, nowInSec)) {
                    return row;
                }
                index.delete(entry, writeOp, nowInSec);
                return null;
            }

            private CompositesIndex.IndexedEntry findEntry(Clustering clustering, OpOrder.Group writeOp2, int nowInSec2) {
                assert (this.entriesIdx < entries.size());
                while (this.entriesIdx < entries.size()) {
                    CompositesIndex.IndexedEntry entry = (CompositesIndex.IndexedEntry)entries.get(this.entriesIdx++);
                    int cmp = this.metadata().comparator.compare(entry.indexedEntryClustering, clustering);
                    assert (cmp <= 0);
                    if (cmp == 0) {
                        return entry;
                    }
                    index.delete(entry, writeOp2, nowInSec2);
                }
                throw new AssertionError();
            }
        };
    }
}

