/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.index.composites.CompositesIndex;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;

public class CompositesIndexOnRegular
extends CompositesIndex {
    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Clustering clustering, ByteBuffer cellValue, CellPath path) {
        return cellValue;
    }

    @Override
    protected CBuilder buildIndexClusteringPrefix(ByteBuffer rowKey, ClusteringPrefix prefix, CellPath path) {
        CBuilder builder = CBuilder.create(this.getIndexComparator());
        builder.add(rowKey);
        for (int i = 0; i < prefix.size(); ++i) {
            builder.add(prefix.get(i));
        }
        return builder;
    }

    @Override
    public CompositesIndex.IndexedEntry decodeEntry(DecoratedKey indexedValue, Row indexEntry) {
        Clustering clustering = indexEntry.clustering();
        ClusteringComparator baseComparator = this.baseCfs.getComparator();
        CBuilder builder = CBuilder.create(baseComparator);
        for (int i = 0; i < baseComparator.size(); ++i) {
            builder.add(clustering.get(i + 1));
        }
        return new CompositesIndex.IndexedEntry(indexedValue, clustering, indexEntry.primaryKeyLivenessInfo().timestamp(), clustering.get(0), builder.build());
    }

    @Override
    public boolean isStale(Row data, ByteBuffer indexValue, int nowInSec) {
        Cell cell = data.getCell(this.columnDef);
        return cell == null || !cell.isLive(nowInSec) || this.columnDef.type.compare(indexValue, cell.value()) != 0;
    }
}

