/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.index.composites.CompositesIndexIncludingCollectionKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;

public class CompositesIndexOnCollectionKey
extends CompositesIndexIncludingCollectionKey {
    @Override
    protected AbstractType<?> getIndexKeyComparator() {
        return ((CollectionType)this.columnDef.type).nameComparator();
    }

    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Clustering clustering, ByteBuffer cellValue, CellPath path) {
        return path.get(0);
    }

    @Override
    public boolean supportsOperator(Operator operator) {
        return operator == Operator.CONTAINS_KEY || operator == Operator.CONTAINS && this.columnDef.type instanceof SetType;
    }

    @Override
    public boolean isStale(Row data, ByteBuffer indexValue, int nowInSec) {
        Cell cell = data.getCell(this.columnDef, CellPath.create(indexValue));
        return cell == null || !cell.isLive(nowInSec);
    }
}

