/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.composites.CompositesIndex;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.utils.concurrent.OpOrder;

public class CompositesIndexOnClusteringKey
extends CompositesIndex {
    public static void addClusteringColumns(CFMetaData.Builder indexMetadata, CFMetaData baseMetadata, ColumnDefinition columnDef) {
        ColumnDefinition def;
        int i;
        indexMetadata.addClusteringColumn("partition_key", SecondaryIndex.keyComparator);
        List<ColumnDefinition> cks = baseMetadata.clusteringColumns();
        for (i = 0; i < columnDef.position(); ++i) {
            def = cks.get(i);
            indexMetadata.addClusteringColumn(def.name, def.type);
        }
        for (i = columnDef.position() + 1; i < cks.size(); ++i) {
            def = cks.get(i);
            indexMetadata.addClusteringColumn(def.name, def.type);
        }
    }

    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Clustering clustering, ByteBuffer cellValue, CellPath path) {
        return clustering.get(this.columnDef.position());
    }

    @Override
    protected CBuilder buildIndexClusteringPrefix(ByteBuffer rowKey, ClusteringPrefix prefix, CellPath path) {
        int i;
        CBuilder builder = CBuilder.create(this.getIndexComparator());
        builder.add(rowKey);
        for (i = 0; i < Math.min(this.columnDef.position(), prefix.size()); ++i) {
            builder.add(prefix.get(i));
        }
        for (i = this.columnDef.position() + 1; i < prefix.size(); ++i) {
            builder.add(prefix.get(i));
        }
        return builder;
    }

    @Override
    public CompositesIndex.IndexedEntry decodeEntry(DecoratedKey indexedValue, Row indexEntry) {
        int i;
        int ckCount = this.baseCfs.metadata.clusteringColumns().size();
        Clustering clustering = indexEntry.clustering();
        CBuilder builder = CBuilder.create(this.baseCfs.getComparator());
        for (i = 0; i < this.columnDef.position(); ++i) {
            builder.add(clustering.get(i + 1));
        }
        builder.add(indexedValue.getKey());
        for (i = this.columnDef.position() + 1; i < ckCount; ++i) {
            builder.add(clustering.get(i));
        }
        return new CompositesIndex.IndexedEntry(indexedValue, clustering, indexEntry.primaryKeyLivenessInfo().timestamp(), clustering.get(0), builder.build());
    }

    @Override
    protected boolean indexPrimaryKeyColumn() {
        return true;
    }

    @Override
    public boolean indexes(ColumnDefinition c) {
        return false;
    }

    @Override
    public boolean isStale(Row data, ByteBuffer indexValue, int nowInSec) {
        return !data.hasLiveData(nowInSec);
    }

    @Override
    public void maybeIndex(ByteBuffer partitionKey, Clustering clustering, long timestamp, int ttl, OpOrder.Group opGroup, int nowInSec) {
        if (clustering != Clustering.STATIC_CLUSTERING && clustering.get(this.columnDef.position()) != null) {
            this.insert(partitionKey, clustering, null, LivenessInfo.create(this.indexCfs.metadata, timestamp, ttl, nowInSec), opGroup);
        }
    }

    @Override
    public void maybeDelete(ByteBuffer partitionKey, Clustering clustering, DeletionTime deletion, OpOrder.Group opGroup) {
        if (clustering.get(this.columnDef.position()) != null && !deletion.isLive()) {
            this.delete(partitionKey, clustering, null, null, deletion, opGroup);
        }
    }

    @Override
    public void delete(ByteBuffer rowKey, Clustering clustering, Cell cell, OpOrder.Group opGroup, int nowInSec) {
    }
}

