/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.index.AbstractSimplePerColumnSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.index.composites.CompositesIndexOnClusteringKey;
import org.apache.cassandra.db.index.composites.CompositesIndexOnCollectionKey;
import org.apache.cassandra.db.index.composites.CompositesIndexOnCollectionKeyAndValue;
import org.apache.cassandra.db.index.composites.CompositesIndexOnCollectionValue;
import org.apache.cassandra.db.index.composites.CompositesIndexOnPartitionKey;
import org.apache.cassandra.db.index.composites.CompositesIndexOnRegular;
import org.apache.cassandra.db.index.composites.CompositesSearcher;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.BTreeBackedRow;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.utils.concurrent.OpOrder;

public abstract class CompositesIndex
extends AbstractSimplePerColumnSecondaryIndex {
    public static CompositesIndex create(ColumnDefinition cfDef) {
        if (cfDef.type.isCollection() && cfDef.type.isMultiCell()) {
            switch (((CollectionType)cfDef.type).kind) {
                case LIST: {
                    return new CompositesIndexOnCollectionValue();
                }
                case SET: {
                    return new CompositesIndexOnCollectionKey();
                }
                case MAP: {
                    if (cfDef.hasIndexOption("index_keys")) {
                        return new CompositesIndexOnCollectionKey();
                    }
                    if (cfDef.hasIndexOption("index_keys_and_values")) {
                        return new CompositesIndexOnCollectionKeyAndValue();
                    }
                    return new CompositesIndexOnCollectionValue();
                }
            }
        }
        switch (cfDef.kind) {
            case CLUSTERING: {
                return new CompositesIndexOnClusteringKey();
            }
            case REGULAR: {
                return new CompositesIndexOnRegular();
            }
            case PARTITION_KEY: {
                return new CompositesIndexOnPartitionKey();
            }
        }
        throw new AssertionError();
    }

    public static void addIndexClusteringColumns(CFMetaData.Builder indexMetadata, CFMetaData baseMetadata, ColumnDefinition cfDef) {
        if (cfDef.type.isCollection() && cfDef.type.isMultiCell()) {
            CollectionType type = (CollectionType)cfDef.type;
            if (type.kind == CollectionType.Kind.LIST || type.kind == CollectionType.Kind.MAP && cfDef.hasIndexOption("index_values")) {
                CompositesIndexOnCollectionValue.addClusteringColumns(indexMetadata, baseMetadata, cfDef);
            } else {
                CompositesIndex.addGenericClusteringColumns(indexMetadata, baseMetadata, cfDef);
            }
        } else if (cfDef.isClusteringColumn()) {
            CompositesIndexOnClusteringKey.addClusteringColumns(indexMetadata, baseMetadata, cfDef);
        } else {
            CompositesIndex.addGenericClusteringColumns(indexMetadata, baseMetadata, cfDef);
        }
    }

    protected static void addGenericClusteringColumns(CFMetaData.Builder indexMetadata, CFMetaData baseMetadata, ColumnDefinition columnDef) {
        indexMetadata.addClusteringColumn("partition_key", SecondaryIndex.keyComparator);
        for (ColumnDefinition def : baseMetadata.clusteringColumns()) {
            indexMetadata.addClusteringColumn(def.name, def.type);
        }
    }

    public abstract IndexedEntry decodeEntry(DecoratedKey var1, Row var2);

    public abstract boolean isStale(Row var1, ByteBuffer var2, int var3);

    public void delete(IndexedEntry entry, OpOrder.Group opGroup, int nowInSec) {
        BTreeBackedRow row = BTreeBackedRow.emptyDeletedRow(entry.indexClustering, new DeletionTime(entry.timestamp, nowInSec));
        PartitionUpdate upd = PartitionUpdate.singleRowUpdate(this.indexCfs.metadata, entry.indexValue, row);
        this.indexCfs.apply(upd, SecondaryIndexManager.nullUpdater, opGroup, null);
        if (logger.isDebugEnabled()) {
            logger.debug("removed index entry for cleaned-up value {}:{}", (Object)entry.indexValue, (Object)upd);
        }
    }

    @Override
    public SecondaryIndexSearcher createSecondaryIndexSearcher(Set<ColumnDefinition> columns) {
        return new CompositesSearcher(this.baseCfs.indexManager, columns);
    }

    @Override
    public void validateOptions() throws ConfigurationException {
        ColumnDefinition columnDef = (ColumnDefinition)this.columnDefs.iterator().next();
        HashMap<String, String> options = new HashMap<String, String>(columnDef.getIndexOptions());
        options.remove("prefix_size");
        if (columnDef.type.isCollection()) {
            options.remove("index_values");
            options.remove("index_keys");
            options.remove("index_keys_and_values");
        }
        if (!options.isEmpty()) {
            throw new ConfigurationException("Unknown options provided for COMPOSITES index: " + options.keySet());
        }
    }

    public static class IndexedEntry {
        public final DecoratedKey indexValue;
        public final Clustering indexClustering;
        public final long timestamp;
        public final ByteBuffer indexedKey;
        public final Clustering indexedEntryClustering;

        public IndexedEntry(DecoratedKey indexValue, Clustering indexClustering, long timestamp, ByteBuffer indexedKey, Clustering indexedEntryClustering) {
            this.indexValue = indexValue;
            this.indexClustering = indexClustering;
            this.timestamp = timestamp;
            this.indexedKey = indexedKey;
            this.indexedEntryClustering = indexedEntryClustering;
        }
    }
}

