/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.index.AbstractSimplePerColumnSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecondaryIndexSearcher {
    private static final Logger logger = LoggerFactory.getLogger(SecondaryIndexSearcher.class);
    protected final SecondaryIndexManager indexManager;
    protected final Set<ColumnDefinition> columns;
    protected final ColumnFamilyStore baseCfs;

    public SecondaryIndexSearcher(SecondaryIndexManager indexManager, Set<ColumnDefinition> columns) {
        this.indexManager = indexManager;
        this.columns = columns;
        this.baseCfs = indexManager.baseCfs;
    }

    public SecondaryIndex highestSelectivityIndex(RowFilter filter) {
        RowFilter.Expression expr = this.highestSelectivityPredicate(filter, false);
        return expr == null ? null : this.indexManager.getIndexForColumn(expr.column());
    }

    public RowFilter.Expression primaryClause(ReadCommand command) {
        return this.highestSelectivityPredicate(command.rowFilter(), false);
    }

    public UnfilteredPartitionIterator search(ReadCommand command, ReadOrderGroup orderGroup) {
        RowFilter.Expression primary = this.highestSelectivityPredicate(command.rowFilter(), true);
        assert (primary != null);
        AbstractSimplePerColumnSecondaryIndex index = (AbstractSimplePerColumnSecondaryIndex)this.indexManager.getIndexForColumn(primary.column());
        assert (index != null && index.getIndexCfs() != null);
        if (logger.isDebugEnabled()) {
            logger.debug("Most-selective indexed predicate is {}", (Object)primary);
        }
        DecoratedKey indexKey = index.getIndexKeyFor(primary.getIndexValue());
        UnfilteredRowIterator indexIter = this.queryIndex(index, indexKey, command, orderGroup);
        try {
            return this.queryDataFromIndex(index, indexKey, UnfilteredRowIterators.filter(indexIter, command.nowInSec()), command, orderGroup);
        }
        catch (Error | RuntimeException e) {
            indexIter.close();
            throw e;
        }
    }

    private UnfilteredRowIterator queryIndex(AbstractSimplePerColumnSecondaryIndex index, DecoratedKey indexKey, ReadCommand command, ReadOrderGroup orderGroup) {
        ClusteringIndexFilter filter = this.makeIndexFilter(index, command);
        CFMetaData indexMetadata = index.getIndexCfs().metadata;
        return SinglePartitionReadCommand.create(indexMetadata, command.nowInSec(), indexKey, ColumnFilter.all(indexMetadata), filter).queryMemtableAndDisk(index.getIndexCfs(), orderGroup.indexReadOpOrderGroup());
    }

    private ClusteringIndexFilter makeIndexFilter(AbstractSimplePerColumnSecondaryIndex index, ReadCommand command) {
        if (command instanceof SinglePartitionReadCommand) {
            SinglePartitionReadCommand sprc = (SinglePartitionReadCommand)command;
            ByteBuffer pk = sprc.partitionKey().getKey();
            Object filter = sprc.clusteringIndexFilter();
            if (filter instanceof ClusteringIndexNamesFilter) {
                NavigableSet<Clustering> requested = ((ClusteringIndexNamesFilter)filter).requestedRows();
                BTreeSet.Builder<Clusterable> clusterings = BTreeSet.builder(index.getIndexComparator());
                for (Clustering c : requested) {
                    clusterings.add(index.makeIndexClustering(pk, c, (Cell)null));
                }
                return new ClusteringIndexNamesFilter(clusterings.build(), filter.isReversed());
            }
            Slices requested = ((ClusteringIndexSliceFilter)filter).requestedSlices();
            Slices.Builder builder = new Slices.Builder(index.getIndexComparator());
            for (Slice slice : requested) {
                builder.add(index.makeIndexBound(pk, slice.start()), index.makeIndexBound(pk, slice.end()));
            }
            return new ClusteringIndexSliceFilter(builder.build(), filter.isReversed());
        }
        DataRange dataRange = ((PartitionRangeReadCommand)command).dataRange();
        AbstractBounds<PartitionPosition> range = dataRange.keyRange();
        Slice slice = Slice.ALL;
        if (range.left instanceof DecoratedKey) {
            if (range.right instanceof DecoratedKey) {
                DecoratedKey startKey = (DecoratedKey)range.left;
                DecoratedKey endKey = (DecoratedKey)range.right;
                Slice.Bound start = Slice.Bound.BOTTOM;
                Slice.Bound end = Slice.Bound.TOP;
                if (!dataRange.isNamesQuery()) {
                    ClusteringIndexSliceFilter startSliceFilter = (ClusteringIndexSliceFilter)dataRange.clusteringIndexFilter(startKey);
                    ClusteringIndexSliceFilter endSliceFilter = (ClusteringIndexSliceFilter)dataRange.clusteringIndexFilter(endKey);
                    assert (!startSliceFilter.isReversed() && !endSliceFilter.isReversed());
                    Slices startSlices = startSliceFilter.requestedSlices();
                    Slices endSlices = endSliceFilter.requestedSlices();
                    if (startSlices.size() > 0) {
                        start = startSlices.get(0).start();
                    }
                    if (endSlices.size() > 0) {
                        end = endSlices.get(endSlices.size() - 1).end();
                    }
                }
                slice = Slice.make(index.makeIndexBound(startKey.getKey(), start), index.makeIndexBound(endKey.getKey(), end));
            } else {
                slice = Slice.make(index.makeIndexBound(((DecoratedKey)range.left).getKey(), Slice.Bound.BOTTOM), Slice.Bound.TOP);
            }
        }
        return new ClusteringIndexSliceFilter(Slices.with(index.getIndexComparator(), slice), false);
    }

    protected abstract UnfilteredPartitionIterator queryDataFromIndex(AbstractSimplePerColumnSecondaryIndex var1, DecoratedKey var2, RowIterator var3, ReadCommand var4, ReadOrderGroup var5);

    protected RowFilter.Expression highestSelectivityPredicate(RowFilter filter, boolean includeInTrace) {
        RowFilter.Expression best = null;
        int bestMeanCount = Integer.MAX_VALUE;
        HashMap<SecondaryIndex, Integer> candidates = new HashMap<SecondaryIndex, Integer>();
        for (RowFilter.Expression expression : filter) {
            SecondaryIndex index;
            if (!this.columns.contains(expression.column()) || (index = this.indexManager.getIndexForColumn(expression.column())) == null || index.getIndexCfs() == null || !index.supportsOperator(expression.operator())) continue;
            int columns = index.getIndexCfs().getMeanColumns();
            candidates.put(index, columns);
            if (columns >= bestMeanCount) continue;
            best = expression;
            bestMeanCount = columns;
        }
        if (includeInTrace) {
            if (best == null) {
                Tracing.trace("No applicable indexes found");
            } else if (Tracing.isTracing()) {
                Tracing.trace("Candidate index mean cardinalities are {}. Scanning with {}.", (Object)FBUtilities.toString(candidates), (Object)this.indexManager.getIndexForColumn(best.column()).getIndexName());
            }
        }
        return best;
    }

    public PartitionIterator postReconciliationProcessing(RowFilter filter, PartitionIterator result) {
        return result;
    }
}

