/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Future;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.IndexType;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.index.AbstractSimplePerColumnSecondaryIndex;
import org.apache.cassandra.db.index.PerColumnSecondaryIndex;
import org.apache.cassandra.db.index.PerRowSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexBuilder;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.lifecycle.Tracker;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecondaryIndexManager {
    private static final Logger logger = LoggerFactory.getLogger(SecondaryIndexManager.class);
    public static final Updater nullUpdater = new Updater(){

        @Override
        public void maybeIndex(Clustering clustering, long timestamp, int ttl, DeletionTime deletion) {
        }

        @Override
        public void insert(Clustering clustering, Cell cell) {
        }

        @Override
        public void update(Clustering clustering, Cell oldCell, Cell cell) {
        }

        @Override
        public void remove(Clustering clustering, Cell current) {
        }

        @Override
        public void updateRowLevelIndexes() {
        }
    };
    private final ConcurrentNavigableMap<ByteBuffer, SecondaryIndex> indexesByColumn = new ConcurrentSkipListMap<ByteBuffer, SecondaryIndex>();
    private final ConcurrentMap<Class<? extends SecondaryIndex>, SecondaryIndex> rowLevelIndexMap = new ConcurrentHashMap<Class<? extends SecondaryIndex>, SecondaryIndex>();
    private final Set<SecondaryIndex> allIndexes = Collections.newSetFromMap(new ConcurrentHashMap());
    public final ColumnFamilyStore baseCfs;

    public SecondaryIndexManager(ColumnFamilyStore baseCfs) {
        this.baseCfs = baseCfs;
    }

    public void reload() {
        Set indexedColumnNames = this.indexesByColumn.keySet();
        for (ByteBuffer indexedColumn : indexedColumnNames) {
            ColumnDefinition def = this.baseCfs.metadata.getColumnDefinition(indexedColumn);
            if (def != null && def.getIndexType() != null) continue;
            this.removeIndexedColumn(indexedColumn);
        }
        for (ColumnDefinition cdef : this.baseCfs.metadata.allColumns()) {
            if (cdef.getIndexType() == null || indexedColumnNames.contains(cdef.name.bytes)) continue;
            this.addIndexedColumn(cdef);
        }
        for (SecondaryIndex index : this.allIndexes) {
            index.reload();
        }
    }

    public Set<String> allIndexesNames() {
        HashSet<String> names = new HashSet<String>(this.allIndexes.size());
        for (SecondaryIndex index : this.allIndexes) {
            names.add(index.getIndexName());
        }
        return names;
    }

    public Set<PerColumnSecondaryIndex> perColumnIndexes() {
        HashSet<PerColumnSecondaryIndex> s = new HashSet<PerColumnSecondaryIndex>();
        for (SecondaryIndex index : this.allIndexes) {
            if (!(index instanceof PerColumnSecondaryIndex)) continue;
            s.add((PerColumnSecondaryIndex)index);
        }
        return s;
    }

    public Set<PerRowSecondaryIndex> perRowIndexes() {
        HashSet<PerRowSecondaryIndex> s = new HashSet<PerRowSecondaryIndex>();
        for (SecondaryIndex index : this.allIndexes) {
            if (!(index instanceof PerRowSecondaryIndex)) continue;
            s.add((PerRowSecondaryIndex)index);
        }
        return s;
    }

    public void maybeBuildSecondaryIndexes(Collection<SSTableReader> sstables, Set<String> idxNames) {
        if ((idxNames = this.filterByColumn(idxNames)).isEmpty()) {
            return;
        }
        logger.info(String.format("Submitting index build of %s for data in %s", idxNames, StringUtils.join(sstables, (String)", ")));
        SecondaryIndexBuilder builder = new SecondaryIndexBuilder(this.baseCfs, idxNames, new ReducingKeyIterator(sstables));
        Future<?> future = CompactionManager.instance.submitIndexBuild(builder);
        FBUtilities.waitOnFuture(future);
        this.flushIndexesBlocking();
        logger.info("Index build of {} complete", idxNames);
    }

    public boolean indexes(ColumnDefinition column) {
        for (SecondaryIndex index : this.allIndexes) {
            if (!index.indexes(column)) continue;
            return true;
        }
        return false;
    }

    private Set<SecondaryIndex> indexFor(ColumnDefinition column) {
        HashSet<SecondaryIndex> matching = null;
        for (SecondaryIndex index : this.allIndexes) {
            if (!index.indexes(column)) continue;
            if (matching == null) {
                matching = new HashSet<SecondaryIndex>();
            }
            matching.add(index);
        }
        return matching == null ? Collections.emptySet() : matching;
    }

    public void removeIndexedColumn(ByteBuffer column) {
        SecondaryIndex index = (SecondaryIndex)this.indexesByColumn.remove(column);
        if (index == null) {
            return;
        }
        if (index instanceof PerRowSecondaryIndex) {
            index.removeColumnDef(column);
            if (index.getColumnDefs().isEmpty()) {
                this.allIndexes.remove(index);
                this.rowLevelIndexMap.remove(index.getClass());
            }
        } else {
            this.allIndexes.remove(index);
        }
        index.removeIndex(column);
        SystemKeyspace.setIndexRemoved(this.baseCfs.metadata.ksName, index.getNameForSystemKeyspace(column));
    }

    public synchronized Future<?> addIndexedColumn(ColumnDefinition cdef) {
        if (this.indexesByColumn.containsKey(cdef.name.bytes)) {
            return null;
        }
        assert (cdef.getIndexType() != null);
        SecondaryIndex index = SecondaryIndex.createInstance(this.baseCfs, cdef);
        if (index instanceof PerRowSecondaryIndex) {
            SecondaryIndex currentIndex = (SecondaryIndex)this.rowLevelIndexMap.get(index.getClass());
            if (currentIndex == null) {
                this.rowLevelIndexMap.put(index.getClass(), index);
                index.init();
            } else {
                index = currentIndex;
                index.addColumnDef(cdef);
                logger.info("Creating new index : {}", (Object)cdef);
            }
        } else {
            if (cdef.getIndexType() == IndexType.CUSTOM && index instanceof AbstractSimplePerColumnSecondaryIndex) {
                throw new RuntimeException("Cannot use a subclass of AbstractSimplePerColumnSecondaryIndex as a CUSTOM index, as they assume they are CFS backed");
            }
            index.init();
        }
        this.indexesByColumn.put(cdef.name.bytes, index);
        this.allIndexes.add(index);
        if (index.isIndexBuilt(cdef.name.bytes)) {
            return null;
        }
        return index.buildIndexAsync();
    }

    public SecondaryIndex getIndexForColumn(ColumnDefinition column) {
        return (SecondaryIndex)this.indexesByColumn.get(column.name.bytes);
    }

    public void invalidate() {
        for (SecondaryIndex index : this.allIndexes) {
            index.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushIndexesBlocking() {
        ArrayList wait = new ArrayList();
        Tracker tracker = this.baseCfs.getTracker();
        synchronized (tracker) {
            for (SecondaryIndex index : this.allIndexes) {
                if (index.getIndexCfs() == null) continue;
                wait.add((Future<?>)index.getIndexCfs().forceFlush());
            }
        }
        for (SecondaryIndex index : this.allIndexes) {
            if (index.getIndexCfs() != null) continue;
            index.forceBlockingFlush();
        }
        FBUtilities.waitOnFutures(wait);
    }

    public List<String> getBuiltIndexes() {
        ArrayList<String> indexList = new ArrayList<String>();
        for (Map.Entry entry : this.indexesByColumn.entrySet()) {
            SecondaryIndex index = (SecondaryIndex)entry.getValue();
            if (!index.isIndexBuilt((ByteBuffer)entry.getKey())) continue;
            indexList.add(((SecondaryIndex)entry.getValue()).getIndexName());
        }
        return indexList;
    }

    public Set<ColumnFamilyStore> getIndexesBackedByCfs() {
        HashSet<ColumnFamilyStore> cfsList = new HashSet<ColumnFamilyStore>();
        for (SecondaryIndex index : this.allIndexes) {
            ColumnFamilyStore cfs = index.getIndexCfs();
            if (cfs == null) continue;
            cfsList.add(cfs);
        }
        return cfsList;
    }

    public Set<SecondaryIndex> getIndexesNotBackedByCfs() {
        Set<SecondaryIndex> indexes = Collections.newSetFromMap(new IdentityHashMap());
        for (SecondaryIndex index : this.allIndexes) {
            if (index.getIndexCfs() != null) continue;
            indexes.add(index);
        }
        return indexes;
    }

    public Set<SecondaryIndex> getIndexes() {
        return this.allIndexes;
    }

    public boolean hasIndexes() {
        return !this.indexesByColumn.isEmpty();
    }

    public void indexPartition(UnfilteredRowIterator partition, OpOrder.Group opGroup, Set<SecondaryIndex> allIndexes, int nowInSec) {
        Set<PerRowSecondaryIndex> perRowIndexes = this.perRowIndexes();
        Set<PerColumnSecondaryIndex> perColumnIndexes = this.perColumnIndexes();
        if (!perRowIndexes.isEmpty()) {
            HashSet appliedRowLevelIndexes = new HashSet();
            for (PerRowSecondaryIndex perRowSecondaryIndex : perRowIndexes) {
                if (!appliedRowLevelIndexes.add(perRowSecondaryIndex.getClass())) continue;
                perRowSecondaryIndex.index(partition.partitionKey().getKey(), partition);
            }
        }
        if (!perColumnIndexes.isEmpty()) {
            DecoratedKey key = partition.partitionKey();
            if (!partition.staticRow().isEmpty()) {
                for (PerColumnSecondaryIndex perColumnSecondaryIndex : perColumnIndexes) {
                    perColumnSecondaryIndex.indexRow(key, partition.staticRow(), opGroup, nowInSec);
                }
            }
            Throwable throwable = null;
            try (RowIterator filtered = UnfilteredRowIterators.filter(partition, nowInSec);){
                while (filtered.hasNext()) {
                    Row row = (Row)filtered.next();
                    for (PerColumnSecondaryIndex index : perColumnIndexes) {
                        index.indexRow(key, row, opGroup, nowInSec);
                    }
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
    }

    public void deleteFromIndexes(UnfilteredRowIterator partition, OpOrder.Group opGroup, int nowInSec) {
        ByteBuffer key = partition.partitionKey().getKey();
        for (PerRowSecondaryIndex index : this.perRowIndexes()) {
            index.delete(key, opGroup);
        }
        Set<PerColumnSecondaryIndex> indexes = this.perColumnIndexes();
        while (partition.hasNext()) {
            Unfiltered unfiltered = (Unfiltered)partition.next();
            if (unfiltered.kind() != Unfiltered.Kind.ROW) continue;
            Row row = (Row)unfiltered;
            Clustering clustering = row.clustering();
            if (!row.deletion().isLive()) {
                for (PerColumnSecondaryIndex index : indexes) {
                    index.maybeDelete(key, clustering, row.deletion(), opGroup);
                }
            }
            for (Cell cell : row.cells()) {
                for (PerColumnSecondaryIndex index : indexes) {
                    if (!index.indexes(cell.column())) continue;
                    index.deleteForCleanup(key, clustering, cell, opGroup, nowInSec);
                }
            }
        }
    }

    public Updater updaterFor(PartitionUpdate update, OpOrder.Group opGroup, int nowInSec) {
        return this.indexesByColumn.isEmpty() && this.rowLevelIndexMap.isEmpty() ? nullUpdater : new StandardUpdater(update, opGroup, nowInSec);
    }

    public Updater gcUpdaterFor(DecoratedKey key, int nowInSec) {
        return new GCUpdater(key, nowInSec);
    }

    public List<SecondaryIndexSearcher> getIndexSearchersFor(ReadCommand command) {
        HashMap<String, HashSet<ColumnDefinition>> groupByIndexType = new HashMap<String, HashSet<ColumnDefinition>>();
        for (RowFilter.Expression e : command.rowFilter()) {
            SecondaryIndex index = this.getIndexForColumn(e.column());
            if (index == null || !index.supportsOperator(e.operator())) continue;
            HashSet<ColumnDefinition> columns = (HashSet<ColumnDefinition>)groupByIndexType.get(index.indexTypeForGrouping());
            if (columns == null) {
                columns = new HashSet<ColumnDefinition>();
                groupByIndexType.put(index.indexTypeForGrouping(), columns);
            }
            columns.add(e.column());
        }
        ArrayList<SecondaryIndexSearcher> indexSearchers = new ArrayList<SecondaryIndexSearcher>(groupByIndexType.size());
        for (Set column : groupByIndexType.values()) {
            indexSearchers.add(this.getIndexForColumn((ColumnDefinition)column.iterator().next()).createSecondaryIndexSearcher(column));
        }
        return indexSearchers;
    }

    public SecondaryIndexSearcher getBestIndexSearcherFor(ReadCommand command) {
        List<SecondaryIndexSearcher> indexSearchers = this.getIndexSearchersFor(command);
        if (indexSearchers.isEmpty()) {
            return null;
        }
        SecondaryIndexSearcher mostSelective = null;
        long bestEstimate = Long.MAX_VALUE;
        for (SecondaryIndexSearcher searcher : indexSearchers) {
            SecondaryIndex highestSelectivityIndex = searcher.highestSelectivityIndex(command.rowFilter());
            long estimate = highestSelectivityIndex.estimateResultRows();
            if (estimate > bestEstimate) continue;
            bestEstimate = estimate;
            mostSelective = searcher;
        }
        return mostSelective;
    }

    public void validateFilter(RowFilter filter) throws InvalidRequestException {
        for (RowFilter.Expression expression : filter) {
            SecondaryIndex index = this.getIndexForColumn(expression.column());
            if (index == null || !index.supportsOperator(expression.operator())) continue;
            expression.validateForIndexing();
        }
    }

    public Set<SecondaryIndex> getIndexesByNames(Set<String> idxNames) {
        HashSet<SecondaryIndex> result = new HashSet<SecondaryIndex>();
        for (SecondaryIndex index : this.allIndexes) {
            if (!idxNames.contains(index.getIndexName())) continue;
            result.add(index);
        }
        return result;
    }

    public SecondaryIndex getIndexByName(String idxName) {
        for (SecondaryIndex index : this.allIndexes) {
            if (!idxName.equals(index.getIndexName())) continue;
            return index;
        }
        return null;
    }

    public void setIndexBuilt(Set<String> idxNames) {
        for (SecondaryIndex index : this.getIndexesByNames(idxNames)) {
            index.setIndexBuilt();
        }
    }

    public void setIndexRemoved(Set<String> idxNames) {
        for (SecondaryIndex index : this.getIndexesByNames(idxNames)) {
            index.setIndexRemoved();
        }
    }

    public void validate(DecoratedKey partitionKey) throws InvalidRequestException {
        for (SecondaryIndex secondaryIndex : this.perColumnIndexes()) {
            secondaryIndex.validate(partitionKey);
        }
    }

    public void validate(Clustering clustering) throws InvalidRequestException {
        for (SecondaryIndex secondaryIndex : this.perColumnIndexes()) {
            secondaryIndex.validate(clustering);
        }
    }

    public void validate(ColumnDefinition column, ByteBuffer value, CellPath path) throws InvalidRequestException {
        for (SecondaryIndex index : this.indexFor(column)) {
            index.validate(value, path);
        }
    }

    static boolean shouldCleanupOldValue(Cell oldCell, Cell newCell) {
        return !oldCell.value().equals(newCell.value()) || oldCell.timestamp() != newCell.timestamp();
    }

    private Set<String> filterByColumn(Set<String> idxNames) {
        Set<SecondaryIndex> indexes = this.getIndexesByNames(idxNames);
        HashSet<String> filtered = new HashSet<String>(idxNames.size());
        block0: for (SecondaryIndex candidate : indexes) {
            for (ColumnDefinition column : this.baseCfs.metadata.allColumns()) {
                if (!candidate.indexes(column)) continue;
                filtered.add(candidate.getIndexName());
                continue block0;
            }
        }
        return filtered;
    }

    private final class StandardUpdater
    implements Updater {
        private final PartitionUpdate update;
        private final OpOrder.Group opGroup;
        private final int nowInSec;

        public StandardUpdater(PartitionUpdate update, OpOrder.Group opGroup, int nowInSec) {
            this.update = update;
            this.opGroup = opGroup;
            this.nowInSec = nowInSec;
        }

        @Override
        public void maybeIndex(Clustering clustering, long timestamp, int ttl, DeletionTime deletion) {
            for (PerColumnSecondaryIndex index : SecondaryIndexManager.this.perColumnIndexes()) {
                if (timestamp != Long.MIN_VALUE) {
                    index.maybeIndex(this.update.partitionKey().getKey(), clustering, timestamp, ttl, this.opGroup, this.nowInSec);
                }
                if (deletion.isLive()) continue;
                index.maybeDelete(this.update.partitionKey().getKey(), clustering, deletion, this.opGroup);
            }
        }

        @Override
        public void insert(Clustering clustering, Cell cell) {
            if (!cell.isLive(this.nowInSec)) {
                return;
            }
            for (SecondaryIndex index : SecondaryIndexManager.this.indexFor(cell.column())) {
                if (!(index instanceof PerColumnSecondaryIndex)) continue;
                ((PerColumnSecondaryIndex)index).insert(this.update.partitionKey().getKey(), clustering, cell, this.opGroup);
            }
        }

        @Override
        public void update(Clustering clustering, Cell oldCell, Cell cell) {
            if (oldCell.equals(cell)) {
                return;
            }
            for (SecondaryIndex index : SecondaryIndexManager.this.indexFor(cell.column())) {
                if (!(index instanceof PerColumnSecondaryIndex)) continue;
                if (cell.isLive(this.nowInSec)) {
                    ((PerColumnSecondaryIndex)index).update(this.update.partitionKey().getKey(), clustering, oldCell, cell, this.opGroup, this.nowInSec);
                    continue;
                }
                if (!SecondaryIndexManager.shouldCleanupOldValue(oldCell, cell)) continue;
                ((PerColumnSecondaryIndex)index).delete(this.update.partitionKey().getKey(), clustering, oldCell, this.opGroup, this.nowInSec);
            }
        }

        @Override
        public void remove(Clustering clustering, Cell cell) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void updateRowLevelIndexes() {
            for (SecondaryIndex index : SecondaryIndexManager.this.rowLevelIndexMap.values()) {
                ((PerRowSecondaryIndex)index).index(this.update.partitionKey().getKey(), this.update.unfilteredIterator());
            }
        }
    }

    private final class GCUpdater
    implements Updater {
        private final DecoratedKey key;
        private final int nowInSec;

        public GCUpdater(DecoratedKey key, int nowInSec) {
            this.key = key;
            this.nowInSec = nowInSec;
        }

        @Override
        public void maybeIndex(Clustering clustering, long timestamp, int ttl, DeletionTime deletion) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insert(Clustering clustering, Cell cell) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void update(Clustering clustering, Cell oldCell, Cell newCell) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(Clustering clustering, Cell cell) {
            for (SecondaryIndex index : SecondaryIndexManager.this.indexFor(cell.column())) {
                if (!(index instanceof PerColumnSecondaryIndex)) continue;
                Keyspace cfr_ignored_0 = SecondaryIndexManager.this.baseCfs.keyspace;
                OpOrder.Group opGroup = Keyspace.writeOrder.start();
                Throwable throwable = null;
                try {
                    ((PerColumnSecondaryIndex)index).delete(this.key.getKey(), clustering, cell, opGroup, this.nowInSec);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (opGroup == null) continue;
                    if (throwable != null) {
                        try {
                            opGroup.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    opGroup.close();
                }
            }
        }

        @Override
        public void updateRowLevelIndexes() {
            for (SecondaryIndex index : SecondaryIndexManager.this.rowLevelIndexMap.values()) {
                ((PerRowSecondaryIndex)index).index(this.key.getKey(), null);
            }
        }
    }

    public static interface Updater {
        public void maybeIndex(Clustering var1, long var2, int var4, DeletionTime var5);

        public void insert(Clustering var1, Cell var2);

        public void update(Clustering var1, Cell var2, Cell var3);

        public void remove(Clustering var1, Cell var2);

        public void updateRowLevelIndexes();
    }
}

