/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.IOException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public abstract class AbstractClusteringIndexFilter
implements ClusteringIndexFilter {
    static final ClusteringIndexFilter.Serializer serializer = new FilterSerializer();
    protected final boolean reversed;

    abstract Kind kind();

    protected AbstractClusteringIndexFilter(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    protected abstract void serializeInternal(DataOutputPlus var1, int var2) throws IOException;

    protected abstract long serializedSizeInternal(int var1);

    protected void appendOrderByToCQLString(CFMetaData metadata, StringBuilder sb) {
        if (this.reversed) {
            sb.append(" ORDER BY (");
            int i = 0;
            for (ColumnDefinition column : metadata.clusteringColumns()) {
                sb.append(i++ == 0 ? "" : ", ").append(column.name).append(column.type instanceof ReversedType ? " ASC" : " DESC");
            }
            sb.append(')');
        }
    }

    protected static abstract class InternalDeserializer {
        protected InternalDeserializer() {
        }

        public abstract ClusteringIndexFilter deserialize(DataInputPlus var1, int var2, CFMetaData var3, boolean var4) throws IOException;
    }

    private static class FilterSerializer
    implements ClusteringIndexFilter.Serializer {
        private FilterSerializer() {
        }

        @Override
        public void serialize(ClusteringIndexFilter pfilter, DataOutputPlus out, int version) throws IOException {
            AbstractClusteringIndexFilter filter = (AbstractClusteringIndexFilter)pfilter;
            out.writeByte(filter.kind().ordinal());
            out.writeBoolean(filter.isReversed());
            filter.serializeInternal(out, version);
        }

        @Override
        public ClusteringIndexFilter deserialize(DataInputPlus in, int version, CFMetaData metadata) throws IOException {
            Kind kind = Kind.values()[in.readUnsignedByte()];
            boolean reversed = in.readBoolean();
            return kind.deserializer.deserialize(in, version, metadata, reversed);
        }

        @Override
        public long serializedSize(ClusteringIndexFilter pfilter, int version) {
            AbstractClusteringIndexFilter filter = (AbstractClusteringIndexFilter)pfilter;
            return (long)(1 + TypeSizes.sizeof(filter.isReversed())) + filter.serializedSizeInternal(version);
        }
    }

    protected static enum Kind {
        SLICE(ClusteringIndexSliceFilter.deserializer),
        NAMES(ClusteringIndexNamesFilter.deserializer);

        private final InternalDeserializer deserializer;

        private Kind(InternalDeserializer deserializer) {
            this.deserializer = deserializer;
        }
    }
}

