/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.writers;

import java.util.List;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.SSTableRewriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.concurrent.Transactional;

public abstract class CompactionAwareWriter
extends Transactional.AbstractTransactional
implements Transactional {
    protected final ColumnFamilyStore cfs;
    protected final Set<SSTableReader> nonExpiredSSTables;
    protected final long estimatedTotalKeys;
    protected final long maxAge;
    protected final long minRepairedAt;
    protected final LifecycleTransaction txn;
    protected final SSTableRewriter sstableWriter;

    public CompactionAwareWriter(ColumnFamilyStore cfs, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, boolean offline) {
        this.cfs = cfs;
        this.nonExpiredSSTables = nonExpiredSSTables;
        this.estimatedTotalKeys = SSTableReader.getApproximateKeyCount(nonExpiredSSTables);
        this.maxAge = CompactionTask.getMaxDataAge(nonExpiredSSTables);
        this.minRepairedAt = CompactionTask.getMinRepairedAt(nonExpiredSSTables);
        this.txn = txn;
        this.sstableWriter = new SSTableRewriter(cfs, txn, this.maxAge, offline).keepOriginals(offline);
    }

    public abstract boolean append(UnfilteredRowIterator var1);

    @Override
    protected Throwable doAbort(Throwable accumulate) {
        return this.sstableWriter.abort(accumulate);
    }

    @Override
    protected Throwable doCommit(Throwable accumulate) {
        return this.sstableWriter.commit(accumulate);
    }

    @Override
    protected void doPrepare() {
        this.sstableWriter.prepareToCommit();
    }

    @Override
    public List<SSTableReader> finish() {
        super.finish();
        return this.sstableWriter.finished();
    }

    public long estimatedKeys() {
        return this.estimatedTotalKeys;
    }

    public Directories getDirectories() {
        return this.cfs.directories;
    }

    public Directories.DataDirectory getWriteDirectory(long expectedWriteSize) {
        Directories.DataDirectory directory = this.getDirectories().getWriteableLocation(expectedWriteSize);
        if (directory == null) {
            throw new RuntimeException("Insufficient disk space to write " + expectedWriteSize + " bytes");
        }
        return directory;
    }
}

