/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;

public abstract class ReadResponse {
    public static final IVersionedSerializer<ReadResponse> serializer = new Serializer();
    public static final IVersionedSerializer<ReadResponse> legacyRangeSliceReplySerializer = new LegacyRangeSliceReplySerializer();
    private final CFMetaData metadata;

    protected ReadResponse(CFMetaData metadata) {
        this.metadata = metadata;
    }

    public static ReadResponse createDataResponse(UnfilteredPartitionIterator data) {
        return new DataResponse(data);
    }

    public static ReadResponse createDigestResponse(UnfilteredPartitionIterator data) {
        return new DigestResponse(ReadResponse.makeDigest(data));
    }

    public abstract UnfilteredPartitionIterator makeIterator(CFMetaData var1);

    public abstract ByteBuffer digest(CFMetaData var1);

    public abstract boolean isDigestQuery();

    protected static ByteBuffer makeDigest(UnfilteredPartitionIterator iterator) {
        MessageDigest digest = FBUtilities.threadLocalMD5Digest();
        UnfilteredPartitionIterators.digest(iterator, digest);
        return ByteBuffer.wrap(digest.digest());
    }

    private static class LegacyRangeSliceReplySerializer
    implements IVersionedSerializer<ReadResponse> {
        private LegacyRangeSliceReplySerializer() {
        }

        @Override
        public void serialize(ReadResponse response, DataOutputPlus out, int version) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReadResponse deserialize(DataInputPlus in, int version) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long serializedSize(ReadResponse response, int version) {
            throw new UnsupportedOperationException();
        }
    }

    private static class Serializer
    implements IVersionedSerializer<ReadResponse> {
        private Serializer() {
        }

        @Override
        public void serialize(ReadResponse response, DataOutputPlus out, int version) throws IOException {
            if (version < 10) {
                throw new UnsupportedOperationException();
            }
            boolean isDigest = response.isDigestQuery();
            ByteBufferUtil.writeWithVIntLength(isDigest ? response.digest(response.metadata) : ByteBufferUtil.EMPTY_BYTE_BUFFER, out);
            if (!isDigest) {
                assert (version == 10);
                ByteBuffer data = ((DataResponse)response).data;
                ByteBufferUtil.writeWithVIntLength(data, out);
            }
        }

        @Override
        public ReadResponse deserialize(DataInputPlus in, int version) throws IOException {
            if (version < 10) {
                throw new UnsupportedOperationException();
            }
            ByteBuffer digest = ByteBufferUtil.readWithVIntLength(in);
            if (digest.hasRemaining()) {
                return new DigestResponse(digest);
            }
            assert (version == 10);
            ByteBuffer data = ByteBufferUtil.readWithVIntLength(in);
            return new DataResponse(data);
        }

        @Override
        public long serializedSize(ReadResponse response, int version) {
            if (version < 10) {
                throw new UnsupportedOperationException();
            }
            boolean isDigest = response.isDigestQuery();
            long size = ByteBufferUtil.serializedSizeWithVIntLength(isDigest ? response.digest(response.metadata) : ByteBufferUtil.EMPTY_BYTE_BUFFER);
            if (!isDigest) {
                assert (version == 10);
                ByteBuffer data = ((DataResponse)response).data;
                size += (long)ByteBufferUtil.serializedSizeWithVIntLength(data);
            }
            return size;
        }
    }

    private static class DataResponse
    extends ReadResponse {
        private final ByteBuffer data;
        private final SerializationHelper.Flag flag;

        private DataResponse(ByteBuffer data) {
            super(null);
            this.data = data;
            this.flag = SerializationHelper.Flag.FROM_REMOTE;
        }

        private DataResponse(UnfilteredPartitionIterator iter) {
            super(iter.metadata());
            try (DataOutputBuffer buffer = new DataOutputBuffer();){
                UnfilteredPartitionIterators.serializerForIntraNode().serialize(iter, buffer, 10);
                this.data = buffer.buffer();
                this.flag = SerializationHelper.Flag.LOCAL;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public UnfilteredPartitionIterator makeIterator(CFMetaData metadata) {
            try {
                DataInputBuffer in = new DataInputBuffer(this.data, true);
                return UnfilteredPartitionIterators.serializerForIntraNode().deserialize(in, 10, metadata, this.flag);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public ByteBuffer digest(CFMetaData metadata) {
            try (UnfilteredPartitionIterator iterator = this.makeIterator(metadata);){
                ByteBuffer byteBuffer = DataResponse.makeDigest(iterator);
                return byteBuffer;
            }
        }

        @Override
        public boolean isDigestQuery() {
            return false;
        }
    }

    private static class DigestResponse
    extends ReadResponse {
        private final ByteBuffer digest;

        private DigestResponse(ByteBuffer digest) {
            super(null);
            assert (digest.hasRemaining());
            this.digest = digest;
        }

        @Override
        public UnfilteredPartitionIterator makeIterator(CFMetaData metadata) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer digest(CFMetaData metadata) {
            return this.digest;
        }

        @Override
        public boolean isDigestQuery() {
            return true;
        }
    }
}

