/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.tracing.Tracing;

public class ReadCommandVerbHandler
implements IVerbHandler<ReadCommand> {
    @Override
    public void doVerb(MessageIn<ReadCommand> message, int id) {
        ReadResponse response;
        if (StorageService.instance.isBootstrapMode()) {
            throw new RuntimeException("Cannot service reads while bootstrapping!");
        }
        ReadCommand command = (ReadCommand)message.payload;
        try (ReadOrderGroup opGroup = command.startOrderGroup();
             UnfilteredPartitionIterator iterator = command.executeLocally(opGroup);){
            response = command.createResponse(iterator);
        }
        MessageOut<ReadResponse> reply = new MessageOut<ReadResponse>(MessagingService.Verb.REQUEST_RESPONSE, response, ReadResponse.serializer);
        Tracing.trace("Enqueuing response to {}", (Object)message.from);
        MessagingService.instance().sendReply(reply, id, message.from);
    }
}

