/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.filter.TombstoneOverwhelmingException;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PurgingPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.partitions.WrappingUnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.AlteringUnfilteredRowIterator;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReadCommand
implements ReadQuery {
    protected static final Logger logger = LoggerFactory.getLogger(ReadCommand.class);
    public static final IVersionedSerializer<ReadCommand> serializer = new Serializer();
    private final Kind kind;
    private final CFMetaData metadata;
    private final int nowInSec;
    private final ColumnFilter columnFilter;
    private final RowFilter rowFilter;
    private final DataLimits limits;
    private boolean isDigestQuery;
    private final boolean isForThrift;

    protected ReadCommand(Kind kind, boolean isDigestQuery, boolean isForThrift, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits) {
        this.kind = kind;
        this.isDigestQuery = isDigestQuery;
        this.isForThrift = isForThrift;
        this.metadata = metadata;
        this.nowInSec = nowInSec;
        this.columnFilter = columnFilter;
        this.rowFilter = rowFilter;
        this.limits = limits;
    }

    protected abstract void serializeSelection(DataOutputPlus var1, int var2) throws IOException;

    protected abstract long selectionSerializedSize(int var1);

    public CFMetaData metadata() {
        return this.metadata;
    }

    public int nowInSec() {
        return this.nowInSec;
    }

    public abstract long getTimeout();

    public ColumnFilter columnFilter() {
        return this.columnFilter;
    }

    public RowFilter rowFilter() {
        return this.rowFilter;
    }

    @Override
    public DataLimits limits() {
        return this.limits;
    }

    public boolean isDigestQuery() {
        return this.isDigestQuery;
    }

    public ReadCommand setIsDigestQuery(boolean isDigestQuery) {
        this.isDigestQuery = isDigestQuery;
        return this;
    }

    public boolean isForThrift() {
        return this.isForThrift;
    }

    public abstract ClusteringIndexFilter clusteringIndexFilter(DecoratedKey var1);

    public abstract ReadCommand copy();

    public abstract boolean selects(DecoratedKey var1, Clustering var2);

    protected abstract UnfilteredPartitionIterator queryStorage(ColumnFamilyStore var1, ReadOrderGroup var2);

    public ReadResponse createResponse(UnfilteredPartitionIterator iterator) {
        return this.isDigestQuery() ? ReadResponse.createDigestResponse(iterator) : ReadResponse.createDataResponse(iterator);
    }

    protected SecondaryIndexSearcher getIndexSearcher(ColumnFamilyStore cfs) {
        return cfs.indexManager.getBestIndexSearcherFor(this);
    }

    public UnfilteredPartitionIterator executeLocally(ReadOrderGroup orderGroup) {
        long startTimeNanos = System.nanoTime();
        ColumnFamilyStore cfs = Keyspace.openAndGetStore(this.metadata());
        SecondaryIndexSearcher searcher = this.getIndexSearcher(cfs);
        UnfilteredPartitionIterator resultIterator = searcher == null ? this.queryStorage(cfs, orderGroup) : searcher.search(this, orderGroup);
        try {
            resultIterator = this.withMetricsRecording(this.withoutPurgeableTombstones(resultIterator, cfs), cfs.metric, startTimeNanos);
            RowFilter updatedFilter = searcher == null ? this.rowFilter() : this.rowFilter().without(searcher.primaryClause(this));
            return this.limits().filter(this.rowFilter().filter(resultIterator, this.nowInSec()), this.nowInSec());
        }
        catch (Error | RuntimeException e) {
            resultIterator.close();
            throw e;
        }
    }

    protected abstract void recordLatency(TableMetrics var1, long var2);

    @Override
    public PartitionIterator executeInternal(ReadOrderGroup orderGroup) {
        return UnfilteredPartitionIterators.filter(this.executeLocally(orderGroup), this.nowInSec());
    }

    @Override
    public ReadOrderGroup startOrderGroup() {
        return ReadOrderGroup.forCommand(this);
    }

    private UnfilteredPartitionIterator withMetricsRecording(UnfilteredPartitionIterator iter, final TableMetrics metric, final long startTimeNanos) {
        return new WrappingUnfilteredPartitionIterator(iter){
            private final int failureThreshold;
            private final int warningThreshold;
            private final boolean respectTombstoneThresholds;
            private int liveRows;
            private int tombstones;
            private DecoratedKey currentKey;
            {
                super(wrapped);
                this.failureThreshold = DatabaseDescriptor.getTombstoneFailureThreshold();
                this.warningThreshold = DatabaseDescriptor.getTombstoneWarnThreshold();
                this.respectTombstoneThresholds = !Schema.isSystemKeyspace(ReadCommand.this.metadata().ksName);
                this.liveRows = 0;
                this.tombstones = 0;
            }

            @Override
            public UnfilteredRowIterator computeNext(UnfilteredRowIterator iter) {
                this.currentKey = iter.partitionKey();
                return new AlteringUnfilteredRowIterator(iter){

                    @Override
                    protected Row computeNextStatic(Row row) {
                        return this.computeNext(row);
                    }

                    @Override
                    protected Row computeNext(Row row) {
                        if (row.hasLiveData(ReadCommand.this.nowInSec())) {
                            ++liveRows;
                        }
                        for (Cell cell : row.cells()) {
                            if (cell.isLive(ReadCommand.this.nowInSec())) continue;
                            this.countTombstone(row.clustering());
                        }
                        return row;
                    }

                    @Override
                    protected RangeTombstoneMarker computeNext(RangeTombstoneMarker marker) {
                        this.countTombstone(marker.clustering());
                        return marker;
                    }

                    private void countTombstone(ClusteringPrefix clustering) {
                        ++tombstones;
                        if (tombstones > failureThreshold && respectTombstoneThresholds) {
                            String query = ReadCommand.this.toCQLString();
                            Tracing.trace("Scanned over {} tombstones for query {}; query aborted (see tombstone_failure_threshold)", (Object)failureThreshold, (Object)query);
                            throw new TombstoneOverwhelmingException(tombstones, query, ReadCommand.this.metadata(), currentKey, clustering);
                        }
                    }
                };
            }

            @Override
            public void close() {
                boolean warnTombstones;
                try {
                    super.close();
                    ReadCommand.this.recordLatency(metric, System.nanoTime() - startTimeNanos);
                    metric.tombstoneScannedHistogram.update(this.tombstones);
                    metric.liveScannedHistogram.update(this.liveRows);
                    boolean bl = warnTombstones = this.tombstones > this.warningThreshold && this.respectTombstoneThresholds;
                }
                catch (Throwable throwable) {
                    boolean warnTombstones2;
                    ReadCommand.this.recordLatency(metric, System.nanoTime() - startTimeNanos);
                    metric.tombstoneScannedHistogram.update(this.tombstones);
                    metric.liveScannedHistogram.update(this.liveRows);
                    boolean bl = warnTombstones2 = this.tombstones > this.warningThreshold && this.respectTombstoneThresholds;
                    if (warnTombstones2) {
                        String msg = String.format("Read %d live rows and %d tombstone cells for query %1.512s (see tombstone_warn_threshold)", this.liveRows, this.tombstones, ReadCommand.this.toCQLString());
                        ClientWarn.warn(msg);
                        logger.warn(msg);
                    }
                    Tracing.trace("Read {} live and {} tombstone cells{}", this.liveRows, this.tombstones, warnTombstones2 ? " (see tombstone_warn_threshold)" : "");
                    throw throwable;
                }
                if (warnTombstones) {
                    String msg = String.format("Read %d live rows and %d tombstone cells for query %1.512s (see tombstone_warn_threshold)", this.liveRows, this.tombstones, ReadCommand.this.toCQLString());
                    ClientWarn.warn(msg);
                    logger.warn(msg);
                }
                Tracing.trace("Read {} live and {} tombstone cells{}", this.liveRows, this.tombstones, warnTombstones ? " (see tombstone_warn_threshold)" : "");
            }
        };
    }

    public MessageOut<ReadCommand> createMessage() {
        return new MessageOut<ReadCommand>(MessagingService.Verb.READ, this, serializer);
    }

    protected abstract void appendCQLWhereClause(StringBuilder var1);

    protected UnfilteredPartitionIterator withoutPurgeableTombstones(UnfilteredPartitionIterator iterator, ColumnFamilyStore cfs) {
        return new PurgingPartitionIterator(iterator, cfs.gcBefore(this.nowInSec())){

            @Override
            protected long getMaxPurgeableTimestamp() {
                return Long.MAX_VALUE;
            }
        };
    }

    public String toCQLString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append(this.columnFilter());
        sb.append(" FROM ").append(this.metadata().ksName).append(".").append(this.metadata.cfName);
        this.appendCQLWhereClause(sb);
        if (this.limits() != DataLimits.NONE) {
            sb.append(" ").append(this.limits());
        }
        return sb.toString();
    }

    private static class Serializer
    implements IVersionedSerializer<ReadCommand> {
        private Serializer() {
        }

        private static int digestFlag(boolean isDigest) {
            return isDigest ? 1 : 0;
        }

        private static boolean isDigest(int flags) {
            return (flags & 1) != 0;
        }

        private static int thriftFlag(boolean isForThrift) {
            return isForThrift ? 2 : 0;
        }

        private static boolean isForThrift(int flags) {
            return (flags & 2) != 0;
        }

        @Override
        public void serialize(ReadCommand command, DataOutputPlus out, int version) throws IOException {
            if (version < 10) {
                throw new UnsupportedOperationException();
            }
            out.writeByte(command.kind.ordinal());
            out.writeByte(Serializer.digestFlag(command.isDigestQuery()) | Serializer.thriftFlag(command.isForThrift()));
            CFMetaData.serializer.serialize(command.metadata(), out, version);
            out.writeInt(command.nowInSec());
            ColumnFilter.serializer.serialize(command.columnFilter(), out, version);
            RowFilter.serializer.serialize(command.rowFilter(), out, version);
            DataLimits.serializer.serialize(command.limits(), out, version);
            command.serializeSelection(out, version);
        }

        @Override
        public ReadCommand deserialize(DataInputPlus in, int version) throws IOException {
            if (version < 10) {
                throw new UnsupportedOperationException();
            }
            Kind kind = Kind.values()[in.readByte()];
            byte flags = in.readByte();
            boolean isDigest = Serializer.isDigest(flags);
            boolean isForThrift = Serializer.isForThrift(flags);
            CFMetaData metadata = CFMetaData.serializer.deserialize(in, version);
            int nowInSec = in.readInt();
            ColumnFilter columnFilter = ColumnFilter.serializer.deserialize(in, version, metadata);
            RowFilter rowFilter = RowFilter.serializer.deserialize(in, version, metadata);
            DataLimits limits = DataLimits.serializer.deserialize(in, version);
            return kind.selectionDeserializer.deserialize(in, version, isDigest, isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits);
        }

        @Override
        public long serializedSize(ReadCommand command, int version) {
            if (version < 10) {
                throw new UnsupportedOperationException();
            }
            return 2L + CFMetaData.serializer.serializedSize(command.metadata(), version) + (long)TypeSizes.sizeof(command.nowInSec()) + ColumnFilter.serializer.serializedSize(command.columnFilter(), version) + RowFilter.serializer.serializedSize(command.rowFilter(), version) + DataLimits.serializer.serializedSize(command.limits(), version) + command.selectionSerializedSize(version);
        }
    }

    protected static enum Kind {
        SINGLE_PARTITION(SinglePartitionReadCommand.selectionDeserializer),
        PARTITION_RANGE(PartitionRangeReadCommand.selectionDeserializer);

        private SelectionDeserializer selectionDeserializer;

        private Kind(SelectionDeserializer selectionDeserializer) {
            this.selectionDeserializer = selectionDeserializer;
        }
    }

    protected static abstract class SelectionDeserializer {
        protected SelectionDeserializer() {
        }

        public abstract ReadCommand deserialize(DataInputPlus var1, int var2, boolean var3, boolean var4, CFMetaData var5, int var6, ColumnFilter var7, RowFilter var8, DataLimits var9) throws IOException;
    }
}

