/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.UUID;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.MaterializedViewDefinition;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnCondition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.SingleColumnRelation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.SingleColumnRestriction;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.CQL3CasRequest;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.MultiCBuilder;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.partitions.FilteredPartition;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.triggers.TriggerExecutor;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModificationStatement
implements CQLStatement {
    protected static final Logger logger = LoggerFactory.getLogger(ModificationStatement.class);
    private static final ColumnIdentifier CAS_RESULT_COLUMN = new ColumnIdentifier("[applied]", false);
    public final StatementType type;
    private final int boundTerms;
    public final CFMetaData cfm;
    public final Attributes attrs;
    protected final Map<ColumnIdentifier, Restriction> processedKeys = new HashMap<ColumnIdentifier, Restriction>();
    private final List<Operation> regularOperations = new ArrayList<Operation>();
    private final List<Operation> staticOperations = new ArrayList<Operation>();
    private PartitionColumns updatedColumns;
    private PartitionColumns.Builder updatedColumnsBuilder = PartitionColumns.builder();
    private PartitionColumns conditionColumns;
    private PartitionColumns.Builder conditionColumnsBuilder = PartitionColumns.builder();
    private List<ColumnCondition> columnConditions;
    private List<ColumnCondition> staticConditions;
    private boolean ifNotExists;
    private boolean ifExists;
    private boolean hasNoClusteringColumns = true;
    private boolean setsStaticColumns;
    private boolean setsRegularColumns;
    private final Function<ColumnCondition, ColumnDefinition> getColumnForCondition = new Function<ColumnCondition, ColumnDefinition>(){

        public ColumnDefinition apply(ColumnCondition cond) {
            return cond.column;
        }
    };

    public ModificationStatement(StatementType type, int boundTerms, CFMetaData cfm, Attributes attrs) {
        this.type = type;
        this.boundTerms = boundTerms;
        this.cfm = cfm;
        this.attrs = attrs;
    }

    @Override
    public Iterable<org.apache.cassandra.cql3.functions.Function> getFunctions() {
        Iterable functions = this.attrs.getFunctions();
        for (Restriction restriction : this.processedKeys.values()) {
            functions = Iterables.concat(functions, restriction.getFunctions());
        }
        for (Operation operation : this.allOperations()) {
            functions = Iterables.concat((Iterable)functions, operation.getFunctions());
        }
        for (ColumnCondition condition : this.allConditions()) {
            functions = Iterables.concat((Iterable)functions, condition.getFunctions());
        }
        return functions;
    }

    public boolean hasNoClusteringColumns() {
        return this.hasNoClusteringColumns;
    }

    public abstract boolean requireFullClusteringKey();

    public abstract void addUpdateForKey(PartitionUpdate var1, CBuilder var2, UpdateParameters var3) throws InvalidRequestException;

    @Override
    public int getBoundTerms() {
        return this.boundTerms;
    }

    public String keyspace() {
        return this.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfm.cfName;
    }

    public boolean isCounter() {
        return this.cfm.isCounter();
    }

    public boolean isMaterializedView() {
        return this.cfm.isMaterializedView();
    }

    public boolean hasMaterializedViews() {
        return !this.cfm.getMaterializedViews().isEmpty();
    }

    public long getTimestamp(long now, QueryOptions options) throws InvalidRequestException {
        return this.attrs.getTimestamp(now, options);
    }

    public boolean isTimestampSet() {
        return this.attrs.isTimestampSet();
    }

    public int getTimeToLive(QueryOptions options) throws InvalidRequestException {
        return this.attrs.getTimeToLive(options);
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.MODIFY);
        if (this.hasConditions()) {
            state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.SELECT);
        }
        if (this.hasMaterializedViews()) {
            state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.SELECT);
            for (MaterializedViewDefinition view : this.cfm.getMaterializedViews()) {
                state.hasColumnFamilyAccess(this.keyspace(), view.viewName, Permission.MODIFY);
            }
        }
        for (org.apache.cassandra.cql3.functions.Function function : this.getFunctions()) {
            state.ensureHasPermission(Permission.EXECUTE, function);
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (this.hasConditions() && this.attrs.isTimestampSet()) {
            throw new InvalidRequestException("Cannot provide custom timestamp for conditional updates");
        }
        if (this.isCounter() && this.attrs.isTimestampSet()) {
            throw new InvalidRequestException("Cannot provide custom timestamp for counter updates");
        }
        if (this.isCounter() && this.attrs.isTimeToLiveSet()) {
            throw new InvalidRequestException("Cannot provide custom TTL for counter updates");
        }
        if (this.isMaterializedView()) {
            throw new InvalidRequestException("Cannot directly modify a materialized view");
        }
    }

    public void addOperation(Operation op) {
        this.updatedColumnsBuilder.add(op.column);
        if (op.requiresRead()) {
            this.conditionColumnsBuilder.add(op.column);
        }
        if (op.column.isStatic()) {
            this.setsStaticColumns = true;
            this.staticOperations.add(op);
        } else {
            this.setsRegularColumns = true;
            this.regularOperations.add(op);
        }
    }

    public PartitionColumns updatedColumns() {
        return this.updatedColumns;
    }

    public PartitionColumns conditionColumns() {
        return this.conditionColumns;
    }

    public boolean updatesRegularRows() {
        return this.cfm.clusteringColumns().isEmpty() || !this.hasNoClusteringColumns;
    }

    public boolean updatesStaticRow() {
        return !this.staticOperations.isEmpty();
    }

    private void finishPreparation() {
        this.updatedColumns = this.updatedColumnsBuilder.build();
        if (this.cfm.isCompactTable() && this.updatedColumns.isEmpty() && this.updatesRegularRows()) {
            this.updatedColumns = this.cfm.partitionColumns();
        }
        this.conditionColumns = this.conditionColumnsBuilder.build();
    }

    public List<Operation> getRegularOperations() {
        return this.regularOperations;
    }

    public List<Operation> getStaticOperations() {
        return this.staticOperations;
    }

    public Iterable<Operation> allOperations() {
        return Iterables.concat(this.staticOperations, this.regularOperations);
    }

    public Iterable<ColumnDefinition> getColumnsWithConditions() {
        if (this.ifNotExists || this.ifExists) {
            return null;
        }
        return Iterables.concat(this.columnConditions == null ? Collections.emptyList() : Iterables.transform(this.columnConditions, this.getColumnForCondition), this.staticConditions == null ? Collections.emptyList() : Iterables.transform(this.staticConditions, this.getColumnForCondition));
    }

    public Iterable<ColumnCondition> allConditions() {
        if (this.staticConditions == null) {
            return this.columnConditions == null ? Collections.emptySet() : this.columnConditions;
        }
        if (this.columnConditions == null) {
            return this.staticConditions;
        }
        return Iterables.concat(this.staticConditions, this.columnConditions);
    }

    public void addCondition(ColumnCondition cond) {
        this.conditionColumnsBuilder.add(cond.column);
        List<ColumnCondition> conds = null;
        if (cond.column.isStatic()) {
            this.setsStaticColumns = true;
            if (this.staticConditions == null) {
                this.staticConditions = new ArrayList<ColumnCondition>();
            }
            conds = this.staticConditions;
        } else {
            this.setsRegularColumns = true;
            if (this.columnConditions == null) {
                this.columnConditions = new ArrayList<ColumnCondition>();
            }
            conds = this.columnConditions;
        }
        conds.add(cond);
    }

    public void setIfNotExistCondition() {
        this.ifNotExists = true;
    }

    public boolean hasIfNotExistCondition() {
        return this.ifNotExists;
    }

    public void setIfExistCondition() {
        this.ifExists = true;
    }

    public boolean hasIfExistCondition() {
        return this.ifExists;
    }

    private void addKeyValues(ColumnDefinition def, Restriction values) throws InvalidRequestException {
        if (def.kind == ColumnDefinition.Kind.CLUSTERING) {
            this.hasNoClusteringColumns = false;
        }
        if (this.processedKeys.put(def.name, values) != null) {
            throw new InvalidRequestException(String.format("Multiple definitions found for PRIMARY KEY part %s", def.name));
        }
    }

    public void addKeyValue(ColumnDefinition def, Term value) throws InvalidRequestException {
        this.addKeyValues(def, new SingleColumnRestriction.EQRestriction(def, value));
    }

    public void processWhereClause(List<Relation> whereClause, VariableSpecifications names) throws InvalidRequestException {
        block3: for (Relation relation : whereClause) {
            if (relation.isMultiColumn()) {
                throw new InvalidRequestException(String.format("Multi-column relations cannot be used in WHERE clauses for UPDATE and DELETE statements: %s", relation));
            }
            SingleColumnRelation rel = (SingleColumnRelation)relation;
            if (rel.onToken()) {
                throw new InvalidRequestException(String.format("The token function cannot be used in WHERE clauses for UPDATE and DELETE statements: %s", relation));
            }
            ColumnIdentifier id = rel.getEntity().prepare(this.cfm);
            ColumnDefinition def = this.cfm.getColumnDefinition(id);
            if (def == null) {
                throw new InvalidRequestException(String.format("Unknown key identifier %s", id));
            }
            switch (def.kind) {
                case PARTITION_KEY: 
                case CLUSTERING: {
                    if (!(rel.isEQ() || def.isPartitionKey() && rel.isIN())) {
                        throw new InvalidRequestException(String.format("Invalid operator %s for PRIMARY KEY part %s", new Object[]{rel.operator(), def.name}));
                    }
                    Restriction restriction = rel.toRestriction(this.cfm, names);
                    this.addKeyValues(def, restriction);
                    continue block3;
                }
            }
            throw new InvalidRequestException(String.format("Non PRIMARY KEY %s found in where clause", def.name));
        }
    }

    public List<ByteBuffer> buildPartitionKeyNames(QueryOptions options) throws InvalidRequestException {
        MultiCBuilder keyBuilder = MultiCBuilder.create(this.cfm.getKeyValidatorAsClusteringComparator());
        for (ColumnDefinition def : this.cfm.partitionKeyColumns()) {
            Restriction r = RequestValidations.checkNotNull(this.processedKeys.get(def.name), "Missing mandatory PRIMARY KEY part %s", def.name);
            r.appendTo(keyBuilder, options);
        }
        NavigableSet<Clustering> clusterings = keyBuilder.build();
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>(clusterings.size());
        for (Clustering clustering : clusterings) {
            ByteBuffer key = CFMetaData.serializePartitionKey(clustering);
            ThriftValidation.validateKey(this.cfm, key);
            keys.add(key);
        }
        return keys;
    }

    public CBuilder createClustering(QueryOptions options) throws InvalidRequestException {
        if (this.setsStaticColumns && !this.setsRegularColumns) {
            if (this.hasNoClusteringColumns) {
                return CBuilder.STATIC_BUILDER;
            }
            if (this.type != StatementType.INSERT) {
                for (ColumnDefinition def : this.cfm.clusteringColumns()) {
                    if (this.processedKeys.get(def.name) == null) continue;
                    throw new InvalidRequestException(String.format("Invalid restriction on clustering column %s since the %s statement modifies only static columns", new Object[]{def.name, this.type}));
                }
                throw new AssertionError();
            }
        }
        return this.createClusteringInternal(options);
    }

    private CBuilder createClusteringInternal(QueryOptions options) throws InvalidRequestException {
        CBuilder builder = CBuilder.create(this.cfm.comparator);
        MultiCBuilder multiBuilder = MultiCBuilder.wrap(builder);
        ColumnDefinition firstEmptyKey = null;
        for (ColumnDefinition def : this.cfm.clusteringColumns()) {
            Restriction r = this.processedKeys.get(def.name);
            if (r == null) {
                firstEmptyKey = def;
                RequestValidations.checkFalse(this.requireFullClusteringKey() && !this.cfm.isDense() && this.cfm.isCompound(), "Missing mandatory PRIMARY KEY part %s", def.name);
                continue;
            }
            if (firstEmptyKey != null) {
                throw RequestValidations.invalidRequest("Missing PRIMARY KEY part %s since %s is set", firstEmptyKey.name, def.name);
            }
            r.appendTo(multiBuilder, options);
        }
        return builder;
    }

    protected ColumnDefinition getFirstEmptyKey() {
        for (ColumnDefinition def : this.cfm.clusteringColumns()) {
            if (this.processedKeys.get(def.name) != null) continue;
            return def;
        }
        return null;
    }

    public boolean requiresRead() {
        for (Operation op : this.allOperations()) {
            if (!op.requiresRead()) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    protected Map<DecoratedKey, Partition> readRequiredLists(Collection<ByteBuffer> partitionKeys, CBuilder cbuilder, boolean local, ConsistencyLevel cl) throws RequestExecutionException, RequestValidationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<DecoratedKey, Partition> asMaterializedMap(PartitionIterator iterator) {
        HashMap<DecoratedKey, Partition> map = new HashMap<DecoratedKey, Partition>();
        while (iterator.hasNext()) {
            RowIterator partition = (RowIterator)iterator.next();
            Throwable throwable = null;
            try {
                map.put(partition.partitionKey(), FilteredPartition.create(partition));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (partition == null) continue;
                if (throwable != null) {
                    try {
                        partition.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                partition.close();
            }
        }
        return map;
    }

    public boolean hasConditions() {
        return this.ifNotExists || this.ifExists || this.columnConditions != null && !this.columnConditions.isEmpty() || this.staticConditions != null && !this.staticConditions.isEmpty();
    }

    @Override
    public ResultMessage execute(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        if (options.getConsistency() == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        if (this.hasConditions() && options.getProtocolVersion() == 1) {
            throw new InvalidRequestException("Conditional updates are not supported by the protocol version in use. You need to upgrade to a driver using the native protocol v2.");
        }
        return this.hasConditions() ? this.executeWithCondition(queryState, options) : this.executeWithoutCondition(queryState, options);
    }

    private ResultMessage executeWithoutCondition(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        ConsistencyLevel cl = options.getConsistency();
        if (this.isCounter()) {
            cl.validateCounterForWrite(this.cfm);
        } else {
            cl.validateForWrite(this.cfm.ksName);
        }
        Collection<? extends IMutation> mutations = this.getMutations(options, false, options.getTimestamp(queryState));
        if (!mutations.isEmpty()) {
            StorageProxy.mutateWithTriggers(mutations, cl, false);
        }
        return null;
    }

    public ResultMessage executeWithCondition(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        CQL3CasRequest request = this.makeCasRequest(queryState, options);
        try (RowIterator result = StorageProxy.cas(this.keyspace(), this.columnFamily(), request.key, request, options.getSerialConsistency(), options.getConsistency(), queryState.getClientState());){
            ResultMessage.Rows rows = new ResultMessage.Rows(this.buildCasResultSet(result, options));
            return rows;
        }
    }

    private CQL3CasRequest makeCasRequest(QueryState queryState, QueryOptions options) {
        List<ByteBuffer> keys = this.buildPartitionKeyNames(options);
        if (keys.size() > 1) {
            throw new InvalidRequestException("IN on the partition key is not supported with conditional updates");
        }
        DecoratedKey key = StorageService.getPartitioner().decorateKey(keys.get(0));
        long now = options.getTimestamp(queryState);
        CBuilder cbuilder = this.createClustering(options);
        CQL3CasRequest request = new CQL3CasRequest(this.cfm, key, false, this.conditionColumns(), this.updatesRegularRows(), this.updatesStaticRow());
        this.addConditions(cbuilder.build(), request, options);
        request.addRowUpdate(cbuilder, this, options, now);
        return request;
    }

    public void addConditions(Clustering clustering, CQL3CasRequest request, QueryOptions options) throws InvalidRequestException {
        if (this.ifNotExists) {
            request.addNotExist(clustering);
        } else if (this.ifExists) {
            request.addExist(clustering);
        } else {
            if (this.columnConditions != null) {
                request.addConditions(clustering, this.columnConditions, options);
            }
            if (this.staticConditions != null) {
                request.addConditions(Clustering.STATIC_CLUSTERING, this.staticConditions, options);
            }
        }
    }

    private ResultSet buildCasResultSet(RowIterator partition, QueryOptions options) throws InvalidRequestException {
        return ModificationStatement.buildCasResultSet(this.keyspace(), this.columnFamily(), partition, this.getColumnsWithConditions(), false, options);
    }

    public static ResultSet buildCasResultSet(String ksName, String tableName, RowIterator partition, Iterable<ColumnDefinition> columnsWithConditions, boolean isBatch, QueryOptions options) throws InvalidRequestException {
        boolean success = partition == null;
        ColumnSpecification spec = new ColumnSpecification(ksName, tableName, CAS_RESULT_COLUMN, BooleanType.instance);
        ResultSet.ResultMetadata metadata = new ResultSet.ResultMetadata(Collections.singletonList(spec));
        List<List<ByteBuffer>> rows = Collections.singletonList(Collections.singletonList(BooleanType.instance.decompose(success)));
        ResultSet rs = new ResultSet(metadata, rows);
        return success ? rs : ModificationStatement.merge(rs, ModificationStatement.buildCasFailureResultSet(partition, columnsWithConditions, isBatch, options));
    }

    private static ResultSet merge(ResultSet left, ResultSet right) {
        if (left.size() == 0) {
            return right;
        }
        if (right.size() == 0) {
            return left;
        }
        assert (left.size() == 1);
        int size = left.metadata.names.size() + right.metadata.names.size();
        ArrayList<ColumnSpecification> specs = new ArrayList<ColumnSpecification>(size);
        specs.addAll(left.metadata.names);
        specs.addAll(right.metadata.names);
        ArrayList<List<ByteBuffer>> rows = new ArrayList<List<ByteBuffer>>(right.size());
        for (int i = 0; i < right.size(); ++i) {
            ArrayList row = new ArrayList(size);
            row.addAll(left.rows.get(0));
            row.addAll(right.rows.get(i));
            rows.add(row);
        }
        return new ResultSet(new ResultSet.ResultMetadata(specs), rows);
    }

    private static ResultSet buildCasFailureResultSet(RowIterator partition, Iterable<ColumnDefinition> columnsWithConditions, boolean isBatch, QueryOptions options) throws InvalidRequestException {
        Selection selection;
        CFMetaData cfm = partition.metadata();
        if (columnsWithConditions == null) {
            selection = Selection.wildcard(cfm);
        } else {
            LinkedHashSet<ColumnDefinition> defs = new LinkedHashSet<ColumnDefinition>();
            if (isBatch) {
                defs.addAll(cfm.partitionKeyColumns());
                defs.addAll(cfm.clusteringColumns());
            }
            for (ColumnDefinition def : columnsWithConditions) {
                defs.add(def);
            }
            selection = Selection.forColumns(cfm, new ArrayList<ColumnDefinition>(defs));
        }
        Selection.ResultSetBuilder builder = selection.resultSetBuilder(false);
        SelectStatement.forSelection(cfm, selection).processPartition(partition, options, builder, FBUtilities.nowInSeconds());
        return builder.build(options.getProtocolVersion());
    }

    @Override
    public ResultMessage executeInternal(QueryState queryState, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        return this.hasConditions() ? this.executeInternalWithCondition(queryState, options) : this.executeInternalWithoutCondition(queryState, options);
    }

    public ResultMessage executeInternalWithoutCondition(QueryState queryState, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        for (IMutation iMutation : this.getMutations(options, true, queryState.getTimestamp())) {
            assert (iMutation instanceof Mutation || iMutation instanceof CounterMutation);
            if (iMutation instanceof Mutation) {
                ((Mutation)iMutation).apply();
                continue;
            }
            if (!(iMutation instanceof CounterMutation)) continue;
            ((CounterMutation)iMutation).apply();
        }
        return null;
    }

    public ResultMessage executeInternalWithCondition(QueryState state, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        CQL3CasRequest request = this.makeCasRequest(state, options);
        try (RowIterator result = ModificationStatement.casInternal(request, state);){
            ResultMessage.Rows rows = new ResultMessage.Rows(this.buildCasResultSet(result, options));
            return rows;
        }
    }

    /*
     * WARNING - void declaration
     */
    static RowIterator casInternal(CQL3CasRequest request, QueryState state) {
        void var5_11;
        FilteredPartition current;
        UUID ballot = UUIDGen.getTimeUUIDFromMicros(state.getTimestamp());
        CFMetaData metadata = Schema.instance.getCFMetaData(request.cfm.ksName, request.cfm.cfName);
        SinglePartitionReadCommand readCommand = request.readCommand(FBUtilities.nowInSeconds());
        try (ReadOrderGroup orderGroup = readCommand.startOrderGroup();
             PartitionIterator iter = readCommand.executeInternal(orderGroup);){
            current = FilteredPartition.create(PartitionIterators.getOnlyElement(iter, readCommand));
        }
        if (!request.appliesTo(current)) {
            return current.rowIterator();
        }
        PartitionUpdate updates = request.makeUpdates((FilteredPartition)var5_11);
        updates = TriggerExecutor.instance.execute(updates);
        Commit proposal = Commit.newProposal(ballot, updates);
        proposal.makeMutation().apply();
        return null;
    }

    private Collection<? extends IMutation> getMutations(QueryOptions options, boolean local, long now) throws RequestExecutionException, RequestValidationException {
        List<ByteBuffer> keys = this.buildPartitionKeyNames(options);
        CBuilder clustering = this.createClustering(options);
        UpdateParameters params = this.makeUpdateParameters(keys, clustering, options, local, now);
        ArrayList<Mutation> mutations = new ArrayList<Mutation>(keys.size());
        for (ByteBuffer key : keys) {
            ThriftValidation.validateKey(this.cfm, key);
            DecoratedKey dk = StorageService.getPartitioner().decorateKey(key);
            PartitionUpdate upd = new PartitionUpdate(this.cfm, dk, this.updatedColumns(), 1);
            this.addUpdateForKey(upd, clustering, params);
            Mutation mut = new Mutation(upd);
            mutations.add((Mutation)(this.isCounter() ? new CounterMutation(mut, options.getConsistency()) : mut));
        }
        return mutations;
    }

    public UpdateParameters makeUpdateParameters(Collection<ByteBuffer> keys, CBuilder clustering, QueryOptions options, boolean local, long now) throws RequestExecutionException, RequestValidationException {
        Map<DecoratedKey, Partition> lists = this.readRequiredLists(keys, clustering, local, options.getConsistency());
        return new UpdateParameters(this.cfm, this.updatedColumns(), options, this.getTimestamp(now, options), this.getTimeToLive(options), lists, true);
    }

    protected void validateWhereClauseForConditions() throws InvalidRequestException {
    }

    public static abstract class Parsed
    extends CFStatement {
        protected final Attributes.Raw attrs;
        protected final List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions;
        private final boolean ifNotExists;
        private final boolean ifExists;

        protected Parsed(CFName name, Attributes.Raw attrs, List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions, boolean ifNotExists, boolean ifExists) {
            super(name);
            this.attrs = attrs;
            this.conditions = conditions == null ? Collections.emptyList() : conditions;
            this.ifNotExists = ifNotExists;
            this.ifExists = ifExists;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            VariableSpecifications boundNames = this.getBoundVariables();
            ModificationStatement statement = this.prepare(boundNames);
            CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            return new ParsedStatement.Prepared((CQLStatement)statement, boundNames, boundNames.getPartitionKeyBindIndexes(cfm));
        }

        public ModificationStatement prepare(VariableSpecifications boundNames) throws InvalidRequestException {
            CFMetaData metadata = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            Attributes preparedAttributes = this.attrs.prepare(this.keyspace(), this.columnFamily());
            preparedAttributes.collectMarkerSpecification(boundNames);
            ModificationStatement stmt = this.prepareInternal(metadata, boundNames, preparedAttributes);
            if (this.ifNotExists || this.ifExists || !this.conditions.isEmpty()) {
                if (stmt.isCounter()) {
                    throw new InvalidRequestException("Conditional updates are not supported on counter tables");
                }
                if (this.attrs.timestamp != null) {
                    throw new InvalidRequestException("Cannot provide custom timestamp for conditional updates");
                }
                if (this.ifNotExists) {
                    assert (this.conditions.isEmpty());
                    assert (!this.ifExists);
                    stmt.setIfNotExistCondition();
                } else if (this.ifExists) {
                    assert (this.conditions.isEmpty());
                    assert (!this.ifNotExists);
                    stmt.setIfExistCondition();
                } else {
                    for (Pair<ColumnIdentifier.Raw, ColumnCondition.Raw> entry : this.conditions) {
                        ColumnIdentifier id = ((ColumnIdentifier.Raw)entry.left).prepare(metadata);
                        ColumnDefinition def = metadata.getColumnDefinition(id);
                        if (def == null) {
                            throw new InvalidRequestException(String.format("Unknown identifier %s", id));
                        }
                        ColumnCondition condition = ((ColumnCondition.Raw)entry.right).prepare(this.keyspace(), def);
                        condition.collectMarkerSpecification(boundNames);
                        switch (def.kind) {
                            case PARTITION_KEY: 
                            case CLUSTERING: {
                                throw new InvalidRequestException(String.format("PRIMARY KEY column '%s' cannot have IF conditions", id));
                            }
                        }
                        stmt.addCondition(condition);
                    }
                }
                stmt.validateWhereClauseForConditions();
            }
            stmt.finishPreparation();
            return stmt;
        }

        protected abstract ModificationStatement prepareInternal(CFMetaData var1, VariableSpecifications var2, Attributes var3) throws InvalidRequestException;
    }

    public static enum StatementType {
        INSERT,
        UPDATE,
        DELETE;

    }
}

