/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.CFPropDefs;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ReversedType;

public class CFProperties {
    public final CFPropDefs properties = new CFPropDefs();
    final Map<ColumnIdentifier, Boolean> definedOrdering = new LinkedHashMap<ColumnIdentifier, Boolean>();
    boolean useCompactStorage = false;

    public void validate() {
        this.properties.validate();
    }

    public void setOrdering(ColumnIdentifier alias, boolean reversed) {
        this.definedOrdering.put(alias, reversed);
    }

    public void setCompactStorage() {
        this.useCompactStorage = true;
    }

    public AbstractType getReversableType(ColumnIdentifier targetIdentifier, AbstractType<?> type) {
        if (!this.definedOrdering.containsKey(targetIdentifier)) {
            return type;
        }
        return this.definedOrdering.get(targetIdentifier) != false ? ReversedType.getInstance(type) : type;
    }
}

