/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.AbstractPrimaryKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.PrimaryKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.RestrictionSet;
import org.apache.cassandra.cql3.restrictions.TokenFilter;
import org.apache.cassandra.cql3.restrictions.TokenRestriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.MultiCBuilder;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.btree.BTreeSet;

final class PrimaryKeyRestrictionSet
extends AbstractPrimaryKeyRestrictions {
    private final RestrictionSet restrictions;
    private boolean eq;
    private boolean in;
    private boolean slice;
    private boolean contains;
    private boolean isPartitionKey;

    public PrimaryKeyRestrictionSet(ClusteringComparator comparator, boolean isPartitionKey) {
        super(comparator);
        this.restrictions = new RestrictionSet();
        this.eq = true;
        this.isPartitionKey = isPartitionKey;
    }

    private PrimaryKeyRestrictionSet(PrimaryKeyRestrictionSet primaryKeyRestrictions, Restriction restriction) throws InvalidRequestException {
        super(primaryKeyRestrictions.comparator);
        this.restrictions = primaryKeyRestrictions.restrictions.addRestriction(restriction);
        this.isPartitionKey = primaryKeyRestrictions.isPartitionKey;
        if (!primaryKeyRestrictions.isEmpty()) {
            ColumnDefinition lastRestrictionStart = primaryKeyRestrictions.restrictions.lastRestriction().getFirstColumn();
            ColumnDefinition newRestrictionStart = restriction.getFirstColumn();
            RequestValidations.checkFalse(primaryKeyRestrictions.isSlice() && newRestrictionStart.position() > lastRestrictionStart.position(), "Clustering column \"%s\" cannot be restricted (preceding column \"%s\" is restricted by a non-EQ relation)", newRestrictionStart.name, lastRestrictionStart.name);
            if (newRestrictionStart.position() < lastRestrictionStart.position() && restriction.isSlice()) {
                throw RequestValidations.invalidRequest("PRIMARY KEY column \"%s\" cannot be restricted (preceding column \"%s\" is restricted by a non-EQ relation)", this.restrictions.nextColumn((ColumnDefinition)newRestrictionStart).name, newRestrictionStart.name);
            }
        }
        if (restriction.isSlice() || primaryKeyRestrictions.isSlice()) {
            this.slice = true;
        } else if (restriction.isContains() || primaryKeyRestrictions.isContains()) {
            this.contains = true;
        } else if (restriction.isIN()) {
            this.in = true;
        } else {
            this.eq = true;
        }
    }

    private List<ByteBuffer> toByteBuffers(SortedSet<? extends ClusteringPrefix> clusterings) {
        ArrayList<ByteBuffer> l = new ArrayList<ByteBuffer>(clusterings.size());
        for (ClusteringPrefix clusteringPrefix : clusterings) {
            l.add(CFMetaData.serializePartitionKey(clusteringPrefix));
        }
        return l;
    }

    @Override
    public boolean isSlice() {
        return this.slice;
    }

    @Override
    public boolean isEQ() {
        return this.eq;
    }

    @Override
    public boolean isIN() {
        return this.in;
    }

    @Override
    public boolean isOnToken() {
        return false;
    }

    @Override
    public boolean isContains() {
        return this.contains;
    }

    @Override
    public boolean isMultiColumn() {
        return false;
    }

    @Override
    public Iterable<Function> getFunctions() {
        return this.restrictions.getFunctions();
    }

    @Override
    public PrimaryKeyRestrictions mergeWith(Restriction restriction) throws InvalidRequestException {
        if (restriction.isOnToken()) {
            if (this.isEmpty()) {
                return (PrimaryKeyRestrictions)restriction;
            }
            return new TokenFilter(this, (TokenRestriction)restriction);
        }
        return new PrimaryKeyRestrictionSet(this, restriction);
    }

    @Override
    public NavigableSet<Clustering> valuesAsClustering(QueryOptions options) throws InvalidRequestException {
        return this.appendTo(MultiCBuilder.create(this.comparator), options).build();
    }

    @Override
    public MultiCBuilder appendTo(MultiCBuilder builder, QueryOptions options) {
        for (Restriction r : this.restrictions) {
            r.appendTo(builder, options);
            if (!builder.hasMissingElements()) continue;
            break;
        }
        return builder;
    }

    @Override
    public MultiCBuilder appendBoundTo(MultiCBuilder builder, Bound bound, QueryOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<Slice.Bound> boundsAsClustering(Bound bound, QueryOptions options) throws InvalidRequestException {
        MultiCBuilder builder = MultiCBuilder.create(this.comparator);
        int keyPosition = 0;
        for (Restriction r : this.restrictions) {
            Bound b;
            ColumnDefinition def = r.getFirstColumn();
            Bound bound2 = b = !def.isReversedType() ? bound : bound.reverse();
            if (keyPosition != def.position() || r.isContains()) break;
            if (r.isSlice()) {
                if (!r.hasBound(b)) {
                    return builder.buildBound(bound.isStart(), true);
                }
                r.appendBoundTo(builder, b, options);
                return builder.buildBound(bound.isStart(), r.isInclusive(b));
            }
            r.appendBoundTo(builder, b, options);
            if (builder.hasMissingElements()) {
                return BTreeSet.empty(this.comparator);
            }
            keyPosition = r.getLastColumn().position() + 1;
        }
        return builder.buildBound(bound.isStart(), true);
    }

    @Override
    public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
        if (!this.isPartitionKey) {
            throw new UnsupportedOperationException();
        }
        return this.toByteBuffers(this.valuesAsClustering(options));
    }

    @Override
    public List<ByteBuffer> bounds(Bound b, QueryOptions options) throws InvalidRequestException {
        if (!this.isPartitionKey) {
            throw new UnsupportedOperationException();
        }
        return this.toByteBuffers(this.boundsAsClustering(b, options));
    }

    @Override
    public boolean hasBound(Bound b) {
        if (this.isEmpty()) {
            return false;
        }
        return this.restrictions.lastRestriction().hasBound(b);
    }

    @Override
    public boolean isInclusive(Bound b) {
        if (this.isEmpty()) {
            return false;
        }
        return this.restrictions.lastRestriction().isInclusive(b);
    }

    @Override
    public boolean hasSupportingIndex(SecondaryIndexManager indexManager) {
        return this.restrictions.hasSupportingIndex(indexManager);
    }

    @Override
    public void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexManager, QueryOptions options) throws InvalidRequestException {
        int position = 0;
        for (Restriction restriction : this.restrictions) {
            ColumnDefinition columnDef = restriction.getFirstColumn();
            if (!this.isPartitionKey && !restriction.isContains() && position == columnDef.position()) {
                position = restriction.getLastColumn().position() + 1;
                if (!restriction.hasSupportingIndex(indexManager)) continue;
            }
            restriction.addRowFilterTo(filter, indexManager, options);
        }
    }

    @Override
    public Collection<ColumnDefinition> getColumnDefs() {
        return this.restrictions.getColumnDefs();
    }

    @Override
    public ColumnDefinition getFirstColumn() {
        return this.restrictions.firstColumn();
    }

    @Override
    public ColumnDefinition getLastColumn() {
        return this.restrictions.lastColumn();
    }
}

