/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.Tuples;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.AbstractRestriction;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.SingleColumnRestriction;
import org.apache.cassandra.cql3.restrictions.TermSlice;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.composites.CompositesBuilder;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.exceptions.InvalidRequestException;

public abstract class MultiColumnRestriction
extends AbstractRestriction {
    protected final List<ColumnDefinition> columnDefs;

    public MultiColumnRestriction(List<ColumnDefinition> columnDefs) {
        this.columnDefs = columnDefs;
    }

    @Override
    public boolean isMultiColumn() {
        return true;
    }

    @Override
    public ColumnDefinition getFirstColumn() {
        return this.columnDefs.get(0);
    }

    @Override
    public ColumnDefinition getLastColumn() {
        return this.columnDefs.get(this.columnDefs.size() - 1);
    }

    @Override
    public List<ColumnDefinition> getColumnDefs() {
        return this.columnDefs;
    }

    @Override
    public final Restriction mergeWith(Restriction otherRestriction) throws InvalidRequestException {
        if (!otherRestriction.isMultiColumn() && ((SingleColumnRestriction)otherRestriction).canBeConvertedToMultiColumnRestriction()) {
            return this.doMergeWith(((SingleColumnRestriction)otherRestriction).toMultiColumnRestriction());
        }
        return this.doMergeWith(otherRestriction);
    }

    protected abstract Restriction doMergeWith(Restriction var1) throws InvalidRequestException;

    protected final String getColumnsInCommons(Restriction otherRestriction) {
        HashSet<ColumnDefinition> commons = new HashSet<ColumnDefinition>(this.getColumnDefs());
        commons.retainAll(otherRestriction.getColumnDefs());
        StringBuilder builder = new StringBuilder();
        for (ColumnDefinition columnDefinition : commons) {
            if (builder.length() != 0) {
                builder.append(" ,");
            }
            builder.append(columnDefinition.name);
        }
        return builder.toString();
    }

    @Override
    public final boolean hasSupportingIndex(SecondaryIndexManager indexManager) {
        for (ColumnDefinition columnDef : this.columnDefs) {
            SecondaryIndex index = indexManager.getIndexForColumn(columnDef.name.bytes);
            if (index == null || !this.isSupportedBy(index)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean isSupportedBy(SecondaryIndex var1);

    public static class Slice
    extends MultiColumnRestriction {
        private final TermSlice slice;

        public Slice(List<ColumnDefinition> columnDefs, Bound bound, boolean inclusive, Term term) {
            this(columnDefs, TermSlice.newInstance(bound, inclusive, term));
        }

        Slice(List<ColumnDefinition> columnDefs, TermSlice slice) {
            super(columnDefs);
            this.slice = slice;
        }

        @Override
        public boolean isSlice() {
            return true;
        }

        @Override
        public CompositesBuilder appendTo(CompositesBuilder builder, QueryOptions options) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompositesBuilder appendBoundTo(CompositesBuilder builder, Bound bound, QueryOptions options) {
            boolean reversed = this.getFirstColumn().isReversedType();
            EnumMap<Bound, List<ByteBuffer>> componentBounds = new EnumMap<Bound, List<ByteBuffer>>(Bound.class);
            componentBounds.put(Bound.START, this.componentBounds(Bound.START, options));
            componentBounds.put(Bound.END, this.componentBounds(Bound.END, options));
            ArrayList<List<ByteBuffer>> toAdd = new ArrayList<List<ByteBuffer>>();
            ArrayList<ByteBuffer> values = new ArrayList<ByteBuffer>();
            int m = this.columnDefs.size();
            for (int i = 0; i < m; ++i) {
                ColumnDefinition column = (ColumnDefinition)this.columnDefs.get(i);
                Bound b = Slice.reverseBoundIfNeeded(column, bound);
                if (reversed != column.isReversedType()) {
                    reversed = column.isReversedType();
                    toAdd.add(values);
                    if (!this.hasComponent(b, i, componentBounds)) continue;
                    if (this.hasComponent(b.reverse(), i, componentBounds)) {
                        toAdd.add(values);
                    }
                    values = new ArrayList();
                    List<ByteBuffer> vals = componentBounds.get((Object)b);
                    int n = Math.min(i, vals.size());
                    for (int j = 0; j < n; ++j) {
                        ByteBuffer v = RequestValidations.checkNotNull(vals.get(j), "Invalid null value in condition for column %s", ((ColumnDefinition)this.columnDefs.get((int)j)).name);
                        values.add(v);
                    }
                }
                if (!this.hasComponent(b, i, componentBounds)) continue;
                ByteBuffer v = RequestValidations.checkNotNull(componentBounds.get((Object)b).get(i), "Invalid null value in condition for column %s", ((ColumnDefinition)this.columnDefs.get((int)i)).name);
                values.add(v);
            }
            toAdd.add(values);
            if (bound.isEnd()) {
                Collections.reverse(toAdd);
            }
            return builder.addAllElementsToAll(toAdd);
        }

        @Override
        protected boolean isSupportedBy(SecondaryIndex index) {
            return this.slice.isSupportedBy(index);
        }

        @Override
        public boolean hasBound(Bound bound) {
            return this.slice.hasBound(bound);
        }

        @Override
        public Iterable<Function> getFunctions() {
            return this.slice.getFunctions();
        }

        @Override
        public boolean isInclusive(Bound bound) {
            return this.slice.isInclusive(bound);
        }

        @Override
        public Restriction doMergeWith(Restriction otherRestriction) throws InvalidRequestException {
            RequestValidations.checkTrue(otherRestriction.isSlice(), "Column \"%s\" cannot be restricted by both an equality and an inequality relation", this.getColumnsInCommons(otherRestriction));
            if (!this.getFirstColumn().equals(otherRestriction.getFirstColumn())) {
                ColumnDefinition column = this.getFirstColumn().position() > otherRestriction.getFirstColumn().position() ? this.getFirstColumn() : otherRestriction.getFirstColumn();
                throw RequestValidations.invalidRequest("Column \"%s\" cannot be restricted by two inequalities not starting with the same column", column.name);
            }
            RequestValidations.checkFalse(this.hasBound(Bound.START) && otherRestriction.hasBound(Bound.START), "More than one restriction was found for the start bound on %s", this.getColumnsInCommons(otherRestriction));
            RequestValidations.checkFalse(this.hasBound(Bound.END) && otherRestriction.hasBound(Bound.END), "More than one restriction was found for the end bound on %s", this.getColumnsInCommons(otherRestriction));
            Slice otherSlice = (Slice)otherRestriction;
            List newColumnDefs = this.columnDefs.size() >= otherSlice.columnDefs.size() ? this.columnDefs : otherSlice.columnDefs;
            return new Slice(newColumnDefs, this.slice.merge(otherSlice.slice));
        }

        @Override
        public final void addIndexExpressionTo(List<IndexExpression> expressions, SecondaryIndexManager indexManager, QueryOptions options) throws InvalidRequestException {
            throw RequestValidations.invalidRequest("Slice restrictions are not supported on indexed columns", new Object[0]);
        }

        public String toString() {
            return "SLICE" + this.slice;
        }

        private List<ByteBuffer> componentBounds(Bound b, QueryOptions options) throws InvalidRequestException {
            if (!this.slice.hasBound(b)) {
                return Collections.emptyList();
            }
            Term.Terminal terminal = this.slice.bound(b).bind(options);
            if (terminal instanceof Tuples.Value) {
                return ((Tuples.Value)terminal).getElements();
            }
            return Collections.singletonList(terminal.get(options.getProtocolVersion()));
        }

        private boolean hasComponent(Bound b, int index, EnumMap<Bound, List<ByteBuffer>> componentBounds) {
            return componentBounds.get((Object)b).size() > index;
        }
    }

    public static class InWithMarker
    extends IN {
        protected final AbstractMarker marker;

        public InWithMarker(List<ColumnDefinition> columnDefs, AbstractMarker marker) {
            super(columnDefs);
            this.marker = marker;
        }

        @Override
        public Iterable<Function> getFunctions() {
            return Collections.emptySet();
        }

        public String toString() {
            return "IN ?";
        }

        @Override
        protected List<List<ByteBuffer>> splitValues(QueryOptions options) throws InvalidRequestException {
            Tuples.InMarker inMarker = (Tuples.InMarker)this.marker;
            Tuples.InValue inValue = inMarker.bind(options);
            RequestValidations.checkNotNull(inValue, "Invalid null value for IN restriction", new Object[0]);
            return inValue.getSplitValues();
        }
    }

    public static class InWithValues
    extends IN {
        protected final List<Term> values;

        public InWithValues(List<ColumnDefinition> columnDefs, List<Term> values) {
            super(columnDefs);
            this.values = values;
        }

        @Override
        public Iterable<Function> getFunctions() {
            return Terms.getFunctions(this.values);
        }

        public String toString() {
            return String.format("IN(%s)", this.values);
        }

        @Override
        protected List<List<ByteBuffer>> splitValues(QueryOptions options) throws InvalidRequestException {
            ArrayList<List<ByteBuffer>> buffers = new ArrayList<List<ByteBuffer>>(this.values.size());
            for (Term value : this.values) {
                Term.MultiItemTerminal term = (Term.MultiItemTerminal)value.bind(options);
                buffers.add(term.getElements());
            }
            return buffers;
        }
    }

    public static abstract class IN
    extends MultiColumnRestriction {
        @Override
        public CompositesBuilder appendTo(CompositesBuilder builder, QueryOptions options) {
            List<List<ByteBuffer>> splitInValues = this.splitValues(options);
            builder.addAllElementsToAll(splitInValues);
            if (builder.containsNull()) {
                throw RequestValidations.invalidRequest("Invalid null value in condition for columns: %s", ColumnDefinition.toIdentifiers(this.columnDefs));
            }
            return builder;
        }

        public IN(List<ColumnDefinition> columnDefs) {
            super(columnDefs);
        }

        @Override
        public boolean isIN() {
            return true;
        }

        @Override
        public Restriction doMergeWith(Restriction otherRestriction) throws InvalidRequestException {
            throw RequestValidations.invalidRequest("%s cannot be restricted by more than one relation if it includes a IN", this.getColumnsInCommons(otherRestriction));
        }

        @Override
        protected boolean isSupportedBy(SecondaryIndex index) {
            return index.supportsOperator(Operator.IN);
        }

        @Override
        public final void addIndexExpressionTo(List<IndexExpression> expressions, SecondaryIndexManager indexManager, QueryOptions options) throws InvalidRequestException {
            List<List<ByteBuffer>> splitInValues = this.splitValues(options);
            RequestValidations.checkTrue(splitInValues.size() == 1, "IN restrictions are not supported on indexed columns");
            List<ByteBuffer> values = splitInValues.get(0);
            int m = this.columnDefs.size();
            for (int i = 0; i < m; ++i) {
                ColumnDefinition columnDef = (ColumnDefinition)this.columnDefs.get(i);
                ByteBuffer component = IN.validateIndexedValue(columnDef, values.get(i));
                expressions.add(new IndexExpression(columnDef.name.bytes, Operator.EQ, component));
            }
        }

        protected abstract List<List<ByteBuffer>> splitValues(QueryOptions var1) throws InvalidRequestException;
    }

    public static class EQ
    extends MultiColumnRestriction {
        protected final Term value;

        public EQ(List<ColumnDefinition> columnDefs, Term value) {
            super(columnDefs);
            this.value = value;
        }

        @Override
        public Iterable<Function> getFunctions() {
            return this.value.getFunctions();
        }

        public String toString() {
            return String.format("EQ(%s)", this.value);
        }

        @Override
        public Restriction doMergeWith(Restriction otherRestriction) throws InvalidRequestException {
            throw RequestValidations.invalidRequest("%s cannot be restricted by more than one relation if it includes an Equal", this.getColumnsInCommons(otherRestriction));
        }

        @Override
        protected boolean isSupportedBy(SecondaryIndex index) {
            return index.supportsOperator(Operator.EQ);
        }

        @Override
        public CompositesBuilder appendTo(CompositesBuilder builder, QueryOptions options) {
            Tuples.Value t = (Tuples.Value)this.value.bind(options);
            List<ByteBuffer> values = t.getElements();
            int m = values.size();
            for (int i = 0; i < m; ++i) {
                builder.addElementToAll(values.get(i));
                RequestValidations.checkFalse(builder.containsNull(), "Invalid null value for column %s", ((ColumnDefinition)this.columnDefs.get((int)i)).name);
            }
            return builder;
        }

        @Override
        public final void addIndexExpressionTo(List<IndexExpression> expressions, SecondaryIndexManager indexManager, QueryOptions options) throws InvalidRequestException {
            Tuples.Value t = (Tuples.Value)this.value.bind(options);
            List<ByteBuffer> values = t.getElements();
            int m = this.columnDefs.size();
            for (int i = 0; i < m; ++i) {
                ColumnDefinition columnDef = (ColumnDefinition)this.columnDefs.get(i);
                ByteBuffer component = EQ.validateIndexedValue(columnDef, values.get(i));
                expressions.add(new IndexExpression(columnDef.name.bytes, Operator.EQ, component));
            }
        }
    }
}

