/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.pig;

import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.hadoop.cql3.CqlBulkOutputFormat;
import org.apache.cassandra.hadoop.cql3.CqlConfigHelper;
import org.apache.cassandra.hadoop.cql3.CqlRecordReader;
import org.apache.cassandra.hadoop.pig.ColumnInfo;
import org.apache.cassandra.hadoop.pig.StorageHelper;
import org.apache.cassandra.hadoop.pig.TableInfo;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.UDFContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class CqlNativeStorage
extends LoadFunc
implements StoreFuncInterface,
LoadMetadata {
    protected String DEFAULT_INPUT_FORMAT;
    protected String DEFAULT_OUTPUT_FORMAT;
    protected String username;
    protected String password;
    protected String keyspace;
    protected String column_family;
    protected String loadSignature;
    protected String storeSignature;
    protected Configuration conf;
    protected String inputFormatClass;
    protected String outputFormatClass;
    protected int splitSize = 65536;
    protected String partitionerClass;
    protected boolean usePartitionFilter = false;
    protected String initHostAddress;
    protected String rpcPort;
    protected int nativeProtocolVersion = 1;
    private static final Logger logger = LoggerFactory.getLogger(CqlNativeStorage.class);
    private static String BULK_OUTPUT_FORMAT = "org.apache.cassandra.hadoop.cql3.CqlBulkOutputFormat";
    private int pageSize = 1000;
    private String columns;
    private String outputQuery;
    private String whereClause;
    private RecordReader<Long, Row> reader;
    private RecordWriter<Map<String, ByteBuffer>, List<ByteBuffer>> writer;
    private String nativePort;
    private String nativeCoreConnections;
    private String nativeMaxConnections;
    private String nativeMaxSimultReqs;
    private String nativeConnectionTimeout;
    private String nativeReadConnectionTimeout;
    private String nativeReceiveBufferSize;
    private String nativeSendBufferSize;
    private String nativeSolinger;
    private String nativeTcpNodelay;
    private String nativeReuseAddress;
    private String nativeKeepAlive;
    private String nativeAuthProvider;
    private String nativeSSLTruststorePath;
    private String nativeSSLKeystorePath;
    private String nativeSSLTruststorePassword;
    private String nativeSSLKeystorePassword;
    private String nativeSSLCipherSuites;
    private String inputCql;
    private boolean bulkOutputFormat = false;
    private String bulkCfSchema;
    private String bulkInsertStatement;
    private String bulkOutputLocation;
    private int bulkBuffSize = -1;
    private int bulkStreamThrottle = -1;
    private int bulkMaxFailedHosts = -1;
    private boolean bulkDeleteSourceOnSuccess = true;
    private String bulkTableAlias;

    public CqlNativeStorage() {
        this(1000);
    }

    public CqlNativeStorage(int pageSize) {
        this.pageSize = pageSize;
        this.DEFAULT_INPUT_FORMAT = "org.apache.cassandra.hadoop.cql3.CqlInputFormat";
        this.DEFAULT_OUTPUT_FORMAT = "org.apache.cassandra.hadoop.cql3.CqlOutputFormat";
    }

    public void prepareToRead(RecordReader reader, PigSplit split) {
        this.reader = reader;
        if (reader instanceof CqlRecordReader) {
            this.nativeProtocolVersion = ((CqlRecordReader)reader).getNativeProtocolVersion();
        }
    }

    public void prepareToWrite(RecordWriter writer) {
        this.writer = writer;
    }

    public Tuple getNext() throws IOException {
        try {
            if (!this.reader.nextKeyValue()) {
                return null;
            }
            TableInfo tableMetadata = this.getCfInfo(this.loadSignature);
            Row row = (Row)this.reader.getCurrentValue();
            Tuple tuple = TupleFactory.getInstance().newTuple(tableMetadata.getColumns().size());
            Iterator<ColumnInfo> itera = tableMetadata.getColumns().iterator();
            int i = 0;
            while (itera.hasNext()) {
                ColumnInfo cdef = itera.next();
                ByteBuffer columnValue = row.getBytesUnsafe(cdef.getName());
                if (columnValue != null) {
                    AbstractType validator = this.getValidatorMap(tableMetadata).get(ByteBufferUtil.bytes(cdef.getName()));
                    this.setTupleValue(tuple, i, this.cqlColumnToObj(ByteBufferUtil.bytes(cdef.getName()), columnValue, tableMetadata), validator);
                } else {
                    tuple.set(i, null);
                }
                ++i;
            }
            return tuple;
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
    }

    private Object cqlColumnToObj(ByteBuffer name, ByteBuffer columnValue, TableInfo cfDef) throws IOException {
        Map<ByteBuffer, AbstractType> validators = this.getValidatorMap(cfDef);
        return StorageHelper.cassandraToObj(validators.get(name), columnValue, this.nativeProtocolVersion);
    }

    private void setTupleValue(Tuple tuple, int position, Object value, AbstractType<?> validator) throws ExecException {
        if (validator instanceof CollectionType) {
            this.setCollectionTupleValues(tuple, position, value, validator);
        } else {
            StorageHelper.setTupleValue(tuple, position, value);
        }
    }

    private void setCollectionTupleValues(Tuple tuple, int position, Object value, AbstractType<?> validator) throws ExecException {
        AbstractType elementValidator;
        if (validator instanceof MapType) {
            this.setMapTupleValues(tuple, position, value, validator);
            return;
        }
        if (validator instanceof SetType) {
            elementValidator = ((SetType)validator).getElementsType();
        } else if (validator instanceof ListType) {
            elementValidator = ((ListType)validator).getElementsType();
        } else {
            return;
        }
        int i = 0;
        Tuple innerTuple = TupleFactory.getInstance().newTuple(((Collection)value).size());
        for (Object entry : (Collection)value) {
            this.setTupleValue(innerTuple, i, this.cassandraToPigData(entry, elementValidator), elementValidator);
            ++i;
        }
        tuple.set(position, (Object)innerTuple);
    }

    private void setMapTupleValues(Tuple tuple, int position, Object value, AbstractType<?> validator) throws ExecException {
        AbstractType keyValidator = ((MapType)validator).getKeysType();
        AbstractType valueValidator = ((MapType)validator).getValuesType();
        int i = 0;
        Tuple innerTuple = TupleFactory.getInstance().newTuple(((Map)value).size());
        for (Map.Entry entry : ((Map)value).entrySet()) {
            Tuple mapEntryTuple = TupleFactory.getInstance().newTuple(2);
            this.setTupleValue(mapEntryTuple, 0, this.cassandraToPigData(entry.getKey(), keyValidator), keyValidator);
            this.setTupleValue(mapEntryTuple, 1, this.cassandraToPigData(entry.getValue(), valueValidator), valueValidator);
            innerTuple.set(i, (Object)mapEntryTuple);
            ++i;
        }
        tuple.set(position, (Object)innerTuple);
    }

    private Object cassandraToPigData(Object obj, AbstractType validator) {
        if (validator instanceof DecimalType || validator instanceof InetAddressType) {
            return validator.getString(validator.decompose(obj));
        }
        return obj;
    }

    protected TableInfo getCfInfo(String signature) throws IOException {
        TableInfo cfInfo;
        UDFContext context = UDFContext.getUDFContext();
        Properties property = context.getUDFProperties(CqlNativeStorage.class);
        try {
            cfInfo = CqlNativeStorage.cfdefFromString(property.getProperty(signature));
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        return cfInfo;
    }

    protected TableMetadata getCfInfo(Session client) throws NoHostAvailableException, AuthenticationException, IllegalStateException {
        return client.getCluster().getMetadata().getKeyspace(Metadata.quote((String)this.keyspace)).getTable(Metadata.quote((String)this.column_family));
    }

    private Map<String, ByteBuffer> tupleToKeyMap(Tuple t) throws IOException {
        HashMap<String, ByteBuffer> keys = new HashMap<String, ByteBuffer>();
        for (int i = 0; i < t.size(); ++i) {
            if (t.getType(i) != 110) {
                throw new IOException("keys was not a tuple");
            }
            Tuple inner = (Tuple)t.get(i);
            if (inner.size() != 2) {
                throw new IOException("Keys were not in name and value pairs");
            }
            Object name = inner.get(0);
            if (name == null) {
                throw new IOException("Key name was empty");
            }
            keys.put(name.toString(), this.objToBB(inner.get(1)));
        }
        return keys;
    }

    protected ByteBuffer objToBB(Object o) {
        if (o == null) {
            return this.nullToBB();
        }
        if (o instanceof String) {
            return ByteBuffer.wrap(new DataByteArray((String)o).get());
        }
        if (o instanceof Integer) {
            return Int32Type.instance.decompose((Integer)o);
        }
        if (o instanceof Long) {
            return LongType.instance.decompose((Long)o);
        }
        if (o instanceof Float) {
            return FloatType.instance.decompose((Float)o);
        }
        if (o instanceof Double) {
            return DoubleType.instance.decompose((Double)o);
        }
        if (o instanceof UUID) {
            return ByteBuffer.wrap(UUIDGen.decompose((UUID)o));
        }
        if (o instanceof Tuple) {
            List objects = ((Tuple)o).getAll();
            if (objects.size() > 0 && objects.get(0) instanceof String) {
                String collectionType = (String)objects.get(0);
                if ("set".equalsIgnoreCase(collectionType) || "list".equalsIgnoreCase(collectionType)) {
                    return this.objToListOrSetBB(objects.subList(1, objects.size()));
                }
                if ("map".equalsIgnoreCase(collectionType)) {
                    return this.objToMapBB(objects.subList(1, objects.size()));
                }
            }
            return this.objToCompositeBB(objects);
        }
        return ByteBuffer.wrap(((DataByteArray)o).get());
    }

    private ByteBuffer objToListOrSetBB(List<Object> objects) {
        ArrayList<ByteBuffer> serialized = new ArrayList<ByteBuffer>(objects.size());
        for (Object sub : objects) {
            ByteBuffer buffer = this.objToBB(sub);
            serialized.add(buffer);
        }
        return CollectionSerializer.pack(serialized, objects.size(), 3);
    }

    private ByteBuffer objToMapBB(List<Object> objects) {
        ArrayList<ByteBuffer> serialized = new ArrayList<ByteBuffer>(objects.size() * 2);
        for (Object sub : objects) {
            List keyValue = ((Tuple)sub).getAll();
            for (Object entry : keyValue) {
                ByteBuffer buffer = this.objToBB(entry);
                serialized.add(buffer);
            }
        }
        return CollectionSerializer.pack(serialized, objects.size(), 3);
    }

    private ByteBuffer objToCompositeBB(List<Object> objects) {
        ArrayList<ByteBuffer> serialized = new ArrayList<ByteBuffer>(objects.size());
        int totalLength = 0;
        for (Object sub : objects) {
            ByteBuffer buffer = this.objToBB(sub);
            serialized.add(buffer);
            totalLength += 2 + buffer.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        for (ByteBuffer bb : serialized) {
            int length = bb.remaining();
            out.put((byte)(length >> 8 & 0xFF));
            out.put((byte)(length & 0xFF));
            out.put(bb);
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    private void cqlQueryFromTuple(Map<String, ByteBuffer> key, Tuple t, int offset) throws IOException {
        for (int i = offset; i < t.size(); ++i) {
            if (t.getType(i) != 110) {
                throw new IOException("Output type was not a tuple");
            }
            Tuple inner = (Tuple)t.get(i);
            if (inner.size() <= 0) continue;
            List<ByteBuffer> bindedVariables = this.bindedVariablesFromTuple(inner);
            if (bindedVariables.size() <= 0) {
                throw new IOException("Missing binded variables");
            }
            this.sendCqlQuery(key, bindedVariables);
        }
    }

    private List<ByteBuffer> bindedVariablesFromTuple(Tuple t) throws IOException {
        ArrayList<ByteBuffer> variables = new ArrayList<ByteBuffer>();
        for (int i = 0; i < t.size(); ++i) {
            variables.add(this.objToBB(t.get(i)));
        }
        return variables;
    }

    private void sendCqlQuery(Map<String, ByteBuffer> key, List<ByteBuffer> bindedVariables) throws IOException {
        try {
            this.writer.write(key, bindedVariables);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    protected Map<ByteBuffer, AbstractType> getValidatorMap(TableInfo cfDef) throws IOException {
        HashMap<ByteBuffer, AbstractType> validators = new HashMap<ByteBuffer, AbstractType>();
        for (ColumnInfo cd : cfDef.getColumns()) {
            if (cd.getTypeName() == null) continue;
            try {
                LongType validator = TypeParser.parseCqlName(cd.getTypeName());
                if (validator instanceof CounterColumnType) {
                    validator = LongType.instance;
                }
                validators.put(ByteBufferUtil.bytes(cd.getName()), validator);
            }
            catch (ConfigurationException | SyntaxException e) {
                throw new IOException(e);
            }
        }
        return validators;
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        this.setLocation(location, job);
        TableInfo cfInfo = this.getCfInfo(this.loadSignature);
        ResourceSchema schema = new ResourceSchema();
        Map<ByteBuffer, AbstractType> validators = this.getValidatorMap(cfInfo);
        ArrayList<ResourceSchema.ResourceFieldSchema> allSchemaFields = new ArrayList<ResourceSchema.ResourceFieldSchema>();
        for (ColumnInfo cdef : cfInfo.getColumns()) {
            ResourceSchema.ResourceFieldSchema valSchema = new ResourceSchema.ResourceFieldSchema();
            AbstractType validator = validators.get(ByteBufferUtil.bytes(cdef.getName()));
            valSchema.setName(cdef.getName());
            valSchema.setType(StorageHelper.getPigType(validator));
            allSchemaFields.add(valSchema);
        }
        schema.setFields(allSchemaFields.toArray(new ResourceSchema.ResourceFieldSchema[allSchemaFields.size()]));
        return schema;
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
        UDFContext context = UDFContext.getUDFContext();
        Properties property = context.getUDFProperties(CqlNativeStorage.class);
        property.setProperty("cassandra.partition.filter", this.partitionFilterToWhereClauseString(partitionFilter));
    }

    private String partitionFilterToWhereClauseString(Expression expression) throws IOException {
        Expression.BinaryExpression be = (Expression.BinaryExpression)expression;
        Expression.OpType op = expression.getOpType();
        String opString = op.toString();
        switch (op) {
            case OP_EQ: {
                opString = " = ";
            }
            case OP_GE: 
            case OP_GT: 
            case OP_LE: 
            case OP_LT: {
                String name = be.getLhs().toString();
                String value = be.getRhs().toString();
                return String.format("%s %s %s", name, opString, value);
            }
            case OP_AND: {
                return String.format("%s AND %s", this.partitionFilterToWhereClauseString(be.getLhs()), this.partitionFilterToWhereClauseString(be.getRhs()));
            }
        }
        throw new IOException("Unsupported expression type: " + opString);
    }

    private String getWhereClauseForPartitionFilter() {
        UDFContext context = UDFContext.getUDFContext();
        Properties property = context.getUDFProperties(CqlNativeStorage.class);
        return property.getProperty("cassandra.partition.filter");
    }

    public void putNext(Tuple t) throws IOException {
        if (t.size() < 1) {
            logger.warn("Empty output skipped, filter empty tuples to suppress this warning");
            return;
        }
        if (t.getType(0) != 110) {
            throw new IOException("First argument in output must be a tuple");
        }
        if (!this.bulkOutputFormat && t.getType(1) != 110) {
            throw new IOException("Second argument in output must be a tuple");
        }
        if (this.bulkOutputFormat) {
            this.cqlQueryFromTuple(null, t, 0);
        } else {
            Map<String, ByteBuffer> key = this.tupleToKeyMap((Tuple)t.get(0));
            this.cqlQueryFromTuple(key, t, 1);
        }
    }

    public void setLocation(String location, Job job) throws IOException {
        String wc;
        this.conf = job.getConfiguration();
        this.setLocationFromUri(location);
        if (this.username != null && this.password != null) {
            ConfigHelper.setInputKeyspaceUserNameAndPassword(this.conf, this.username, this.password);
            CqlConfigHelper.setUserNameAndPassword(this.conf, this.username, this.password);
        }
        if (this.splitSize > 0) {
            ConfigHelper.setInputSplitSize(this.conf, this.splitSize);
        }
        if (this.partitionerClass != null) {
            ConfigHelper.setInputPartitioner(this.conf, this.partitionerClass);
        }
        if (this.initHostAddress != null) {
            ConfigHelper.setInputInitialAddress(this.conf, this.initHostAddress);
        }
        if (this.rpcPort != null) {
            ConfigHelper.setInputRpcPort(this.conf, this.rpcPort);
        }
        if (this.nativePort != null) {
            CqlConfigHelper.setInputNativePort(this.conf, this.nativePort);
        }
        if (this.nativeCoreConnections != null) {
            CqlConfigHelper.setInputCoreConnections(this.conf, this.nativeCoreConnections);
        }
        if (this.nativeMaxConnections != null) {
            CqlConfigHelper.setInputMaxConnections(this.conf, this.nativeMaxConnections);
        }
        if (this.nativeMaxSimultReqs != null) {
            CqlConfigHelper.setInputMaxSimultReqPerConnections(this.conf, this.nativeMaxSimultReqs);
        }
        if (this.nativeConnectionTimeout != null) {
            CqlConfigHelper.setInputNativeConnectionTimeout(this.conf, this.nativeConnectionTimeout);
        }
        if (this.nativeReadConnectionTimeout != null) {
            CqlConfigHelper.setInputNativeReadConnectionTimeout(this.conf, this.nativeReadConnectionTimeout);
        }
        if (this.nativeReceiveBufferSize != null) {
            CqlConfigHelper.setInputNativeReceiveBufferSize(this.conf, this.nativeReceiveBufferSize);
        }
        if (this.nativeSendBufferSize != null) {
            CqlConfigHelper.setInputNativeSendBufferSize(this.conf, this.nativeSendBufferSize);
        }
        if (this.nativeSolinger != null) {
            CqlConfigHelper.setInputNativeSolinger(this.conf, this.nativeSolinger);
        }
        if (this.nativeTcpNodelay != null) {
            CqlConfigHelper.setInputNativeTcpNodelay(this.conf, this.nativeTcpNodelay);
        }
        if (this.nativeReuseAddress != null) {
            CqlConfigHelper.setInputNativeReuseAddress(this.conf, this.nativeReuseAddress);
        }
        if (this.nativeKeepAlive != null) {
            CqlConfigHelper.setInputNativeKeepAlive(this.conf, this.nativeKeepAlive);
        }
        if (this.nativeAuthProvider != null) {
            CqlConfigHelper.setInputNativeAuthProvider(this.conf, this.nativeAuthProvider);
        }
        if (this.nativeSSLTruststorePath != null) {
            CqlConfigHelper.setInputNativeSSLTruststorePath(this.conf, this.nativeSSLTruststorePath);
        }
        if (this.nativeSSLKeystorePath != null) {
            CqlConfigHelper.setInputNativeSSLKeystorePath(this.conf, this.nativeSSLKeystorePath);
        }
        if (this.nativeSSLTruststorePassword != null) {
            CqlConfigHelper.setInputNativeSSLTruststorePassword(this.conf, this.nativeSSLTruststorePassword);
        }
        if (this.nativeSSLKeystorePassword != null) {
            CqlConfigHelper.setInputNativeSSLKeystorePassword(this.conf, this.nativeSSLKeystorePassword);
        }
        if (this.nativeSSLCipherSuites != null) {
            CqlConfigHelper.setInputNativeSSLCipherSuites(this.conf, this.nativeSSLCipherSuites);
        }
        ConfigHelper.setInputColumnFamily(this.conf, this.keyspace, this.column_family);
        this.setConnectionInformation();
        CqlConfigHelper.setInputCQLPageRowSize(this.conf, String.valueOf(this.pageSize));
        if (this.inputCql != null) {
            CqlConfigHelper.setInputCql(this.conf, this.inputCql);
        }
        if (this.columns != null) {
            CqlConfigHelper.setInputColumns(this.conf, this.columns);
        }
        if (this.whereClause != null) {
            CqlConfigHelper.setInputWhereClauses(this.conf, this.whereClause);
        }
        String whereClauseForPartitionFilter = this.getWhereClauseForPartitionFilter();
        String string = this.whereClause != null && !this.whereClause.trim().isEmpty() ? (whereClauseForPartitionFilter == null ? this.whereClause : String.format("%s AND %s", this.whereClause.trim(), whereClauseForPartitionFilter)) : (wc = whereClauseForPartitionFilter);
        if (wc != null) {
            logger.trace("where clause: {}", (Object)wc);
            CqlConfigHelper.setInputWhereClauses(this.conf, wc);
        }
        if (System.getenv("PIG_INPUT_SPLIT_SIZE") != null) {
            try {
                ConfigHelper.setInputSplitSize(this.conf, Integer.parseInt(System.getenv("PIG_INPUT_SPLIT_SIZE")));
            }
            catch (NumberFormatException e) {
                throw new IOException("PIG_INPUT_SPLIT_SIZE is not a number", e);
            }
        }
        if (ConfigHelper.getInputInitialAddress(this.conf) == null) {
            throw new IOException("PIG_INPUT_INITIAL_ADDRESS or PIG_INITIAL_ADDRESS environment variable not set");
        }
        if (ConfigHelper.getInputPartitioner(this.conf) == null) {
            throw new IOException("PIG_INPUT_PARTITIONER or PIG_PARTITIONER environment variable not set");
        }
        if (this.loadSignature == null) {
            this.loadSignature = location;
        }
        this.initSchema(this.loadSignature);
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        this.conf = HadoopCompat.getConfiguration((JobContext)job);
        this.setLocationFromUri(location);
        if (this.username != null && this.password != null) {
            ConfigHelper.setOutputKeyspaceUserNameAndPassword(this.conf, this.username, this.password);
        }
        if (this.splitSize > 0) {
            ConfigHelper.setInputSplitSize(this.conf, this.splitSize);
        }
        if (this.partitionerClass != null) {
            ConfigHelper.setOutputPartitioner(this.conf, this.partitionerClass);
        }
        if (this.rpcPort != null) {
            ConfigHelper.setOutputRpcPort(this.conf, this.rpcPort);
            ConfigHelper.setInputRpcPort(this.conf, this.rpcPort);
        }
        if (this.initHostAddress != null) {
            ConfigHelper.setOutputInitialAddress(this.conf, this.initHostAddress);
            ConfigHelper.setInputInitialAddress(this.conf, this.initHostAddress);
        }
        ConfigHelper.setOutputColumnFamily(this.conf, this.keyspace, this.column_family);
        CqlConfigHelper.setOutputCql(this.conf, this.outputQuery);
        if (this.bulkOutputFormat) {
            this.DEFAULT_OUTPUT_FORMAT = BULK_OUTPUT_FORMAT;
            if (this.bulkCfSchema == null) {
                throw new IOException("bulk_cf_schema is missing in input url parameter");
            }
            CqlBulkOutputFormat.setTableSchema(this.conf, this.column_family, this.bulkCfSchema);
            if (this.bulkInsertStatement == null) {
                throw new IOException("bulk_insert_statement is missing in input url parameter");
            }
            CqlBulkOutputFormat.setTableInsertStatement(this.conf, this.column_family, this.bulkInsertStatement);
            if (this.bulkTableAlias != null) {
                CqlBulkOutputFormat.setTableAlias(this.conf, this.bulkTableAlias, this.column_family);
            }
            CqlBulkOutputFormat.setDeleteSourceOnSuccess(this.conf, this.bulkDeleteSourceOnSuccess);
            if (this.bulkOutputLocation != null) {
                this.conf.set("mapreduce.output.bulkoutputformat.localdir", this.bulkOutputLocation);
            }
            if (this.bulkBuffSize > 0) {
                this.conf.set("mapreduce.output.bulkoutputformat.buffersize", String.valueOf(this.bulkBuffSize));
            }
            if (this.bulkStreamThrottle > 0) {
                this.conf.set("mapreduce.output.bulkoutputformat.streamthrottlembits", String.valueOf(this.bulkStreamThrottle));
            }
            if (this.bulkMaxFailedHosts > 0) {
                this.conf.set("mapreduce.output.bulkoutputformat.maxfailedhosts", String.valueOf(this.bulkMaxFailedHosts));
            }
            if (this.partitionerClass != null) {
                ConfigHelper.setInputPartitioner(this.conf, this.partitionerClass);
            }
        }
        this.setConnectionInformation();
        if (ConfigHelper.getOutputRpcPort(this.conf) == 0) {
            throw new IOException("PIG_OUTPUT_RPC_PORT or PIG_RPC_PORT environment variable not set");
        }
        if (ConfigHelper.getOutputInitialAddress(this.conf) == null) {
            throw new IOException("PIG_OUTPUT_INITIAL_ADDRESS or PIG_INITIAL_ADDRESS environment variable not set");
        }
        if (ConfigHelper.getOutputPartitioner(this.conf) == null) {
            throw new IOException("PIG_OUTPUT_PARTITIONER or PIG_PARTITIONER environment variable not set");
        }
        this.initSchema(this.storeSignature);
    }

    protected void initSchema(String signature) throws IOException {
        block16: {
            Properties properties = UDFContext.getUDFContext().getUDFProperties(CqlNativeStorage.class);
            if (!properties.containsKey(signature)) {
                try (Session client = CqlConfigHelper.getInputCluster(ConfigHelper.getInputInitialAddress(this.conf), this.conf).connect();){
                    client.execute("USE " + this.keyspace);
                    TableMetadata cfInfo = this.getCfInfo(client);
                    if (cfInfo != null) {
                        properties.setProperty(signature, CqlNativeStorage.cfdefToString(cfInfo));
                        break block16;
                    }
                    throw new IOException(String.format("Table '%s' not found in keyspace '%s'", this.column_family, this.keyspace));
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
    }

    protected static String cfdefToString(TableMetadata cfDef) throws IOException {
        TableInfo tableInfo = new TableInfo(cfDef);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(tableInfo);
        }
        return new String(Base64Coder.encode((byte[])baos.toByteArray()));
    }

    protected static TableInfo cfdefFromString(String st) throws IOException, ClassNotFoundException {
        byte[] data = Base64Coder.decode((String)st);
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));){
            Object o = ois.readObject();
            TableInfo tableInfo = (TableInfo)o;
            return tableInfo;
        }
    }

    public static Map<String, String> getQueryMap(String query) throws UnsupportedEncodingException {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>(params.length);
        for (String param : params) {
            String[] keyValue = param.split("=");
            map.put(keyValue[0], URLDecoder.decode(keyValue[1], "UTF-8"));
        }
        return map;
    }

    private void setLocationFromUri(String location) throws IOException {
        try {
            String[] parts;
            String[] credentialsAndKeyspace;
            if (!location.startsWith("cql://")) {
                throw new Exception("Bad scheme: " + location);
            }
            String[] urlParts = location.split("\\?");
            if (urlParts.length > 1) {
                Map<String, String> urlQuery = CqlNativeStorage.getQueryMap(urlParts[1]);
                if (urlQuery.containsKey("page_size")) {
                    this.pageSize = Integer.parseInt(urlQuery.get("page_size"));
                }
                if (urlQuery.containsKey("output_query")) {
                    this.outputQuery = urlQuery.get("output_query");
                }
                if (urlQuery.containsKey("bulk_output_format")) {
                    this.bulkOutputFormat = Boolean.valueOf(urlQuery.get("bulk_output_format"));
                }
                if (urlQuery.containsKey("bulk_cf_schema")) {
                    this.bulkCfSchema = urlQuery.get("bulk_cf_schema");
                }
                if (urlQuery.containsKey("bulk_insert_statement")) {
                    this.bulkInsertStatement = urlQuery.get("bulk_insert_statement");
                }
                if (urlQuery.containsKey("bulk_output_location")) {
                    this.bulkOutputLocation = urlQuery.get("bulk_output_location");
                }
                if (urlQuery.containsKey("bulk_buff_size")) {
                    this.bulkBuffSize = Integer.valueOf(urlQuery.get("bulk_buff_size"));
                }
                if (urlQuery.containsKey("bulk_stream_throttle")) {
                    this.bulkStreamThrottle = Integer.valueOf(urlQuery.get("bulk_stream_throttle"));
                }
                if (urlQuery.containsKey("bulk_max_failed_hosts")) {
                    this.bulkMaxFailedHosts = Integer.valueOf(urlQuery.get("bulk_max_failed_hosts"));
                }
                if (urlQuery.containsKey("bulk_delete_source")) {
                    this.bulkDeleteSourceOnSuccess = Boolean.parseBoolean(urlQuery.get("bulk_delete_source"));
                }
                if (urlQuery.containsKey("bulk_table_alias")) {
                    this.bulkTableAlias = urlQuery.get("bulk_table_alias");
                }
                if (urlQuery.containsKey("split_size")) {
                    this.splitSize = Integer.parseInt(urlQuery.get("split_size"));
                }
                if (urlQuery.containsKey("partitioner")) {
                    this.partitionerClass = urlQuery.get("partitioner");
                }
                if (urlQuery.containsKey("use_secondary")) {
                    this.usePartitionFilter = Boolean.parseBoolean(urlQuery.get("use_secondary"));
                }
                if (urlQuery.containsKey("init_address")) {
                    this.initHostAddress = urlQuery.get("init_address");
                }
                if (urlQuery.containsKey("native_port")) {
                    this.nativePort = urlQuery.get("native_port");
                }
                if (urlQuery.containsKey("core_conns")) {
                    this.nativeCoreConnections = urlQuery.get("core_conns");
                }
                if (urlQuery.containsKey("max_conns")) {
                    this.nativeMaxConnections = urlQuery.get("max_conns");
                }
                if (urlQuery.containsKey("max_simult_reqs")) {
                    this.nativeMaxSimultReqs = urlQuery.get("max_simult_reqs");
                }
                if (urlQuery.containsKey("native_timeout")) {
                    this.nativeConnectionTimeout = urlQuery.get("native_timeout");
                }
                if (urlQuery.containsKey("native_read_timeout")) {
                    this.nativeReadConnectionTimeout = urlQuery.get("native_read_timeout");
                }
                if (urlQuery.containsKey("rec_buff_size")) {
                    this.nativeReceiveBufferSize = urlQuery.get("rec_buff_size");
                }
                if (urlQuery.containsKey("send_buff_size")) {
                    this.nativeSendBufferSize = urlQuery.get("send_buff_size");
                }
                if (urlQuery.containsKey("solinger")) {
                    this.nativeSolinger = urlQuery.get("solinger");
                }
                if (urlQuery.containsKey("tcp_nodelay")) {
                    this.nativeTcpNodelay = urlQuery.get("tcp_nodelay");
                }
                if (urlQuery.containsKey("reuse_address")) {
                    this.nativeReuseAddress = urlQuery.get("reuse_address");
                }
                if (urlQuery.containsKey("keep_alive")) {
                    this.nativeKeepAlive = urlQuery.get("keep_alive");
                }
                if (urlQuery.containsKey("auth_provider")) {
                    this.nativeAuthProvider = urlQuery.get("auth_provider");
                }
                if (urlQuery.containsKey("trust_store_path")) {
                    this.nativeSSLTruststorePath = urlQuery.get("trust_store_path");
                }
                if (urlQuery.containsKey("key_store_path")) {
                    this.nativeSSLKeystorePath = urlQuery.get("key_store_path");
                }
                if (urlQuery.containsKey("trust_store_password")) {
                    this.nativeSSLTruststorePassword = urlQuery.get("trust_store_password");
                }
                if (urlQuery.containsKey("key_store_password")) {
                    this.nativeSSLKeystorePassword = urlQuery.get("key_store_password");
                }
                if (urlQuery.containsKey("cipher_suites")) {
                    this.nativeSSLCipherSuites = urlQuery.get("cipher_suites");
                }
                if (urlQuery.containsKey("input_cql")) {
                    this.inputCql = urlQuery.get("input_cql");
                }
                if (urlQuery.containsKey("columns")) {
                    this.columns = urlQuery.get("columns");
                }
                if (urlQuery.containsKey("where_clause")) {
                    this.whereClause = urlQuery.get("where_clause");
                }
                if (urlQuery.containsKey("rpc_port")) {
                    this.rpcPort = urlQuery.get("rpc_port");
                }
            }
            if ((credentialsAndKeyspace = (parts = urlParts[0].split("/+"))[1].split("@")).length > 1) {
                String[] credentials = credentialsAndKeyspace[0].split(":");
                this.username = credentials[0];
                this.password = credentials[1];
                this.keyspace = credentialsAndKeyspace[1];
            } else {
                this.keyspace = parts[1];
            }
            this.column_family = parts[2];
        }
        catch (Exception e) {
            throw new IOException("Expected 'cql://[username:password@]<keyspace>/<columnfamily>[?[page_size=<size>][&columns=<col1,col2>][&output_query=<prepared_statement>][&where_clause=<clause>][&split_size=<size>][&partitioner=<partitioner>][&use_secondary=true|false][&init_address=<host>][&native_port=<native_port>][&core_conns=<core_conns>][&max_conns=<max_conns>][&min_simult_reqs=<min_simult_reqs>][&max_simult_reqs=<max_simult_reqs>][&native_timeout=<native_timeout>][&native_read_timeout=<native_read_timeout>][&rec_buff_size=<rec_buff_size>][&send_buff_size=<send_buff_size>][&solinger=<solinger>][&tcp_nodelay=<tcp_nodelay>][&reuse_address=<reuse_address>][&keep_alive=<keep_alive>][&auth_provider=<auth_provider>][&trust_store_path=<trust_store_path>][&key_store_path=<key_store_path>][&trust_store_password=<trust_store_password>][&key_store_password=<key_store_password>][&cipher_suites=<cipher_suites>][&input_cql=<input_cql>][columns=<columns>][where_clause=<where_clause>][&bulk_cf_schema=bulk_cf_schema][&bulk_insert_statement=bulk_insert_statement][&bulk_table_alias=<bulk_table_alias>][&bulk_output_location=<bulk_output_location>][&bulk_buff_size=<bulk_buff_size>][&bulk_delete_source=<bulk_delete_source>][&bulk_stream_throttle=<bulk_stream_throttle>][&bulk_max_failed_hosts=<bulk_max_failed_hosts>]]': " + e.getMessage());
        }
    }

    public ByteBuffer nullToBB() {
        return ByteBuffer.wrap(new byte[0]);
    }

    public OutputFormat getOutputFormat() throws IOException {
        try {
            return (OutputFormat)FBUtilities.construct(this.outputFormatClass, "outputformat");
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
    }

    public void cleanupOnFailure(String failure, Job job) {
    }

    public void cleanupOnSuccess(String location, Job job) throws IOException {
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        if (!this.usePartitionFilter) {
            return null;
        }
        TableInfo tableMetadata = this.getCfInfo(this.loadSignature);
        String[] partitionKeys = new String[tableMetadata.getPartitionKey().size()];
        for (int i = 0; i < tableMetadata.getPartitionKey().size(); ++i) {
            partitionKeys[i] = tableMetadata.getPartitionKey().get(i).getName();
        }
        return partitionKeys;
    }

    public void checkSchema(ResourceSchema schema) throws IOException {
    }

    public ResourceStatistics getStatistics(String location, Job job) {
        return null;
    }

    public InputFormat getInputFormat() throws IOException {
        try {
            return (InputFormat)FBUtilities.construct(this.inputFormatClass, "inputformat");
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return this.relativeToAbsolutePath(location, curDir);
    }

    public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
        return location;
    }

    public void setUDFContextSignature(String signature) {
        this.loadSignature = signature;
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.storeSignature = signature;
    }

    protected void setConnectionInformation() throws IOException {
        StorageHelper.setConnectionInformation(this.conf);
        this.inputFormatClass = System.getenv("PIG_INPUT_FORMAT") != null ? this.getFullyQualifiedClassName(System.getenv("PIG_INPUT_FORMAT")) : this.DEFAULT_INPUT_FORMAT;
        this.outputFormatClass = System.getenv("PIG_OUTPUT_FORMAT") != null ? this.getFullyQualifiedClassName(System.getenv("PIG_OUTPUT_FORMAT")) : this.DEFAULT_OUTPUT_FORMAT;
    }

    protected String getFullyQualifiedClassName(String classname) {
        return classname.contains(".") ? classname : "org.apache.cassandra.hadoop." + classname;
    }
}

