/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsFailedSnapshotTracker {
    private static final Logger logger = LoggerFactory.getLogger(WindowsFailedSnapshotTracker.class);
    private static PrintWriter _failedSnapshotFile;
    @VisibleForTesting
    public static final String TODELETEFILE;

    public static void deleteOldSnapshots() {
        if (new File(TODELETEFILE).exists()) {
            try {
                String snapshotDirectory;
                BufferedReader reader = new BufferedReader(new FileReader(TODELETEFILE));
                while ((snapshotDirectory = reader.readLine()) != null) {
                    File f = new File(snapshotDirectory);
                    boolean validFolder = FileUtils.isSubDirectory(new File(System.getenv("TEMP")), f);
                    for (String s : DatabaseDescriptor.getAllDataFileLocations()) {
                        validFolder |= FileUtils.isSubDirectory(new File(s), f);
                    }
                    if (!validFolder) {
                        logger.warn("Skipping invalid directory found in .toDelete: {}. Only %TEMP% or data file subdirectories are valid.", (Object)f);
                        continue;
                    }
                    if (!f.exists()) continue;
                    logger.warn("Discovered obsolete snapshot. Deleting directory [{}]", (Object)snapshotDirectory);
                    FileUtils.deleteRecursive(new File(snapshotDirectory));
                }
                reader.close();
                Files.delete(Paths.get(TODELETEFILE, new String[0]));
            }
            catch (IOException e) {
                logger.warn("Failed to open {}. Obsolete snapshots from previous runs will not be deleted.", (Object)TODELETEFILE);
                logger.warn("Exception: " + e);
            }
        }
        try {
            _failedSnapshotFile = new PrintWriter(new FileWriter(TODELETEFILE, true));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to create failed snapshot tracking file [%s]. Aborting", TODELETEFILE));
        }
    }

    public static synchronized void handleFailedSnapshot(File dir) {
        assert (_failedSnapshotFile != null) : "_failedSnapshotFile not initialized within WindowsFailedSnapshotTracker";
        FileUtils.deleteRecursiveOnExit(dir);
        _failedSnapshotFile.println(dir.toString());
        _failedSnapshotFile.flush();
    }

    @VisibleForTesting
    public static void resetForTests() {
        _failedSnapshotFile.close();
    }

    static {
        TODELETEFILE = System.getenv("CASSANDRA_HOME") == null ? ".toDelete" : System.getenv("CASSANDRA_HOME") + File.separator + ".toDelete";
    }
}

