/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.progress.jmx;

import com.google.common.base.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.utils.progress.ProgressEvent;
import org.apache.cassandra.utils.progress.ProgressListener;

public class LegacyJMXProgressSupport
implements ProgressListener {
    protected static final Pattern SESSION_FAILED_MATCHER = Pattern.compile("Repair session .* for range .* failed with error .*");
    protected static final Pattern SESSION_SUCCESS_MATCHER = Pattern.compile("Repair session .* for range .* finished");
    private final AtomicLong notificationSerialNumber = new AtomicLong();
    private final String jmxObjectName;
    private final NotificationBroadcasterSupport broadcaster;

    public LegacyJMXProgressSupport(NotificationBroadcasterSupport broadcaster, String jmxObjectName) {
        this.broadcaster = broadcaster;
        this.jmxObjectName = jmxObjectName;
    }

    @Override
    public void progress(String tag, ProgressEvent event) {
        Optional<int[]> legacyUserData;
        if (tag.startsWith("repair:") && (legacyUserData = LegacyJMXProgressSupport.getLegacyUserdata(tag, event)).isPresent()) {
            Notification jmxNotification = new Notification("repair", (Object)this.jmxObjectName, this.notificationSerialNumber.incrementAndGet(), event.getMessage());
            jmxNotification.setUserData(legacyUserData.get());
            this.broadcaster.sendNotification(jmxNotification);
        }
    }

    protected static Optional<int[]> getLegacyUserdata(String tag, ProgressEvent event) {
        Optional<ActiveRepairService.Status> status = LegacyJMXProgressSupport.getStatus(event);
        if (status.isPresent()) {
            int[] result = new int[]{LegacyJMXProgressSupport.getCmd(tag), ((ActiveRepairService.Status)((Object)status.get())).ordinal()};
            return Optional.of((Object)result);
        }
        return Optional.absent();
    }

    protected static Optional<ActiveRepairService.Status> getStatus(ProgressEvent event) {
        switch (event.getType()) {
            case START: {
                return Optional.of((Object)((Object)ActiveRepairService.Status.STARTED));
            }
            case COMPLETE: {
                return Optional.of((Object)((Object)ActiveRepairService.Status.FINISHED));
            }
            case PROGRESS: {
                if (SESSION_FAILED_MATCHER.matcher(event.getMessage()).matches()) {
                    return Optional.of((Object)((Object)ActiveRepairService.Status.SESSION_FAILED));
                }
                if (!SESSION_SUCCESS_MATCHER.matcher(event.getMessage()).matches()) break;
                return Optional.of((Object)((Object)ActiveRepairService.Status.SESSION_SUCCESS));
            }
        }
        return Optional.absent();
    }

    protected static int getCmd(String tag) {
        return Integer.valueOf(tag.split(":")[1]);
    }
}

