/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutorMBean;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.metrics.ThreadPoolMetrics;
import org.apache.cassandra.utils.MBeanWrapper;

public class JMXEnabledThreadPoolExecutor
extends DebuggableThreadPoolExecutor
implements JMXEnabledThreadPoolExecutorMBean {
    private final String mbeanName;
    public final ThreadPoolMetrics metrics;

    public JMXEnabledThreadPoolExecutor(String threadPoolName) {
        this(1, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(threadPoolName), "internal");
    }

    public JMXEnabledThreadPoolExecutor(String threadPoolName, String jmxPath) {
        this(1, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(threadPoolName), jmxPath);
    }

    public JMXEnabledThreadPoolExecutor(String threadPoolName, int priority) {
        this(1, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(threadPoolName, priority), "internal");
    }

    public JMXEnabledThreadPoolExecutor(int corePoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, NamedThreadFactory threadFactory, String jmxPath) {
        this(corePoolSize, corePoolSize, keepAliveTime, unit, workQueue, threadFactory, jmxPath);
    }

    public JMXEnabledThreadPoolExecutor(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, NamedThreadFactory threadFactory, String jmxPath) {
        super(corePoolSize, maxPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        super.prestartAllCoreThreads();
        this.metrics = new ThreadPoolMetrics(this, jmxPath, threadFactory.id);
        this.mbeanName = "org.apache.cassandra." + jmxPath + ":type=" + threadFactory.id;
        MBeanWrapper.instance.registerMBean((Object)this, this.mbeanName);
    }

    public JMXEnabledThreadPoolExecutor(Stage stage) {
        this(stage.getJmxName(), stage.getJmxType());
    }

    private void unregisterMBean() {
        MBeanWrapper.instance.unregisterMBean(this.mbeanName);
        this.metrics.release();
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isShutdown()) {
            this.unregisterMBean();
        }
        super.shutdown();
    }

    @Override
    public synchronized List<Runnable> shutdownNow() {
        if (!this.isShutdown()) {
            this.unregisterMBean();
        }
        return super.shutdownNow();
    }

    public int getTotalBlockedTasks() {
        return (int)this.metrics.totalBlocked.getCount();
    }

    public int getCurrentlyBlockedTasks() {
        return (int)this.metrics.currentBlocked.getCount();
    }

    @Override
    public int getCoreThreads() {
        return this.getCorePoolSize();
    }

    @Override
    public void setCoreThreads(int number) {
        this.setCorePoolSize(number);
    }

    @Override
    public int getMaximumThreads() {
        return this.getMaximumPoolSize();
    }

    @Override
    public void setMaximumThreads(int number) {
        this.setMaximumPoolSize(number);
    }

    @Override
    protected void onInitialRejection(Runnable task) {
        this.metrics.totalBlocked.inc();
        this.metrics.currentBlocked.inc();
    }

    @Override
    protected void onFinalAccept(Runnable task) {
        this.metrics.currentBlocked.dec();
    }

    @Override
    protected void onFinalRejection(Runnable task) {
        this.metrics.currentBlocked.dec();
    }
}

