/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetriedSliceFromReadCommand
extends SliceFromReadCommand {
    static final Logger logger = LoggerFactory.getLogger(RetriedSliceFromReadCommand.class);
    public final int originalCount;

    public RetriedSliceFromReadCommand(String keyspaceName, ByteBuffer key, String cfName, long timestamp, SliceQueryFilter filter, int originalCount) {
        super(keyspaceName, key, cfName, timestamp, filter);
        this.originalCount = originalCount;
    }

    @Override
    public ReadCommand copy() {
        return new RetriedSliceFromReadCommand(this.ksName, this.key, this.cfName, this.timestamp, this.filter, this.originalCount).setIsDigestQuery(this.isDigestQuery());
    }

    @Override
    public int getOriginalRequestedCount() {
        return this.originalCount;
    }

    @Override
    public String toString() {
        return "RetriedSliceFromReadCommand(cmd=" + super.toString() + ", originalCount=" + this.originalCount + ")";
    }
}

