/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Json;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.transport.CBCodec;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.utils.Pair;

public abstract class QueryOptions {
    public static final QueryOptions DEFAULT = new DefaultQueryOptions(ConsistencyLevel.ONE, Collections.emptyList(), false, SpecificOptions.access$000(), 4);
    public static final CBCodec<QueryOptions> codec = new Codec();
    private List<Map<ColumnIdentifier, Term>> jsonValuesCache;

    public static QueryOptions fromProtocolV1(ConsistencyLevel consistency, List<ByteBuffer> values) {
        return new DefaultQueryOptions(consistency, values, false, SpecificOptions.DEFAULT, 1);
    }

    public static QueryOptions fromProtocolV2(ConsistencyLevel consistency, List<ByteBuffer> values) {
        return new DefaultQueryOptions(consistency, values, false, SpecificOptions.DEFAULT, 2);
    }

    public static QueryOptions forInternalCalls(ConsistencyLevel consistency, List<ByteBuffer> values) {
        return new DefaultQueryOptions(consistency, values, false, SpecificOptions.DEFAULT, 3);
    }

    public static QueryOptions forInternalCalls(List<ByteBuffer> values) {
        return new DefaultQueryOptions(ConsistencyLevel.ONE, values, false, SpecificOptions.DEFAULT, 3);
    }

    public static QueryOptions fromPreV3Batch(ConsistencyLevel consistency) {
        return new DefaultQueryOptions(consistency, Collections.emptyList(), false, SpecificOptions.DEFAULT, 2);
    }

    public static QueryOptions forProtocolVersion(int protocolVersion) {
        return new DefaultQueryOptions(null, null, true, null, protocolVersion);
    }

    public static QueryOptions create(ConsistencyLevel consistency, List<ByteBuffer> values, boolean skipMetadata, int pageSize, PagingState pagingState, ConsistencyLevel serialConsistency) {
        return QueryOptions.create(consistency, values, skipMetadata, pageSize, pagingState, serialConsistency, 0);
    }

    public static QueryOptions create(ConsistencyLevel consistency, List<ByteBuffer> values, boolean skipMetadata, int pageSize, PagingState pagingState, ConsistencyLevel serialConsistency, int protocolVersion) {
        return new DefaultQueryOptions(consistency, values, skipMetadata, new SpecificOptions(pageSize, pagingState, serialConsistency, -1L), protocolVersion);
    }

    public static QueryOptions addColumnSpecifications(QueryOptions options, List<ColumnSpecification> columnSpecs) {
        return new OptionsWithColumnSpecifications(options, columnSpecs);
    }

    public abstract ConsistencyLevel getConsistency();

    public abstract List<ByteBuffer> getValues();

    public abstract boolean skipMetadata();

    public Term getJsonColumnValue(int bindIndex, ColumnIdentifier columnName, Collection<ColumnDefinition> expectedReceivers) throws InvalidRequestException {
        Map<ColumnIdentifier, Term> jsonValue;
        if (this.jsonValuesCache == null) {
            this.jsonValuesCache = new ArrayList<Object>(Collections.nCopies(this.getValues().size(), null));
        }
        if ((jsonValue = this.jsonValuesCache.get(bindIndex)) == null) {
            ByteBuffer value = this.getValues().get(bindIndex);
            if (value == null) {
                throw new InvalidRequestException("Got null for INSERT JSON values");
            }
            jsonValue = Json.parseJson(UTF8Type.instance.getSerializer().deserialize(value), expectedReceivers);
            this.jsonValuesCache.set(bindIndex, jsonValue);
        }
        return jsonValue.get(columnName);
    }

    public boolean hasColumnSpecifications() {
        return false;
    }

    public ImmutableList<ColumnSpecification> getColumnSpecifications() {
        throw new UnsupportedOperationException();
    }

    public int getPageSize() {
        return this.getSpecificOptions().pageSize;
    }

    public PagingState getPagingState() {
        return this.getSpecificOptions().state;
    }

    public ConsistencyLevel getSerialConsistency() {
        return this.getSpecificOptions().serialConsistency;
    }

    public long getTimestamp(QueryState state) {
        long tstamp = this.getSpecificOptions().timestamp;
        return tstamp != Long.MIN_VALUE ? tstamp : state.getTimestamp();
    }

    public abstract int getProtocolVersion();

    abstract SpecificOptions getSpecificOptions();

    public QueryOptions prepare(List<ColumnSpecification> specs) {
        return this;
    }

    private static class Codec
    implements CBCodec<QueryOptions> {
        private Codec() {
        }

        @Override
        public QueryOptions decode(ByteBuf body, int version) {
            assert (version >= 2);
            ConsistencyLevel consistency = CBUtil.readConsistencyLevel(body);
            EnumSet<Flag> flags = Flag.deserialize(body.readByte());
            List values = Collections.emptyList();
            List names = null;
            if (flags.contains((Object)Flag.VALUES)) {
                if (flags.contains((Object)Flag.NAMES_FOR_VALUES)) {
                    Pair<List<String>, List<ByteBuffer>> namesAndValues = CBUtil.readNameAndValueList(body, version);
                    names = (List)namesAndValues.left;
                    values = (List)namesAndValues.right;
                } else {
                    values = CBUtil.readValueList(body, version);
                }
            }
            boolean skipMetadata = flags.contains((Object)Flag.SKIP_METADATA);
            flags.remove((Object)Flag.VALUES);
            flags.remove((Object)Flag.SKIP_METADATA);
            SpecificOptions options = SpecificOptions.DEFAULT;
            if (!flags.isEmpty()) {
                int pageSize = flags.contains((Object)Flag.PAGE_SIZE) ? body.readInt() : -1;
                PagingState pagingState = flags.contains((Object)Flag.PAGING_STATE) ? PagingState.deserialize(CBUtil.readValue(body)) : null;
                ConsistencyLevel serialConsistency = flags.contains((Object)Flag.SERIAL_CONSISTENCY) ? CBUtil.readConsistencyLevel(body) : ConsistencyLevel.SERIAL;
                long timestamp = Long.MIN_VALUE;
                if (flags.contains((Object)Flag.TIMESTAMP)) {
                    long ts = body.readLong();
                    if (ts == Long.MIN_VALUE) {
                        throw new ProtocolException(String.format("Out of bound timestamp, must be in [%d, %d] (got %d)", -9223372036854775807L, Long.MAX_VALUE, ts));
                    }
                    timestamp = ts;
                }
                options = new SpecificOptions(pageSize, pagingState, serialConsistency, timestamp);
            }
            DefaultQueryOptions opts = new DefaultQueryOptions(consistency, values, skipMetadata, options, version);
            return names == null ? opts : new OptionsWithNames(opts, names);
        }

        @Override
        public void encode(QueryOptions options, ByteBuf dest, int version) {
            assert (version >= 2);
            CBUtil.writeConsistencyLevel(options.getConsistency(), dest);
            EnumSet<Flag> flags = this.gatherFlags(options);
            dest.writeByte((int)((byte)Flag.serialize(flags)));
            if (flags.contains((Object)Flag.VALUES)) {
                CBUtil.writeValueList(options.getValues(), dest);
            }
            if (flags.contains((Object)Flag.PAGE_SIZE)) {
                dest.writeInt(options.getPageSize());
            }
            if (flags.contains((Object)Flag.PAGING_STATE)) {
                CBUtil.writeValue(options.getPagingState().serialize(), dest);
            }
            if (flags.contains((Object)Flag.SERIAL_CONSISTENCY)) {
                CBUtil.writeConsistencyLevel(options.getSerialConsistency(), dest);
            }
            if (flags.contains((Object)Flag.TIMESTAMP)) {
                dest.writeLong(options.getSpecificOptions().timestamp);
            }
        }

        @Override
        public int encodedSize(QueryOptions options, int version) {
            int size = 0;
            size += CBUtil.sizeOfConsistencyLevel(options.getConsistency());
            EnumSet<Flag> flags = this.gatherFlags(options);
            ++size;
            if (flags.contains((Object)Flag.VALUES)) {
                size += CBUtil.sizeOfValueList(options.getValues());
            }
            if (flags.contains((Object)Flag.PAGE_SIZE)) {
                size += 4;
            }
            if (flags.contains((Object)Flag.PAGING_STATE)) {
                size += CBUtil.sizeOfValue(options.getPagingState().serialize());
            }
            if (flags.contains((Object)Flag.SERIAL_CONSISTENCY)) {
                size += CBUtil.sizeOfConsistencyLevel(options.getSerialConsistency());
            }
            if (flags.contains((Object)Flag.TIMESTAMP)) {
                size += 8;
            }
            return size;
        }

        private EnumSet<Flag> gatherFlags(QueryOptions options) {
            EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
            if (options.getValues().size() > 0) {
                flags.add(Flag.VALUES);
            }
            if (options.skipMetadata()) {
                flags.add(Flag.SKIP_METADATA);
            }
            if (options.getPageSize() >= 0) {
                flags.add(Flag.PAGE_SIZE);
            }
            if (options.getPagingState() != null) {
                flags.add(Flag.PAGING_STATE);
            }
            if (options.getSerialConsistency() != ConsistencyLevel.SERIAL) {
                flags.add(Flag.SERIAL_CONSISTENCY);
            }
            if (options.getSpecificOptions().timestamp != Long.MIN_VALUE) {
                flags.add(Flag.TIMESTAMP);
            }
            return flags;
        }

        private static enum Flag {
            VALUES,
            SKIP_METADATA,
            PAGE_SIZE,
            PAGING_STATE,
            SERIAL_CONSISTENCY,
            TIMESTAMP,
            NAMES_FOR_VALUES;

            private static final Flag[] ALL_VALUES;

            public static EnumSet<Flag> deserialize(int flags) {
                EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
                for (int n = 0; n < ALL_VALUES.length; ++n) {
                    if ((flags & 1 << n) == 0) continue;
                    set.add(ALL_VALUES[n]);
                }
                return set;
            }

            public static int serialize(EnumSet<Flag> flags) {
                int i = 0;
                for (Flag flag : flags) {
                    i |= 1 << flag.ordinal();
                }
                return i;
            }

            static {
                ALL_VALUES = Flag.values();
            }
        }
    }

    static class SpecificOptions {
        private static final SpecificOptions DEFAULT = new SpecificOptions(-1, null, null, Long.MIN_VALUE);
        private final int pageSize;
        private final PagingState state;
        private final ConsistencyLevel serialConsistency;
        private final long timestamp;

        private SpecificOptions(int pageSize, PagingState state, ConsistencyLevel serialConsistency, long timestamp) {
            this.pageSize = pageSize;
            this.state = state;
            this.serialConsistency = serialConsistency == null ? ConsistencyLevel.SERIAL : serialConsistency;
            this.timestamp = timestamp;
        }
    }

    static class OptionsWithNames
    extends QueryOptionsWrapper {
        private final List<String> names;
        private List<ByteBuffer> orderedValues;

        OptionsWithNames(DefaultQueryOptions wrapped, List<String> names) {
            super(wrapped);
            this.names = names;
        }

        @Override
        public QueryOptions prepare(List<ColumnSpecification> specs) {
            super.prepare(specs);
            this.orderedValues = new ArrayList<ByteBuffer>(specs.size());
            block0: for (int i = 0; i < specs.size(); ++i) {
                String name = specs.get((int)i).name.toString();
                for (int j = 0; j < this.names.size(); ++j) {
                    if (!name.equals(this.names.get(j))) continue;
                    this.orderedValues.add(this.wrapped.getValues().get(j));
                    continue block0;
                }
            }
            return this;
        }

        @Override
        public List<ByteBuffer> getValues() {
            assert (this.orderedValues != null);
            return this.orderedValues;
        }
    }

    static class OptionsWithColumnSpecifications
    extends QueryOptionsWrapper {
        private final ImmutableList<ColumnSpecification> columnSpecs;

        OptionsWithColumnSpecifications(QueryOptions wrapped, List<ColumnSpecification> columnSpecs) {
            super(wrapped);
            this.columnSpecs = ImmutableList.copyOf(columnSpecs);
        }

        @Override
        public boolean hasColumnSpecifications() {
            return true;
        }

        @Override
        public ImmutableList<ColumnSpecification> getColumnSpecifications() {
            return this.columnSpecs;
        }
    }

    static class QueryOptionsWrapper
    extends QueryOptions {
        protected final QueryOptions wrapped;

        QueryOptionsWrapper(QueryOptions wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public List<ByteBuffer> getValues() {
            return this.wrapped.getValues();
        }

        @Override
        public ConsistencyLevel getConsistency() {
            return this.wrapped.getConsistency();
        }

        @Override
        public boolean skipMetadata() {
            return this.wrapped.skipMetadata();
        }

        @Override
        public int getProtocolVersion() {
            return this.wrapped.getProtocolVersion();
        }

        @Override
        SpecificOptions getSpecificOptions() {
            return this.wrapped.getSpecificOptions();
        }

        @Override
        public QueryOptions prepare(List<ColumnSpecification> specs) {
            this.wrapped.prepare(specs);
            return this;
        }
    }

    static class DefaultQueryOptions
    extends QueryOptions {
        private final ConsistencyLevel consistency;
        private final List<ByteBuffer> values;
        private final boolean skipMetadata;
        private final SpecificOptions options;
        private final transient int protocolVersion;

        DefaultQueryOptions(ConsistencyLevel consistency, List<ByteBuffer> values, boolean skipMetadata, SpecificOptions options, int protocolVersion) {
            this.consistency = consistency;
            this.values = values;
            this.skipMetadata = skipMetadata;
            this.options = options;
            this.protocolVersion = protocolVersion;
        }

        @Override
        public ConsistencyLevel getConsistency() {
            return this.consistency;
        }

        @Override
        public List<ByteBuffer> getValues() {
            return this.values;
        }

        @Override
        public boolean skipMetadata() {
            return this.skipMetadata;
        }

        @Override
        public int getProtocolVersion() {
            return this.protocolVersion;
        }

        @Override
        SpecificOptions getSpecificOptions() {
            return this.options;
        }
    }
}

