/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PagedRangeCommand;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.pager.AbstractQueryPager;
import org.apache.cassandra.service.pager.PagingState;

public class RangeSliceQueryPager
extends AbstractQueryPager {
    private final RangeSliceCommand command;
    private volatile DecoratedKey lastReturnedKey;
    private volatile CellName lastReturnedName;

    RangeSliceQueryPager(RangeSliceCommand command, ConsistencyLevel consistencyLevel, boolean localQuery) {
        super(consistencyLevel, command.maxResults, localQuery, command.keyspace, command.columnFamily, command.predicate, command.timestamp);
        this.command = command;
        assert (this.columnFilter instanceof SliceQueryFilter);
    }

    RangeSliceQueryPager(RangeSliceCommand command, ConsistencyLevel consistencyLevel, boolean localQuery, PagingState state) {
        this(command, consistencyLevel, localQuery);
        if (state != null) {
            this.lastReturnedKey = StorageService.getPartitioner().decorateKey(state.partitionKey);
            this.lastReturnedName = this.cfm.comparator.cellFromByteBuffer(state.cellName);
            this.restoreState(state.remaining, true);
        }
    }

    @Override
    public PagingState state() {
        return this.lastReturnedKey == null ? null : new PagingState(this.lastReturnedKey.getKey(), this.lastReturnedName.toByteBuffer(), this.maxRemaining());
    }

    @Override
    protected List<Row> queryNextPage(int pageSize, ConsistencyLevel consistencyLevel, boolean localQuery) throws RequestExecutionException {
        SliceQueryFilter rawFilter = (SliceQueryFilter)this.columnFilter;
        SliceQueryFilter sf = rawFilter.withUpdatedCount(Math.min(rawFilter.count, pageSize));
        AbstractBounds<RowPosition> keyRange = this.lastReturnedKey == null ? this.command.keyRange : this.makeIncludingKeyBounds(this.lastReturnedKey);
        Composite start = this.lastReturnedName == null || this.isDistinct() ? sf.start() : this.lastReturnedName;
        PagedRangeCommand pageCmd = new PagedRangeCommand(this.command.keyspace, this.command.columnFamily, this.command.timestamp, keyRange, sf, start, sf.finish(), this.command.rowFilter, pageSize, this.command.countCQL3Rows);
        return localQuery ? pageCmd.executeLocally() : StorageProxy.getRangeSlice(pageCmd, consistencyLevel);
    }

    @Override
    protected boolean containsPreviousLast(Row first) {
        Cell firstCell;
        if (this.lastReturnedKey == null || !this.lastReturnedKey.equals(first.key)) {
            return false;
        }
        if (this.isDistinct()) {
            return true;
        }
        Cell cell = firstCell = this.isReversed() ? RangeSliceQueryPager.lastCell(first.cf) : this.firstNonStaticCell(first.cf);
        if (firstCell == null) {
            return true;
        }
        CFMetaData metadata = Schema.instance.getCFMetaData(this.command.keyspace, this.command.columnFamily);
        return !first.cf.deletionInfo().isDeleted(firstCell) && firstCell.isLive(this.timestamp()) && firstCell.name().isSameCQL3RowAs(metadata.comparator, this.lastReturnedName);
    }

    @Override
    protected List<Row> discardFirst(List<Row> rows) {
        if (rows.isEmpty()) {
            return rows;
        }
        if (this.isDistinct()) {
            ArrayList<Row> newRows = new ArrayList<Row>(Math.max(1, rows.size() - 1));
            newRows.addAll(rows.subList(1, rows.size()));
            return newRows;
        }
        return super.discardFirst(rows);
    }

    private boolean isDistinct() {
        return !this.command.countCQL3Rows;
    }

    @Override
    protected boolean recordLast(Row last) {
        this.lastReturnedKey = last.key;
        this.lastReturnedName = (this.isReversed() ? this.firstNonStaticCell(last.cf) : RangeSliceQueryPager.lastCell(last.cf)).name();
        return true;
    }

    @Override
    protected boolean isReversed() {
        return ((SliceQueryFilter)this.command.predicate).reversed;
    }

    private AbstractBounds<RowPosition> makeIncludingKeyBounds(RowPosition lastReturnedKey) {
        AbstractBounds bounds = this.command.keyRange;
        if (bounds instanceof Range || bounds instanceof Bounds) {
            return new Bounds<RowPosition>(lastReturnedKey, (RowPosition)bounds.right);
        }
        return new IncludingExcludingBounds<RowPosition>(lastReturnedKey, (RowPosition)bounds.right);
    }
}

