/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.AbstractCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNames;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.MemtableAllocator;

public class BufferCell
extends AbstractCell {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new BufferCell(CellNames.simpleDense(ByteBuffer.allocate(1))));
    protected final CellName name;
    protected final ByteBuffer value;
    protected final long timestamp;

    BufferCell(CellName name) {
        this(name, ByteBufferUtil.EMPTY_BYTE_BUFFER);
    }

    public BufferCell(CellName name, ByteBuffer value) {
        this(name, value, 0L);
    }

    public BufferCell(CellName name, ByteBuffer value, long timestamp) {
        assert (name != null);
        assert (value != null);
        this.name = name;
        this.value = value;
        this.timestamp = timestamp;
    }

    @Override
    public Cell withUpdatedName(CellName newName) {
        return new BufferCell(newName, this.value, this.timestamp);
    }

    @Override
    public Cell withUpdatedTimestamp(long newTimestamp) {
        return new BufferCell(this.name, this.value, newTimestamp);
    }

    @Override
    public Cell withUpdatedTimestampAndLocalDeletionTime(long newTimestamp, int newLocalDeletionTime) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CellName name() {
        return this.name;
    }

    @Override
    public ByteBuffer value() {
        return this.value;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        return EMPTY_SIZE + this.name.unsharedHeapSizeExcludingData() + ObjectSizes.sizeOnHeapExcludingData(this.value);
    }

    @Override
    public Cell localCopy(CFMetaData metadata, AbstractAllocator allocator) {
        return new BufferCell(this.name.copy(metadata, allocator), allocator.clone(this.value), this.timestamp);
    }

    @Override
    public Cell localCopy(CFMetaData metadata, MemtableAllocator allocator, OpOrder.Group opGroup) {
        return allocator.clone(this, metadata, opGroup);
    }
}

