/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.Composites;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnSlice {
    public static final ColumnSlice ALL_COLUMNS = new ColumnSlice(Composites.EMPTY, Composites.EMPTY);
    public static final ColumnSlice[] ALL_COLUMNS_ARRAY = new ColumnSlice[]{ALL_COLUMNS};
    public final Composite start;
    public final Composite finish;

    public ColumnSlice(Composite start, Composite finish) {
        assert (start != null && finish != null);
        this.start = start;
        this.finish = finish;
    }

    public boolean isAlwaysEmpty(CellNameType comparator, boolean reversed) {
        Comparator<Composite> orderedComparator = reversed ? comparator.reverseComparator() : comparator;
        return !this.start.isEmpty() && !this.finish.isEmpty() && orderedComparator.compare(this.start, this.finish) > 0;
    }

    public boolean includes(Comparator<Composite> cmp, Composite name) {
        return !(!this.start.isEmpty() && cmp.compare(this.start, name) > 0 || !this.finish.isEmpty() && cmp.compare(this.finish, name) < 0);
    }

    public boolean isBefore(Comparator<Composite> cmp, Composite name) {
        return !this.finish.isEmpty() && cmp.compare(this.finish, name) < 0;
    }

    public boolean intersects(List<ByteBuffer> minCellNames, List<ByteBuffer> maxCellNames, CellNameType comparator, boolean reversed) {
        Composite sEnd;
        Composite sStart = reversed ? this.finish : this.start;
        Composite composite = sEnd = reversed ? this.start : this.finish;
        if (!sStart.isStatic() && this.compare(sStart, maxCellNames, comparator, true) > 0 || !sEnd.isStatic() && this.compare(sEnd, minCellNames, comparator, false) < 0) {
            return false;
        }
        for (int i = 0; i < minCellNames.size() && i < maxCellNames.size(); ++i) {
            ByteBuffer f;
            AbstractType<?> t = comparator.subtype(i);
            ByteBuffer s = i < sStart.size() ? sStart.get(i) : ByteBufferUtil.EMPTY_BYTE_BUFFER;
            ByteBuffer byteBuffer = f = i < sEnd.size() ? sEnd.get(i) : ByteBufferUtil.EMPTY_BYTE_BUFFER;
            if (i > 0 && (i < sEnd.size() && t.compare(f, minCellNames.get(i)) < 0 || i < sStart.size() && t.compare(s, maxCellNames.get(i)) > 0)) {
                return false;
            }
            if (i >= sStart.size() || i >= sEnd.size() || t.compare(s, f) != 0) break;
        }
        return true;
    }

    private int compare(Composite sliceBounds, List<ByteBuffer> sstableBounds, CellNameType comparator, boolean isSliceStart) {
        for (int i = 0; i < sstableBounds.size(); ++i) {
            if (i >= sliceBounds.size()) {
                return isSliceStart ? -1 : 1;
            }
            int comparison = comparator.subtype(i).compare(sliceBounds.get(i), sstableBounds.get(i));
            if (comparison == 0) continue;
            return comparison;
        }
        if (sliceBounds.size() > sstableBounds.size()) {
            return isSliceStart ? -1 : 1;
        }
        return 0;
    }

    public static boolean validateSlices(ColumnSlice[] slices, CellNameType type, boolean reversed) {
        Comparator<Composite> comparator = reversed ? type.reverseComparator() : type;
        for (int i = 0; i < slices.length; ++i) {
            Composite start = slices[i].start;
            Composite finish = slices[i].finish;
            if (start.isEmpty() || finish.isEmpty()) {
                if (start.isEmpty() && i > 0) {
                    return false;
                }
                if (!finish.isEmpty()) continue;
                return i == slices.length - 1;
            }
            if (i > 0 && comparator.compare(slices[i - 1].finish, start) >= 0) {
                return false;
            }
            if (comparator.compare(start, finish) <= 0) continue;
            return false;
        }
        return true;
    }

    public static ColumnSlice[] deoverlapSlices(ColumnSlice[] slices, final Comparator<Composite> comparator) {
        if (slices.length <= 1) {
            return slices;
        }
        Arrays.sort(slices, new Comparator<ColumnSlice>(){

            @Override
            public int compare(ColumnSlice s1, ColumnSlice s2) {
                if (s1.start.isEmpty() || s2.start.isEmpty()) {
                    if (s1.start.isEmpty() != s2.start.isEmpty()) {
                        return s1.start.isEmpty() ? -1 : 1;
                    }
                } else {
                    int c = comparator.compare(s1.start, s2.start);
                    if (c != 0) {
                        return c;
                    }
                }
                return s1.finish.isEmpty() || s2.finish.isEmpty() ? (s1.finish.isEmpty() ? 1 : -1) : comparator.compare(s1.finish, s2.finish);
            }
        });
        ArrayList<ColumnSlice> slicesCopy = new ArrayList<ColumnSlice>(slices.length);
        ColumnSlice last = slices[0];
        for (int i = 1; i < slices.length; ++i) {
            boolean includesFinish;
            ColumnSlice s2 = slices[i];
            boolean includesStart = last.includes(comparator, s2.start);
            boolean bl = includesFinish = s2.finish.isEmpty() ? last.finish.isEmpty() : last.includes(comparator, s2.finish);
            if (includesStart && includesFinish) continue;
            if (!includesStart && !includesFinish) {
                slicesCopy.add(last);
                last = s2;
                continue;
            }
            if (includesStart) {
                last = new ColumnSlice(last.start, s2.finish);
                continue;
            }
            assert (!includesFinish);
        }
        slicesCopy.add(last);
        return slicesCopy.toArray(new ColumnSlice[slicesCopy.size()]);
    }

    public final int hashCode() {
        int hashCode = 31 + this.start.hashCode();
        return 31 * hashCode + this.finish.hashCode();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ColumnSlice)) {
            return false;
        }
        ColumnSlice that = (ColumnSlice)o;
        return this.start.equals(that.start) && this.finish.equals(that.finish);
    }

    public String toString() {
        return "[" + ByteBufferUtil.bytesToHex(this.start.toByteBuffer()) + ", " + ByteBufferUtil.bytesToHex(this.finish.toByteBuffer()) + "]";
    }

    public static class Serializer
    implements IVersionedSerializer<ColumnSlice> {
        private final CType type;

        public Serializer(CType type) {
            this.type = type;
        }

        @Override
        public void serialize(ColumnSlice cs, DataOutputPlus out, int version) throws IOException {
            CType.Serializer serializer = this.type.serializer();
            serializer.serialize(cs.start, out);
            serializer.serialize(cs.finish, out);
        }

        @Override
        public ColumnSlice deserialize(DataInput in, int version) throws IOException {
            CType.Serializer serializer = this.type.serializer();
            Composite start = (Composite)serializer.deserialize(in);
            Composite finish = (Composite)serializer.deserialize(in);
            return new ColumnSlice(start, finish);
        }

        @Override
        public long serializedSize(ColumnSlice cs, int version) {
            CType.Serializer serializer = this.type.serializer();
            return serializer.serializedSize(cs.start, TypeSizes.NATIVE) + serializer.serializedSize(cs.finish, TypeSizes.NATIVE);
        }
    }
}

