/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.compress.ICompressor;

public class LZ4Compressor
implements ICompressor {
    private static final int INTEGER_BYTES = 4;
    @VisibleForTesting
    public static final LZ4Compressor instance = new LZ4Compressor();
    private final net.jpountz.lz4.LZ4Compressor compressor;
    private final LZ4FastDecompressor decompressor;

    public static LZ4Compressor create(Map<String, String> args) {
        return instance;
    }

    private LZ4Compressor() {
        LZ4Factory lz4Factory = LZ4Factory.fastestInstance();
        this.compressor = lz4Factory.fastCompressor();
        this.decompressor = lz4Factory.fastDecompressor();
    }

    @Override
    public int initialCompressedBufferLength(int chunkLength) {
        return 4 + this.compressor.maxCompressedLength(chunkLength);
    }

    @Override
    public void compress(ByteBuffer input, ByteBuffer output) throws IOException {
        int len = input.remaining();
        output.put((byte)len);
        output.put((byte)(len >>> 8));
        output.put((byte)(len >>> 16));
        output.put((byte)(len >>> 24));
        try {
            this.compressor.compress(input, output);
        }
        catch (LZ4Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int uncompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        int compressedLength;
        int decompressedLength = input[inputOffset] & 0xFF | (input[inputOffset + 1] & 0xFF) << 8 | (input[inputOffset + 2] & 0xFF) << 16 | (input[inputOffset + 3] & 0xFF) << 24;
        try {
            compressedLength = this.decompressor.decompress(input, inputOffset + 4, output, outputOffset, decompressedLength);
        }
        catch (LZ4Exception e) {
            throw new IOException(e);
        }
        if (compressedLength != inputLength - 4) {
            throw new IOException("Compressed lengths mismatch");
        }
        return decompressedLength;
    }

    @Override
    public void uncompress(ByteBuffer input, ByteBuffer output) throws IOException {
        int decompressedLength = input.get() & 0xFF | (input.get() & 0xFF) << 8 | (input.get() & 0xFF) << 16 | (input.get() & 0xFF) << 24;
        try {
            int compressedLength = this.decompressor.decompress(input, input.position(), output, output.position(), decompressedLength);
            input.position(input.position() + compressedLength);
            output.position(output.position() + decompressedLength);
        }
        catch (LZ4Exception e) {
            throw new IOException(e);
        }
        if (input.remaining() > 0) {
            throw new IOException("Compressed lengths mismatch - " + input.remaining() + " bytes remain");
        }
    }

    @Override
    public Set<String> supportedOptions() {
        return new HashSet<String>(Arrays.asList("crc_check_chance"));
    }

    @Override
    public BufferType preferredBufferType() {
        return BufferType.OFF_HEAP;
    }

    @Override
    public boolean supports(BufferType bufferType) {
        return true;
    }
}

