/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.pig;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.TableMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.hadoop.pig.ColumnInfo;

class TableInfo
implements Serializable {
    private final List<ColumnInfo> columns;
    private final List<ColumnInfo> partitionKey;
    private final String name;

    public TableInfo(TableMetadata tableMetadata) {
        List cmColumns = tableMetadata.getColumns();
        this.columns = new ArrayList<ColumnInfo>(cmColumns.size());
        for (ColumnMetadata cm : cmColumns) {
            this.columns.add(new ColumnInfo(this, cm));
        }
        List cmPartitionKey = tableMetadata.getPartitionKey();
        this.partitionKey = new ArrayList<ColumnInfo>(cmPartitionKey.size());
        for (ColumnMetadata cm : cmPartitionKey) {
            this.partitionKey.add(new ColumnInfo(this, cm));
        }
        this.name = tableMetadata.getName();
    }

    public List<ColumnInfo> getPartitionKey() {
        return this.partitionKey;
    }

    public List<ColumnInfo> getColumns() {
        return this.columns;
    }

    public String getName() {
        return this.name;
    }
}

