/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Arrays;

public enum Stage {
    READ,
    MUTATION,
    COUNTER_MUTATION,
    GOSSIP,
    REQUEST_RESPONSE,
    ANTI_ENTROPY,
    MIGRATION,
    MISC,
    TRACING,
    INTERNAL_RESPONSE,
    READ_REPAIR;


    public static Iterable<Stage> jmxEnabledStages() {
        return Iterables.filter(Arrays.asList(Stage.values()), (Predicate)new Predicate<Stage>(){

            public boolean apply(Stage stage) {
                return stage != TRACING;
            }
        });
    }

    public String getJmxType() {
        switch (this) {
            case ANTI_ENTROPY: 
            case GOSSIP: 
            case MIGRATION: 
            case MISC: 
            case TRACING: 
            case INTERNAL_RESPONSE: {
                return "internal";
            }
            case MUTATION: 
            case COUNTER_MUTATION: 
            case READ: 
            case REQUEST_RESPONSE: 
            case READ_REPAIR: {
                return "request";
            }
        }
        throw new AssertionError((Object)("Unknown stage " + (Object)((Object)this)));
    }

    public String getJmxName() {
        String name = "";
        for (String word : this.toString().split("_")) {
            name = name + word.substring(0, 1) + word.substring(1).toLowerCase();
        }
        return name + "Stage";
    }
}

