/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import org.apache.cassandra.concurrent.SEPExecutor;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.metrics.ThreadPoolMetricNameFactory;

public class SEPMetrics {
    public final Gauge<Integer> activeTasks;
    public final Counter totalBlocked;
    public final Counter currentBlocked;
    public final Gauge<Long> completedTasks;
    public final Gauge<Long> pendingTasks;
    public final Gauge<Integer> maxPoolSize;
    private MetricNameFactory factory;

    public SEPMetrics(final SEPExecutor executor, String path, String poolName) {
        this.factory = new ThreadPoolMetricNameFactory("ThreadPools", path, poolName);
        this.activeTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("ActiveTasks"), new Gauge<Integer>(){

            public Integer getValue() {
                return executor.getActiveCount();
            }
        });
        this.pendingTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("PendingTasks"), new Gauge<Long>(){

            public Long getValue() {
                return executor.getPendingTasks();
            }
        });
        this.totalBlocked = CassandraMetricsRegistry.Metrics.counter(this.factory.createMetricName("TotalBlockedTasks"));
        this.currentBlocked = CassandraMetricsRegistry.Metrics.counter(this.factory.createMetricName("CurrentlyBlockedTasks"));
        this.completedTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("CompletedTasks"), new Gauge<Long>(){

            public Long getValue() {
                return executor.getCompletedTasks();
            }
        });
        this.maxPoolSize = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("MaxPoolSize"), new Gauge<Integer>(){

            public Integer getValue() {
                return executor.maxWorkers;
            }
        });
    }

    public void release() {
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("ActiveTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("PendingTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("CompletedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("TotalBlockedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("CurrentlyBlockedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("MaxPoolSize"));
    }
}

