/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.cql3.Json;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.EmptyType;
import org.apache.cassandra.db.marshal.FrozenType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.SetSerializer;

public class SetType<T>
extends CollectionType<Set<T>> {
    private static final Map<AbstractType<?>, SetType> instances = new HashMap();
    private static final Map<AbstractType<?>, SetType> frozenInstances = new HashMap();
    private final AbstractType<T> elements;
    private final SetSerializer<T> serializer;
    private final boolean isMultiCell;

    public static SetType<?> getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> l = parser.getTypeParameters();
        if (l.size() != 1) {
            throw new ConfigurationException("SetType takes exactly 1 type parameter");
        }
        return SetType.getInstance(l.get(0), true);
    }

    public static synchronized <T> SetType<T> getInstance(AbstractType<T> elements, boolean isMultiCell) {
        Map<AbstractType<?>, SetType> internMap = isMultiCell ? instances : frozenInstances;
        SetType<T> t = internMap.get(elements);
        if (t == null) {
            t = new SetType<T>(elements, isMultiCell);
            internMap.put(elements, t);
        }
        return t;
    }

    public SetType(AbstractType<T> elements, boolean isMultiCell) {
        super(CollectionType.Kind.SET);
        this.elements = elements;
        this.serializer = SetSerializer.getInstance(elements.getSerializer());
        this.isMultiCell = isMultiCell;
    }

    public AbstractType<T> getElementsType() {
        return this.elements;
    }

    @Override
    public AbstractType<T> nameComparator() {
        return this.elements;
    }

    @Override
    public AbstractType<?> valueComparator() {
        return EmptyType.instance;
    }

    @Override
    public boolean isMultiCell() {
        return this.isMultiCell;
    }

    @Override
    public AbstractType<?> freeze() {
        if (this.isMultiCell) {
            return SetType.getInstance(this.elements, false);
        }
        return this;
    }

    @Override
    public boolean isCompatibleWithFrozen(CollectionType<?> previous) {
        assert (!this.isMultiCell);
        return this.elements.isCompatibleWith(((SetType)previous).elements);
    }

    @Override
    public boolean isValueCompatibleWithFrozen(CollectionType<?> previous) {
        return this.isCompatibleWithFrozen(previous);
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return ListType.compareListOrSet(this.elements, o1, o2);
    }

    @Override
    public SetSerializer<T> getSerializer() {
        return this.serializer;
    }

    @Override
    public boolean isByteOrderComparable() {
        return this.elements.isByteOrderComparable();
    }

    @Override
    public String toString(boolean ignoreFreezing) {
        boolean includeFrozenType = !ignoreFreezing && !this.isMultiCell();
        StringBuilder sb = new StringBuilder();
        if (includeFrozenType) {
            sb.append(FrozenType.class.getName()).append("(");
        }
        sb.append(this.getClass().getName());
        sb.append(TypeParser.stringifyTypeParameters(Collections.singletonList(this.elements), ignoreFreezing || !this.isMultiCell));
        if (includeFrozenType) {
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public List<ByteBuffer> serializedValues(List<Cell> cells) {
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(cells.size());
        for (Cell c : cells) {
            bbs.add(c.name().collectionElement());
        }
        return bbs;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (parsed instanceof String) {
            parsed = Json.decodeJson((String)parsed);
        }
        if (!(parsed instanceof List)) {
            throw new MarshalException(String.format("Expected a list (representing a set), but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
        List list = (List)parsed;
        HashSet<Term> terms = new HashSet<Term>(list.size());
        for (Object element : list) {
            if (element == null) {
                throw new MarshalException("Invalid null element in set");
            }
            terms.add(this.elements.fromJSONObject(element));
        }
        return new Sets.DelayedValue(this.elements, terms);
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        return ListType.setOrListToJsonString(buffer, this.elements, protocolVersion);
    }
}

