/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.auth.AllowAllAuthenticator;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.auth.RolesCacheMBean;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RolesCache
implements RolesCacheMBean {
    private static final Logger logger = LoggerFactory.getLogger(RolesCache.class);
    private final String MBEAN_NAME = "org.apache.cassandra.auth:type=RolesCache";
    private final ThreadPoolExecutor cacheRefreshExecutor = new DebuggableThreadPoolExecutor("RolesCacheRefresh", 5);
    private final IRoleManager roleManager;
    private volatile LoadingCache<RoleResource, Set<RoleResource>> cache;

    public RolesCache(IRoleManager roleManager) {
        this.roleManager = roleManager;
        this.cache = this.initCache(null);
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(this, new ObjectName("org.apache.cassandra.auth:type=RolesCache"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Set<RoleResource> getRoles(RoleResource role) {
        if (this.cache == null) {
            return this.roleManager.getRoles(role, true);
        }
        try {
            return (Set)this.cache.get((Object)role);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void invalidate() {
        this.cache = this.initCache(null);
    }

    @Override
    public void setValidity(int validityPeriod) {
        DatabaseDescriptor.setRolesValidity(validityPeriod);
        this.cache = this.initCache(this.cache);
    }

    @Override
    public int getValidity() {
        return DatabaseDescriptor.getRolesValidity();
    }

    @Override
    public void setUpdateInterval(int updateInterval) {
        DatabaseDescriptor.setRolesUpdateInterval(updateInterval);
        this.cache = this.initCache(this.cache);
    }

    @Override
    public int getUpdateInterval() {
        return DatabaseDescriptor.getRolesUpdateInterval();
    }

    private LoadingCache<RoleResource, Set<RoleResource>> initCache(LoadingCache<RoleResource, Set<RoleResource>> existing) {
        if (DatabaseDescriptor.getAuthenticator() instanceof AllowAllAuthenticator) {
            return null;
        }
        if (DatabaseDescriptor.getRolesValidity() <= 0) {
            return null;
        }
        LoadingCache newcache = CacheBuilder.newBuilder().refreshAfterWrite((long)DatabaseDescriptor.getRolesUpdateInterval(), TimeUnit.MILLISECONDS).expireAfterWrite((long)DatabaseDescriptor.getRolesValidity(), TimeUnit.MILLISECONDS).maximumSize((long)DatabaseDescriptor.getRolesCacheMaxEntries()).build((CacheLoader)new CacheLoader<RoleResource, Set<RoleResource>>(){

            public Set<RoleResource> load(RoleResource primaryRole) {
                return RolesCache.this.roleManager.getRoles(primaryRole, true);
            }

            public ListenableFuture<Set<RoleResource>> reload(final RoleResource primaryRole, Set<RoleResource> oldValue) {
                ListenableFutureTask task = ListenableFutureTask.create((Callable)new Callable<Set<RoleResource>>(){

                    @Override
                    public Set<RoleResource> call() throws Exception {
                        try {
                            return RolesCache.this.roleManager.getRoles(primaryRole, true);
                        }
                        catch (Exception e) {
                            logger.debug("Error performing async refresh of user roles", (Throwable)e);
                            throw e;
                        }
                    }
                });
                RolesCache.this.cacheRefreshExecutor.execute((Runnable)task);
                return task;
            }
        });
        if (existing != null) {
            newcache.putAll((Map)existing.asMap());
        }
        return newcache;
    }
}

