/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.tracing.ExpiredTraceState;
import org.apache.cassandra.tracing.TraceKeyspace;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracing {
    public static final String TRACE_HEADER = "TraceSession";
    public static final String TRACE_TYPE = "TraceType";
    static final Logger logger = LoggerFactory.getLogger(Tracing.class);
    private final InetAddress localAddress = FBUtilities.getLocalAddress();
    private final ThreadLocal<TraceState> state = new ThreadLocal();
    private final ConcurrentMap<UUID, TraceState> sessions = new ConcurrentHashMap<UUID, TraceState>();
    public static final Tracing instance = new Tracing();

    public UUID getSessionId() {
        assert (Tracing.isTracing());
        return this.state.get().sessionId;
    }

    public TraceType getTraceType() {
        assert (Tracing.isTracing());
        return this.state.get().traceType;
    }

    public int getTTL() {
        assert (Tracing.isTracing());
        return this.state.get().ttl;
    }

    public static boolean isTracing() {
        return Tracing.instance.state.get() != null;
    }

    public UUID newSession(Connection connection) {
        return this.newSession(connection, TraceType.QUERY);
    }

    public UUID newSession(TraceType traceType) {
        return this.newSession(null, traceType);
    }

    public UUID newSession(Connection connection, TraceType traceType) {
        return this.newSession(connection, (UUID)TimeUUIDType.instance.compose(ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes())), traceType, false);
    }

    public UUID newSession(Connection connection, UUID sessionId) {
        return this.newSession(connection, sessionId, TraceType.QUERY, true);
    }

    private UUID newSession(Connection connection, UUID sessionId, TraceType traceType, boolean withFinishEvent) {
        assert (this.state.get() == null);
        TraceState ts = new TraceState(this.localAddress, connection, sessionId, traceType, withFinishEvent);
        this.state.set(ts);
        this.sessions.put(sessionId, ts);
        return sessionId;
    }

    public void doneWithNonLocalSession(TraceState state) {
        if (state.releaseReference() == 0) {
            this.sessions.remove(state.sessionId);
        }
    }

    public void stopSession() {
        TraceState state = this.state.get();
        if (state == null) {
            logger.debug("request complete");
        } else {
            int elapsed = state.elapsed();
            ByteBuffer sessionId = state.sessionIdBytes;
            int ttl = state.ttl;
            state.executeMutation(TraceKeyspace.makeStopSessionMutation(sessionId, elapsed, ttl));
            state.stop();
            this.sessions.remove(state.sessionId);
            this.state.set(null);
        }
    }

    public TraceState get() {
        return this.state.get();
    }

    public TraceState get(UUID sessionId) {
        return (TraceState)this.sessions.get(sessionId);
    }

    public void set(TraceState tls) {
        this.state.set(tls);
    }

    public TraceState begin(String request, Map<String, String> parameters) {
        return this.begin(request, null, parameters);
    }

    public TraceState begin(String request, InetAddress client, Map<String, String> parameters) {
        assert (Tracing.isTracing());
        TraceState state = this.state.get();
        long startedAt = System.currentTimeMillis();
        ByteBuffer sessionId = state.sessionIdBytes;
        String command = state.traceType.toString();
        int ttl = state.ttl;
        state.executeMutation(TraceKeyspace.makeStartSessionMutation(sessionId, client, parameters, request, startedAt, command, ttl));
        return state;
    }

    public TraceState initializeFromMessage(MessageIn<?> message) {
        byte[] sessionBytes = message.parameters.get(TRACE_HEADER);
        if (sessionBytes == null) {
            return null;
        }
        assert (sessionBytes.length == 16);
        UUID sessionId = UUIDGen.getUUID(ByteBuffer.wrap(sessionBytes));
        TraceState ts = (TraceState)this.sessions.get(sessionId);
        if (ts != null && ts.acquireReference()) {
            return ts;
        }
        TraceType traceType = TraceType.QUERY;
        byte[] tmpBytes = message.parameters.get(TRACE_TYPE);
        if (tmpBytes != null) {
            traceType = TraceType.deserialize(tmpBytes[0]);
        }
        if (message.verb == MessagingService.Verb.REQUEST_RESPONSE) {
            return new ExpiredTraceState(sessionId, traceType);
        }
        ts = new TraceState(message.from, sessionId, traceType);
        this.sessions.put(sessionId, ts);
        return ts;
    }

    public static void traceRepair(String format, Object ... args) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, args);
    }

    public static void trace(String message) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(message);
    }

    public static void trace(String format, Object arg) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, arg);
    }

    public static void trace(String format, Object arg1, Object arg2) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, arg1, arg2);
    }

    public static void trace(String format, Object ... args) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, args);
    }

    public static enum TraceType {
        NONE,
        QUERY,
        REPAIR;

        private static final TraceType[] ALL_VALUES;
        private static final int[] TTLS;

        public static TraceType deserialize(byte b) {
            if (b < 0 || ALL_VALUES.length <= b) {
                return NONE;
            }
            return ALL_VALUES[b];
        }

        public static byte serialize(TraceType value) {
            return (byte)value.ordinal();
        }

        public int getTTL() {
            return TTLS[this.ordinal()];
        }

        static {
            ALL_VALUES = TraceType.values();
            TTLS = new int[]{DatabaseDescriptor.getTracetypeQueryTTL(), DatabaseDescriptor.getTracetypeQueryTTL(), DatabaseDescriptor.getTracetypeRepairTTL()};
        }
    }
}

